/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.actions.SeparatorAction;
import bibliothek.gui.dock.common.DefaultMultipleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.fife.rsta.ac.AbstractSourceTree;
import org.fife.rsta.ac.LanguageSupportFactory;
import org.fife.rsta.ac.java.tree.JavaOutlineTree;
import org.fife.rsta.ac.xml.tree.XmlOutlineTree;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rsyntaxtextarea.FileLocation;
import org.fife.ui.rsyntaxtextarea.RSTA;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.RUndoManager;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.Editable;
import org.yaoqiang.asaf.FileAssociations;
import org.yaoqiang.asaf.Icons;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.Utils;
import org.yaoqiang.asaf.frame.SaveFileAction;
import org.yaoqiang.asaf.frame.theme.eclipse.CloseFileTabsAction;

public class FileTab
extends DefaultMultipleCDockable
implements Editable {
    protected TextEditorPane pane;
    protected AbstractSourceTree sourceTree;
    private JComboBox searchCB = new JComboBox();
    private JCheckBox caseCB;
    private JCheckBox wordCB;
    private JCheckBox markAllCB;
    private JCheckBox regexCB;
    private File file;
    private File project;
    private boolean modified = false;
    private boolean newFile = false;
    protected DocumentListener documentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            FileTab.this.setModified(true);
        }
    };
    private HyperlinkListener hyperlinkListener = new HyperlinkListener(){

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                URL uRL = hyperlinkEvent.getURL();
                if (uRL == null) {
                    UIManager.getLookAndFeel().provideErrorFeedback(null);
                } else {
                    Utils.openURL(uRL.toString());
                }
            }
        }
    };
    private CFocusListener focusListener = new CFocusListener(){

        @Override
        public void focusGained(CDockable cDockable) {
            FileTab fileTab = (FileTab)cDockable;
            ASAF.setSelectedFileTab(fileTab);
            ASAF.setFrameTitle(fileTab.getFilePath(), fileTab.getFile());
            ASAF.refreshState("file");
            ASAF.refreshState("edit");
            ASAF.fireViewEvent("selectFile", fileTab.getFile());
        }

        @Override
        public void focusLost(CDockable cDockable) {
        }
    };

    public FileTab(File file) {
        this(file, null, true, false);
    }

    public FileTab(File file, File file2) {
        this(file, file2, true, false);
    }

    public FileTab(File file, boolean bl) {
        this(file, null, true, bl);
    }

    public FileTab(File file, File file2, boolean bl) {
        this(file, file2, bl, false);
    }

    public FileTab(File file, File file2, boolean bl, boolean bl2) {
        super(null, new CAction[0]);
        this.file = file;
        this.project = file2;
        this.newFile = bl2;
        this.setExternalizable(false);
        this.setCloseable(true);
        DefaultDockActionSource defaultDockActionSource = new DefaultDockActionSource(new DockAction[0]);
        defaultDockActionSource.add(new CloseFileTabsAction(this, true).intern());
        defaultDockActionSource.add(new CloseFileTabsAction(this).intern());
        defaultDockActionSource.add(SeparatorAction.MENU_SEPARATOR);
        this.intern().setActionOffers(defaultDockActionSource);
        this.addFocusListener(this.focusListener);
        this.caseCB = new JCheckBox(ResourceMap.getString("case.Label.text", new String[0]));
        this.wordCB = new JCheckBox(ResourceMap.getString("word.Label.text", new String[0]));
        this.markAllCB = new JCheckBox(ResourceMap.getString("markAll.Label.text", new String[0]), true);
        this.regexCB = new JCheckBox(ResourceMap.getString("regex.Label.text", new String[0]));
        this.initMainPane(bl);
    }

    public boolean isNewFile() {
        return this.newFile;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isSavable() {
        return true;
    }

    public boolean isReadOnly() {
        return this.pane == null ? true : this.pane.isReadOnly();
    }

    public boolean isSingleTab() {
        DockStation dockStation = this.intern().getDockParent();
        if (dockStation == null || dockStation.getDockableCount() == 1) {
            return true;
        }
        return dockStation.getDockableCount() == 2 && !(((CommonDockable)dockStation.getDockable(0)).getDockable() instanceof FileTab);
    }

    public boolean isFileExists(File file) {
        return this.getFileTab(file) != null;
    }

    public FileTab getFileTab(boolean bl) {
        DockStation dockStation = this.intern().getDockParent();
        if (dockStation == null) {
            return null;
        }
        int n = this.getFileTabIndex();
        if (bl) {
            if (n + 1 < dockStation.getDockableCount()) {
                return (FileTab)((CommonDockable)dockStation.getDockable(n + 1)).getDockable();
            }
            return (FileTab)((CommonDockable)dockStation.getDockable(0)).getDockable();
        }
        if (n - 1 >= 0) {
            return (FileTab)((CommonDockable)dockStation.getDockable(n - 1)).getDockable();
        }
        return (FileTab)((CommonDockable)dockStation.getDockable(dockStation.getDockableCount() - 1)).getDockable();
    }

    private FileTab getNearbyFileTab() {
        DockStation dockStation = this.intern().getDockParent();
        if (dockStation == null) {
            return null;
        }
        int n = this.getFileTabIndex();
        if (n + 1 < dockStation.getDockableCount() && ((CommonDockable)dockStation.getDockable(n + 1)).getDockable() instanceof FileTab) {
            return (FileTab)((CommonDockable)dockStation.getDockable(n + 1)).getDockable();
        }
        if (n - 1 >= 0 && ((CommonDockable)dockStation.getDockable(n - 1)).getDockable() instanceof FileTab) {
            return (FileTab)((CommonDockable)dockStation.getDockable(n - 1)).getDockable();
        }
        return null;
    }

    public int getFileTabIndex() {
        DockStation dockStation = this.intern().getDockParent();
        if (dockStation == null) {
            return 0;
        }
        int n = 0;
        while (n < dockStation.getDockableCount()) {
            FileTab fileTab;
            Dockable dockable = dockStation.getDockable(n);
            if (((CommonDockable)dockable).getDockable() instanceof FileTab && this.file.equals((fileTab = (FileTab)((CommonDockable)dockable).getDockable()).getFile())) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public void changeFile(String string, String string2, File file) {
        string2 = string2.isEmpty() ? File.separator : String.valueOf(File.separator) + string2 + File.separator;
        FileTab fileTab = this.getFileTab(file);
        if (fileTab != null) {
            File file2 = new File(String.valueOf(string) + string2 + file.getName());
            fileTab.setFile(file2);
            fileTab.reload();
            if (fileTab == this) {
                fileTab.toFront();
            }
        }
    }

    public Set<FileTab> getAllFileTabs() {
        HashSet<FileTab> hashSet = new HashSet<FileTab>();
        DockStation dockStation = this.intern().getDockParent();
        if (dockStation == null) {
            return hashSet;
        }
        int n = 0;
        while (n < dockStation.getDockableCount()) {
            Dockable dockable = dockStation.getDockable(n);
            if (dockable instanceof CommonDockable && ((CommonDockable)dockable).getDockable() instanceof FileTab) {
                hashSet.add((FileTab)((CommonDockable)dockable).getDockable());
            }
            ++n;
        }
        return hashSet;
    }

    public FileTab getFileTab(File file) {
        if (this.file.equals(file)) {
            return this;
        }
        DockStation dockStation = this.intern().getDockParent();
        if (dockStation == null) {
            return null;
        }
        int n = 0;
        while (n < dockStation.getDockableCount()) {
            FileTab fileTab;
            Dockable dockable = dockStation.getDockable(n);
            if (((CommonDockable)dockable).getDockable() instanceof FileTab && file.equals((fileTab = (FileTab)((CommonDockable)dockable).getDockable()).getFile())) {
                return fileTab;
            }
            ++n;
        }
        return null;
    }

    public Set<FileTab> getOrphanTabs() {
        HashSet<FileTab> hashSet = new HashSet<FileTab>();
        DockStation dockStation = this.intern().getDockParent();
        if (dockStation == null) {
            return hashSet;
        }
        int n = 0;
        while (n < dockStation.getDockableCount()) {
            FileTab fileTab;
            Dockable dockable = dockStation.getDockable(n);
            if (((CommonDockable)dockable).getDockable() instanceof FileTab && !(fileTab = (FileTab)((CommonDockable)dockable).getDockable()).getFile().exists()) {
                hashSet.add(fileTab);
            }
            ++n;
        }
        return hashSet;
    }

    public boolean closeTab() {
        FileTab fileTab = null;
        if (this.isSingleTab()) {
            ASAF.clearSelectedFileTab();
        } else {
            fileTab = this.getNearbyFileTab();
        }
        boolean bl = this.close();
        if (bl) {
            if (fileTab != null) {
                fileTab.toFront();
            } else {
                ASAF.fireViewEvent("selectFile", null);
            }
        }
        return bl;
    }

    private boolean close() {
        if (this.isModified()) {
            int n = JOptionPane.showConfirmDialog(null, ResourceMap.getString("saveFileChanges.text", this.file.getName()), ResourceMap.getString("confirmSave.Dialog.title", new String[0]), 1);
            if (n == 2 || n == -1) {
                return false;
            }
            if (n == 1) {
                this.setVisible(false);
                return true;
            }
            if (this.isNewFile()) {
                new SaveFileAction().saveToFile(this);
                return true;
            }
            this.save();
        }
        this.setVisible(false);
        return true;
    }

    protected void save() {
        try {
            this.pane.save();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean canUndo() {
        return TextEditorPane.getAction(6).isEnabled();
    }

    public boolean canRedo() {
        return TextEditorPane.getAction(4).isEnabled();
    }

    @Override
    public boolean isCuttable() {
        return TextEditorPane.getAction(1).isEnabled();
    }

    @Override
    public boolean isCopyable() {
        return TextEditorPane.getAction(0).isEnabled();
    }

    @Override
    public boolean isPastable() {
        return TextEditorPane.getAction(3).isEnabled();
    }

    @Override
    public boolean isDeletable() {
        return TextEditorPane.getAction(2).isEnabled();
    }

    public void undo() {
        TextEditorPane.getAction(6).actionPerformed(null);
    }

    public void redo() {
        TextEditorPane.getAction(4).actionPerformed(null);
    }

    @Override
    public void cut(ActionEvent actionEvent) {
        TextEditorPane.getAction(1).actionPerformed(actionEvent);
    }

    @Override
    public void copy(ActionEvent actionEvent) {
        TextEditorPane.getAction(0).actionPerformed(actionEvent);
    }

    @Override
    public void paste(ActionEvent actionEvent) {
        TextEditorPane.getAction(3).actionPerformed(actionEvent);
    }

    @Override
    public void delete(ActionEvent actionEvent) {
        TextEditorPane.getAction(2).actionPerformed(actionEvent);
    }

    public void changeId() {
    }

    public JComponent getOutline() {
        return null;
    }

    public String getFilePath() {
        if (this.getProject() != null) {
            return String.valueOf(this.getProject().getName()) + this.file.getAbsolutePath().substring(this.getProject().getAbsolutePath().length());
        }
        return this.file.getAbsolutePath();
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getProject() {
        return this.project;
    }

    public TextEditorPane getTextEditorPane() {
        return this.pane;
    }

    public JTree getNavigator() {
        return this.sourceTree;
    }

    public boolean setModified(boolean bl) {
        String string;
        boolean bl2 = this.modified;
        this.modified = bl;
        if (bl2 != bl) {
            string = this.file.getName();
            if (bl) {
                string = "*" + string;
            }
        } else {
            return true;
        }
        this.setTitleText(string);
        ASAF.refreshState("file");
        return true;
    }

    protected void initMainPane(boolean bl) {
        this.setLayout(new BorderLayout());
        if (bl) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(Box.createHorizontalStrut(5));
            jPanel.add(this.createSearchPanel());
            this.add(jPanel, "North");
        }
        this.add(this.createTextPane());
        this.add(this.createErrorStrip(), "After");
    }

    public Component createSearchPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        JLabel jLabel = new JLabel(String.valueOf(ResourceMap.getString("find.Label.text", new String[0])) + ": ");
        this.searchCB.setEditable(true);
        Dimension dimension = new Dimension(120, 25);
        this.searchCB.setMinimumSize(new Dimension(dimension));
        this.searchCB.setMaximumSize(new Dimension(dimension));
        this.searchCB.setPreferredSize(new Dimension(dimension));
        JButton jButton = new JButton(ResourceMap.getString("previous.Button.text", new String[0]));
        final JButton jButton2 = new JButton(ResourceMap.getString("next.Button.text", new String[0]));
        jPanel.add(jLabel);
        jPanel.add(this.searchCB);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jButton2);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.caseCB);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.wordCB);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.markAllCB);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.regexCB);
        this.searchCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                if (jComboBox.getSelectedItem().toString().length() > 0) {
                    jButton2.doClick(0);
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileTab.this.findString(false);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileTab.this.findString(true);
            }
        });
        return jPanel;
    }

    protected void findString(boolean bl) {
        if (this.searchCB.getSelectedItem() == null) {
            return;
        }
        String string = this.searchCB.getSelectedItem().toString();
        this.addItemToCombo(string);
        SearchContext searchContext = new SearchContext();
        searchContext.setSearchFor(string);
        searchContext.setMatchCase(this.caseCB.isSelected());
        searchContext.setMarkAll(this.markAllCB.isSelected());
        searchContext.setRegularExpression(this.regexCB.isSelected());
        searchContext.setSearchForward(bl);
        searchContext.setWholeWord(this.wordCB.isSelected());
        SearchResult searchResult = SearchEngine.find(this.pane, searchContext);
        boolean bl2 = searchResult.wasFound();
        if (!bl2) {
            this.pane.setCaretPosition(0);
            JOptionPane.showMessageDialog(null, ResourceMap.getString("searchFinished.text", new String[0]), ASAF.getTitle(), 1);
        }
    }

    private void addItemToCombo(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        int n = 0;
        while (n < this.searchCB.getItemCount()) {
            if (this.searchCB.getItemAt(n).toString().equals(string)) {
                return;
            }
            ++n;
        }
        this.searchCB.addItem(string);
    }

    protected RTextScrollPane createTextPane() {
        this.pane = new TextEditorPane(){
            private static final long serialVersionUID = -9187800576573523212L;

            @Override
            protected RUndoManager createUndoManager() {
                return new RUndoManager(this){
                    private static final long serialVersionUID = 6268771600380647198L;

                    @Override
                    public void updateActions() {
                        super.updateActions();
                        ASAF.refreshState("edit");
                    }
                };
            }
        };
        this.pane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                ASAF.refreshState("edit");
            }
        });
        this.pane.setTabSize(4);
        this.pane.setCaretPosition(0);
        this.pane.addHyperlinkListener(this.hyperlinkListener);
        this.pane.requestFocusInWindow();
        this.pane.setMarkOccurrences(true);
        this.pane.setCodeFoldingEnabled(true);
        this.pane.setClearWhitespaceLinesEnabled(false);
        LanguageSupportFactory.get().register(this.pane);
        ToolTipManager.sharedInstance().registerComponent(this.pane);
        this.initStyle();
        if ("text/java".equals(this.pane.getSyntaxEditingStyle())) {
            this.sourceTree = new JavaOutlineTree();
        } else if ("text/xml".equals(this.pane.getSyntaxEditingStyle())) {
            this.sourceTree = new XmlOutlineTree();
        }
        if (this.sourceTree != null) {
            this.sourceTree.listenTo(this.pane);
        }
        try {
            this.pane.load(FileLocation.create(this.file), null);
            this.pane.discardAllEdits();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        RTextScrollPane rTextScrollPane = new RTextScrollPane(this.pane, true);
        this.pane.getDocument().addDocumentListener(this.documentListener);
        Gutter gutter = rTextScrollPane.getGutter();
        gutter.setBookmarkingEnabled(true);
        gutter.setBookmarkIcon(ResourceMap.getImageIcon("bookmark.icon"));
        gutter.setFoldIcons(ResourceMap.getImageIcon("collapsedCode.icon"), ResourceMap.getImageIcon("expandedCode.icon"));
        return rTextScrollPane;
    }

    protected ErrorStrip createErrorStrip() {
        return new ErrorStrip(this.pane);
    }

    public void initStyle() {
        String string = "eclipse";
        String string2 = null;
        Icon icon = null;
        String string3 = "";
        String string4 = this.file.getName();
        int n = string4.lastIndexOf(46);
        if (n != -1) {
            string3 = string4.substring(string4.lastIndexOf(46) + 1);
            string2 = FileAssociations.getEditorStyle(string3);
            icon = FileAssociations.getEditorIcon(string3);
        }
        if (string2 == null) {
            string2 = Utils.guessFileStyle(this.file);
        }
        if ("text/xml".equals(string2)) {
            if ("xml".equalsIgnoreCase(string3) && Utils.isAntFile(this.file)) {
                icon = FileAssociations.getEditorIcon("ant");
                string = "ant";
            } else {
                if (!this.file.exists() && !this.newFile) {
                    icon = FileAssociations.getEditorIcon("repo_xml");
                }
                if (icon == null) {
                    icon = FileAssociations.getEditorIcon("xml");
                }
            }
        }
        this.pane.setSyntaxEditingStyle(string2);
        this.setTitleText(this.file.getName());
        this.setTitleIcon(icon == null ? Icons.FILE_ICON : icon);
        Theme theme = RSTA.getTheme(string);
        if (theme != null) {
            theme.apply(this.pane);
        }
    }

    public boolean reload() {
        block3: {
            try {
                int n;
                if (!this.isModified() || (n = JOptionPane.showConfirmDialog(null, ResourceMap.getString("reloadFile.text", this.file.getName()), ResourceMap.getString("reload.Dialog.title", new String[0]), 0)) == 0) break block3;
                return false;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        this.pane.getDocument().removeDocumentListener(this.documentListener);
        this.setModified(false);
        this.pane.getDocument().removeDocumentListener(this.documentListener);
        this.pane.load(FileLocation.create(this.file), null);
        this.pane.discardAllEdits();
        this.pane.getDocument().addDocumentListener(this.documentListener);
        return true;
    }

    @Override
    public String toString() {
        return "FileTab[" + this.file.getAbsolutePath() + "]";
    }
}

