/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import org.yaoqiang.asaf.FileTab;

public class FileAssociations {
    private static final Set<String> IMAGE_TYPES = new HashSet<String>();
    private static Map<String, Class<? extends FileTab>> editors;
    private static Map<String, String> xmlTypes;
    private static Map<String, String> editorStyles;
    private static Map<String, Icon> editorIcons;

    static {
        String[] stringArray = ImageIO.getReaderFormatNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].toString().toLowerCase();
            IMAGE_TYPES.add(string);
            ++n;
        }
        editors = new HashMap<String, Class<? extends FileTab>>();
        xmlTypes = new HashMap<String, String>();
        editorStyles = new HashMap<String, String>();
        editorIcons = new HashMap<String, Icon>();
    }

    public static void addEditor(String string, Class<? extends FileTab> clazz) {
        editors.put(string, clazz);
    }

    public static Class<? extends FileTab> getEditor(String string) {
        return editors.get(string);
    }

    public static void removeEditor(String string) {
        editors.remove(string);
    }

    public static void addXMLType(String string, String string2) {
        xmlTypes.put(string, string2);
    }

    public static String getXMLType(String string) {
        return xmlTypes.get(string);
    }

    public static void removeXMLType(String string) {
        xmlTypes.remove(string);
    }

    public static void addEditorStyle(String string, String string2) {
        editorStyles.put(string, string2);
    }

    public static String getEditorStyle(String string) {
        return editorStyles.get(string);
    }

    public static void addEditorIcon(String string, Icon icon) {
        editorIcons.put(string, icon);
    }

    public static Icon getEditorIcon(String string) {
        Icon icon = editorIcons.get(string);
        if (icon == null && IMAGE_TYPES.contains(string)) {
            icon = editorIcons.get("image");
        }
        return icon;
    }
}

