/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.intern.CDockable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.Editable;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.panel.PanelContainer;
import org.yaoqiang.asaf.splash.SplashScreen;

public abstract class AppView
extends DefaultSingleCDockable
implements Editable {
    protected BundleContext bundleContext;
    protected Map<String, Object> properties;
    protected PanelContainer panelContainer;
    private PropertyChangeSupport changeSupport;
    protected CFocusListener focusListener = new CFocusListener(){

        @Override
        public void focusGained(CDockable cDockable) {
            ASAF.refreshState("file");
        }

        @Override
        public void focusLost(CDockable cDockable) {
        }
    };

    public AppView(String string) {
        super(string, new CAction[0]);
        SplashScreen.increaseProgress();
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public void addEventListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener("enabled", propertyChangeListener);
    }

    public void addViewEventListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener("view", propertyChangeListener);
    }

    public void reactivate() {
        this.activate(this.bundleContext, this.properties);
    }

    protected void activate(BundleContext bundleContext, Map<String, Object> map) {
        this.bundleContext = bundleContext;
        this.properties = map;
        this.setExternalizable(false);
        this.setCloseable(true);
        this.addFocusListener(this.focusListener);
        String string = this.getUniqueId();
        this.setTitleText(ResourceMap.getString(String.valueOf(string) + ".View.title", new String[0]));
        this.setTitleIcon(ResourceMap.getImageIcon(String.valueOf(string) + ".View.icon"));
        this.initView();
    }

    public void setPanelContainer(PanelContainer panelContainer) {
        this.panelContainer = panelContainer;
    }

    public PanelContainer getPanelContainer() {
        return this.panelContainer;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public abstract void initView();

    @Override
    public boolean isCuttable() {
        return false;
    }

    @Override
    public boolean isCopyable() {
        return false;
    }

    @Override
    public boolean isPastable() {
        return false;
    }

    @Override
    public boolean isDeletable() {
        return false;
    }

    public void fireEvent(String string) {
        this.changeSupport.firePropertyChange("enabled", null, string);
    }

    public void fireViewEvent(String string, Object object) {
        this.changeSupport.firePropertyChange("view", string, object);
    }

    public void processEvent(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    public void cut(ActionEvent actionEvent) {
    }

    @Override
    public void copy(ActionEvent actionEvent) {
    }

    @Override
    public void paste(ActionEvent actionEvent) {
    }

    @Override
    public void delete(ActionEvent actionEvent) {
    }
}

