/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.osgi.framework.BundleContext;
import org.yaoqiang.asaf.AppAction;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.Utils;
import org.yaoqiang.asaf.frame.MenuSeparator;
import org.yaoqiang.asaf.splash.SplashScreen;

public class AppMenu
extends JMenu {
    private static final long serialVersionUID = -2861514160623168723L;
    protected BundleContext bundleContext;
    protected Map<String, Object> properties;
    private AppMenu parentMenu;
    private String menuName;
    private String menuGroup;
    private int menuPriority = 999;
    private PropertyChangeSupport changeSupport;

    public AppMenu() {
        SplashScreen.increaseProgress();
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public AppMenu(AppMenu appMenu, Map<String, Object> map) {
        this.changeSupport = new PropertyChangeSupport(this);
        this.parentMenu = appMenu;
        this.activate(null, map);
    }

    public void addEventListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addEventListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void reactivate() {
        this.activate(this.bundleContext, this.properties);
    }

    protected void activate(BundleContext bundleContext, Map<String, Object> map) {
        this.bundleContext = bundleContext;
        this.properties = map;
        this.menuName = (String)map.get("menu.name");
        this.menuGroup = (String)map.get("menu.group");
        if (this.menuGroup == null) {
            this.menuGroup = "default";
        }
        this.setText(ResourceMap.getString(String.valueOf(this.menuName) + ".Menu.text", new String[0]));
        this.setIcon(ResourceMap.getImageIcon(String.valueOf(this.menuName) + ".Menu.icon"));
        if (map.get("menu.priority") != null) {
            this.menuPriority = (Integer)map.get("menu.priority");
        }
        if (map.get("menu.icon") != null) {
            this.setIcon(ResourceMap.getImageIcon((String)map.get("menu.icon")));
        }
        if (map.get("menu.path") != null) {
            this.parentMenu = Utils.parseMenuPath((String)map.get("menu.path"));
        }
        this.initMenu();
    }

    public boolean isRemovable() {
        return this.getMenuComponentCount() == 0;
    }

    public void initMenu() {
    }

    public AppMenu getParentMenu() {
        return this.parentMenu;
    }

    public String getMenuName() {
        return this.menuName;
    }

    public int getMenuPriority() {
        return this.menuPriority;
    }

    public void setMenuPriority(int n) {
        this.menuPriority = n;
    }

    public void setParentMenu(AppMenu appMenu) {
        this.parentMenu = appMenu;
    }

    public JMenuItem insert(Object object) {
        JMenuItem jMenuItem = null;
        int n = 999;
        if (object instanceof AppMenu) {
            n = ((AppMenu)object).getMenuPriority();
            jMenuItem = this.insert((AppMenu)object, Utils.getItemInsertPosition(this.getPopupMenu(), n));
        } else if (object instanceof AppAction) {
            AppAction appAction = (AppAction)object;
            n = appAction.getActionMenuPriority();
            jMenuItem = this.insert(appAction, Utils.getItemInsertPosition(this.getPopupMenu(), n));
            for (MenuSeparator menuSeparator : appAction.getMenuSeparators()) {
                this.add((Component)menuSeparator, Utils.getItemInsertPosition(this.getPopupMenu(), menuSeparator.getPriority()));
            }
        }
        return jMenuItem;
    }

    public void addToMenuBar(JMenuBar jMenuBar) {
        jMenuBar.add((Component)this, Utils.getItemInsertPosition(jMenuBar, this.menuPriority));
        jMenuBar.revalidate();
        jMenuBar.repaint();
    }

    public void removeFromMenuBar(JMenuBar jMenuBar) {
        jMenuBar.remove(this);
        jMenuBar.revalidate();
        jMenuBar.repaint();
    }

    public void removeSeparators(Set<MenuSeparator> set) {
        for (MenuSeparator menuSeparator : set) {
            this.getPopupMenu().remove(menuSeparator);
        }
    }

    public void fireEvent() {
        this.changeSupport.firePropertyChange("enabled", null, this.menuGroup);
    }

    public void processEvent(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    public String toString() {
        return this.getText();
    }

    public boolean equals(Object object) {
        if (object instanceof AppMenu) {
            AppMenu appMenu = (AppMenu)object;
            return this.menuName.equals(appMenu.getMenuName());
        }
        return false;
    }
}

