/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JToolBar;
import org.osgi.framework.BundleContext;
import org.yaoqiang.asaf.AppMenu;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.Utils;
import org.yaoqiang.asaf.frame.MenuSeparator;
import org.yaoqiang.asaf.frame.MnemonicText;
import org.yaoqiang.asaf.frame.ToolBarButton;
import org.yaoqiang.asaf.frame.ToolBarSeparator;
import org.yaoqiang.asaf.splash.SplashScreen;
import org.yaoqiang.asaf.task.Task;

public abstract class AppAction
extends AbstractAction {
    private static final long serialVersionUID = 2798750502735961255L;
    protected BundleContext bundleContext;
    protected Map<String, Object> properties;
    private String actionName;
    private String actionGroup;
    private int actionMenuPriority = 999;
    private int actionToolBarPriority = -1;
    private AppMenu parentMenu;
    private Set<MenuSeparator> menuSeparators = new HashSet<MenuSeparator>();
    private Set<ToolBarSeparator> toolBarSeparators = new HashSet<ToolBarSeparator>();
    private PropertyChangeSupport changeSupport;

    public AppAction() {
        SplashScreen.increaseProgress();
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public void addEventListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addEventListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void reactivate() {
        this.activate(this.bundleContext, this.properties);
    }

    protected void activate(BundleContext bundleContext, Map<String, Object> map) {
        String string;
        int n;
        this.bundleContext = bundleContext;
        this.properties = map;
        this.actionName = (String)map.get("action.name");
        this.actionGroup = (String)map.get("action.group");
        if (this.actionGroup == null) {
            this.actionGroup = "default";
        }
        String string2 = ResourceMap.getString(String.valueOf(this.actionName) + ".Action.text", new String[0]);
        MnemonicText.configure(this, string2);
        String string3 = null;
        string3 = ResourceMap.getResource(String.valueOf(this.actionName) + ".Action.shortDescription") == null ? string2 : ResourceMap.getString(String.valueOf(this.actionName) + ".Action.shortDescription", new String[0]);
        this.putValue("ShortDescription", string3);
        this.putValue("SmallIcon", ResourceMap.getImageIcon(String.valueOf(this.actionName) + ".Action.icon"));
        this.putValue("AcceleratorKey", ResourceMap.getKeyStroke(String.valueOf(this.actionName) + ".Action.accelerator"));
        if (map.get("action.menu.priority") != null) {
            this.actionMenuPriority = (Integer)map.get("action.menu.priority");
        }
        this.parentMenu = Utils.parseMenuPath((String)map.get("action.menu.path"));
        String string4 = (String)map.get("action.menu.separator");
        if (string4 != null) {
            int n2 = 999;
            String[] stringArray = string4.split("::");
            n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String string5 = stringArray[n3];
                if (string5.startsWith("#")) {
                    n2 = Integer.parseInt(string5.substring(1));
                    this.menuSeparators.add(new MenuSeparator(n2));
                }
                ++n3;
            }
        }
        if (map.get("action.toolbar.priority") != null) {
            this.actionToolBarPriority = (Integer)map.get("action.toolbar.priority");
        }
        if ((string = (String)map.get("action.toolbar.separator")) != null) {
            int n4 = 999;
            String[] stringArray = string.split("::");
            int n5 = stringArray.length;
            n = 0;
            while (n < n5) {
                String string6 = stringArray[n];
                if (string6.startsWith("#")) {
                    n4 = Integer.parseInt(string6.substring(1));
                    this.toolBarSeparators.add(new ToolBarSeparator(n4));
                }
                ++n;
            }
        }
    }

    public void addToToolBar(ToolBarButton toolBarButton, JToolBar jToolBar) {
        jToolBar.add((Component)toolBarButton, Utils.getItemInsertPosition(jToolBar, this.actionToolBarPriority));
        for (ToolBarSeparator toolBarSeparator : toolBarButton.getButtonAction().getToolBarSeparators()) {
            jToolBar.add((Component)toolBarSeparator, Utils.getItemInsertPosition(jToolBar, toolBarSeparator.getPriority()));
        }
        jToolBar.revalidate();
        jToolBar.repaint();
    }

    public void removeFromToolBar(ToolBarButton toolBarButton, JToolBar jToolBar) {
        jToolBar.remove(toolBarButton);
        for (ToolBarSeparator toolBarSeparator : toolBarButton.getButtonAction().getToolBarSeparators()) {
            jToolBar.remove(toolBarSeparator);
        }
        jToolBar.revalidate();
        jToolBar.repaint();
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getActionGroup() {
        return this.actionGroup;
    }

    public int getActionMenuPriority() {
        return this.actionMenuPriority;
    }

    public int getActionToolBarPriority() {
        return this.actionToolBarPriority;
    }

    public Set<MenuSeparator> getMenuSeparators() {
        return this.menuSeparators;
    }

    public Set<ToolBarSeparator> getToolBarSeparators() {
        return this.toolBarSeparators;
    }

    public AppMenu getParentMenu() {
        return this.parentMenu;
    }

    public void setParentMenu(AppMenu appMenu) {
        this.parentMenu = appMenu;
    }

    public void setActionMenuPriority(int n) {
        this.actionMenuPriority = n;
    }

    public void forwardEvent(PropertyChangeEvent propertyChangeEvent) {
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    private void fireEvent() {
        this.changeSupport.firePropertyChange("enabled", null, this.actionGroup);
    }

    protected void fireEvent(String string, Object object) {
        this.changeSupport.firePropertyChange(string, null, object);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.processAction(actionEvent);
        this.fireEvent();
    }

    public abstract Task<?, ?> processAction(ActionEvent var1);
}

