/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf;

import bibliothek.gui.DockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CWorkingArea;
import bibliothek.gui.dock.common.perspective.CPerspective;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.swing.JFrame;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;
import org.yaoqiang.asaf.AppAction;
import org.yaoqiang.asaf.AppMenu;
import org.yaoqiang.asaf.AppView;
import org.yaoqiang.asaf.FileTab;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.Utils;
import org.yaoqiang.asaf.editor.menu.RecentFileMenu;
import org.yaoqiang.asaf.frame.ComponentManager;
import org.yaoqiang.asaf.frame.FrameView;
import org.yaoqiang.asaf.splash.SplashScreen;
import org.yaoqiang.asaf.task.TaskMonitor;
import org.yaoqiang.asaf.task.TaskService;
import org.yaoqiang.asaf.tracker.ActionTracker;
import org.yaoqiang.asaf.tracker.MenuTracker;
import org.yaoqiang.asaf.tracker.ViewTracker;
import org.yaoqiang.asaf.tracker.WebServiceManager;
import org.yaoqiang.asaf.tracker.WebServiceTracker;

public class ASAF {
    public static final String VERSION = "2.0.0";
    public static final String SHUTDOWN_MODE = "asaf.shutdown.mode";
    public static final int SHUTDOWN_MODE_EXIT = 0;
    public static final int SHUTDOWN_MODE_UPDATE = 3;
    public static final int SHUTDOWN_MODE_UNINSTALL = 5;
    public static final int SHUTDOWN_MODE_RESTART = 6;
    public static final int RECENT_FILE_MAXSIZE = 10;
    public static final String ASAF_USER_HOME = String.valueOf(System.getProperty("user.home")) + File.separator + ".asaf";
    public static final String CACHE_DIR = String.valueOf(ASAF_USER_HOME) + File.separator + ".asaf-cache";
    public static final String UPDATE_DIR = String.valueOf(ASAF_USER_HOME) + File.separator + "updates" + File.separator;
    public static final String PEER_ID = String.valueOf(ASAF_USER_HOME) + File.separator + ".peer";
    public static final String PERSPECTIVES_FILE = String.valueOf(ASAF_USER_HOME) + File.separator + "perspectives.xml";
    public static final String ASAF_CONF_FILE = "conf.properties";
    public static final String KEY_THEME = "Theme";
    public static final String KEY_LANGUAGE = "Locale";
    public static final String DEFAULT_LANGUAGE = Locale.getDefault().getLanguage();
    public static final String[] SUPPORT_LANGUAGES = new String[]{"en", "de", "fr", "zh_CN"};
    public static final String DEFAULT_PERSPECTIVE = "Default";
    public static final String KEY_LAST_OPEN_DIR = "lastOpenDir";
    public static final String KEY_LAST_OPEN_FILE = "lastOpenFile";
    public static final String DEFAULT_DIR = System.getProperty("user.dir");
    public static final String KEY_RECEIVED_FOLDER = "receivedFolder";
    public static final String DEFAULT_RECEIVED_FOLDER = String.valueOf(ASAF_USER_HOME) + File.separator + "received";
    public static final String KEY_BODY_PREFIX = "bodyPrefix";
    public static final String KEY_WEB_SERVICE_PORT = "webservicePort";
    public static final String DEFAULT_WEB_SERVICE_PORT = "1129";
    public static final String ASAF_RECENT_FILES = ".filelist";
    public static final SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Properties SETTINGS = new Properties();
    private static final WebServiceManager WEBSERVICE_MANAGER = new WebServiceManager();
    private static final Set<ServiceTracker<?, ?>> serviceTrackers = new HashSet();
    private static Image logo;
    private static String title;
    private static String version;
    private static final ASAF INSTANCE;
    private static Locale locale;
    private static FrameView mainView;
    private static Clipboard clipboard;
    private static PropertyChangeSupport changeSupport;
    private static TaskMonitor taskMonitor;
    private static TaskService taskService;
    private static Connection DBConn;
    private static BundleContext bundleContext;
    private static boolean starting;

    static {
        INSTANCE = new ASAF();
    }

    private ASAF() {
        starting = true;
        ASAF.loadASAFSettings();
        ASAF.setProxyProperties();
        if (!GraphicsEnvironment.isHeadless()) {
            taskService = new TaskService();
            taskMonitor = new TaskMonitor(taskService);
        }
        mainView = new FrameView();
        mainView.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (ASAF.canExit()) {
                    ASAF.exit();
                }
            }
        });
        changeSupport = new PropertyChangeSupport(this);
        changeSupport.addPropertyChangeListener("enabled", mainView.getComponentManager().getListener());
        changeSupport.addPropertyChangeListener("view", mainView.getComponentManager().getViewListener());
    }

    public static ASAF getInstance() {
        return INSTANCE;
    }

    public static void start(BundleContext bundleContext) {
        ASAF.bundleContext = bundleContext;
        serviceTrackers.add(new ActionTracker(bundleContext));
        serviceTrackers.add(new MenuTracker(bundleContext));
        serviceTrackers.add(new ViewTracker(bundleContext));
        serviceTrackers.add(new WebServiceTracker(bundleContext));
        for (ServiceTracker<?, ?> serviceTracker : serviceTrackers) {
            serviceTracker.open();
        }
    }

    private static void loadASAFSettings() {
        File file;
        File file2 = new File(ASAF_USER_HOME);
        if (!file2.exists()) {
            try {
                file2.mkdir();
            }
            catch (Exception exception) {}
        }
        if (!(file = new File(ASAF.getReceivedFolder())).exists()) {
            try {
                file.mkdir();
            }
            catch (Exception exception) {}
        }
        Utils.loadASAFProperties(SETTINGS, ASAF_CONF_FILE);
        String string = ASAF.getSetting(KEY_LANGUAGE, DEFAULT_LANGUAGE);
        int n = string.indexOf(95);
        locale = n > 0 ? new Locale(string.substring(0, n), string.substring(n + 1)) : new Locale(string);
        System.setProperty("asaf.language", string);
        ResourceMap.add("org.yaoqiang.asaf.resources.locale");
    }

    private static void setProxyProperties() {
        String string = ASAF.getSetting("proxyType", "HTTP");
        String string2 = ASAF.getSetting(String.valueOf(string.toLowerCase()) + "ProxyHost");
        String string3 = ASAF.getSetting(String.valueOf(string.toLowerCase()) + "ProxyPort");
        if (string2 == null || string3 == null) {
            return;
        }
        final String string4 = ASAF.getSetting("proxyUsername", "");
        final String string5 = ASAF.getSetting("proxyPassword", "");
        if (string.equals("HTTP")) {
            System.setProperty("http.proxyHost", string2);
            System.setProperty("http.proxyPort", string3);
            System.setProperty("https.proxyHost", string2);
            System.setProperty("https.proxyPort", string3);
        } else if (string.equals("Socks")) {
            System.setProperty("socksProxyHost", string2);
            System.setProperty("socksProxyPort", string3);
        }
        if (Boolean.parseBoolean(ASAF.getSetting("proxyRequireAuth"))) {
            if (string.equals("HTTP")) {
                System.setProperty("http.proxyAuth", String.valueOf(string4) + ":" + string5);
            } else if (string.equals("Socks")) {
                System.setProperty("java.net.socks.username", string4);
                System.setProperty("java.net.socks.password", string5);
            }
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(string4, string5 == null ? new char[]{} : string5.toCharArray());
                }
            });
        }
    }

    public static Properties getSettings() {
        return SETTINGS;
    }

    public static String getSetting(String string) {
        return SETTINGS.getProperty(string);
    }

    public static String getSetting(String string, String string2) {
        return SETTINGS.getProperty(string, string2);
    }

    public static void setSetting(String string, Object object) {
        SETTINGS.put(string, object);
    }

    public static void removeSetting(String string) {
        SETTINGS.remove(string);
    }

    public static String getLastOpenDir() {
        return ASAF.getSetting(KEY_LAST_OPEN_DIR, DEFAULT_DIR);
    }

    public static void setLastOpenDir(String string) {
        ASAF.setSetting(KEY_LAST_OPEN_DIR, string);
    }

    public static String getLastOpenFile() {
        return ASAF.getSetting(KEY_LAST_OPEN_FILE, "");
    }

    public static void setLastOpenFile(String string) {
        if (string != null) {
            ASAF.setSetting(KEY_LAST_OPEN_FILE, string);
        }
    }

    public static String getReceivedFolder() {
        return ASAF.getSetting(KEY_RECEIVED_FOLDER, DEFAULT_RECEIVED_FOLDER);
    }

    public static void setReceivedFolder(String string) {
        ASAF.setSetting(KEY_RECEIVED_FOLDER, string);
    }

    public static Image getLogo() {
        return logo == null ? ResourceMap.getImageIcon("App.icon").getImage() : logo;
    }

    public static void setLogo(Image image) {
        logo = image;
        mainView.getFrame().setIconImage(image);
    }

    public static String getTitle() {
        return title == null ? ResourceMap.getString("App.title", new String[0]) : title;
    }

    public static void setTitle(String string) {
        title = string;
        mainView.getFrame().setTitle(string);
    }

    public static String getVersion() {
        return version;
    }

    public static void setVersion(String string) {
        version = string;
    }

    public static void refreshActions() {
        mainView.getComponentManager().refreshActions();
    }

    public static void refreshMenus() {
        mainView.getComponentManager().refreshMenus();
    }

    public static void refreshViews() {
        mainView.getComponentManager().refreshViews();
    }

    public static Set<AppAction> getGroupActions(String string) {
        return mainView.getComponentManager().getGroupActions(string);
    }

    public static AppAction getAction(String string) {
        return mainView.getComponentManager().getAction(string);
    }

    public static AppMenu getMenu(String string) {
        return mainView.getComponentManager().getMenu(string);
    }

    public static Connection getDBConnection() {
        return DBConn;
    }

    public static void setDBConnection(Connection connection) {
        DBConn = connection;
    }

    public static Clipboard getClipboard() {
        if (clipboard == null) {
            try {
                clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (SecurityException securityException) {
                clipboard = new Clipboard("sandbox");
            }
        }
        return clipboard;
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void setLocale(Locale locale) {
        ASAF.locale = locale;
    }

    public static FrameView getMainView() {
        return mainView;
    }

    public static JFrame getMainFrame() {
        return mainView.getFrame();
    }

    public static void setFrameTitle(String string, File file) {
        if (file != null && !file.exists()) {
            string = null;
            file = null;
        }
        mainView.setFrameTitle(string, file);
    }

    public static void addWindowListener(WindowListener windowListener) {
        mainView.addWindowListener(windowListener);
    }

    public static void showFrame() {
        mainView.show();
        starting = false;
        System.out.println("ASAF started!");
        ASAF.fireViewEvent("started", null);
        SplashScreen.closeSplash();
    }

    public static boolean isStarting() {
        return starting;
    }

    public static void shutdown() {
        ASAF.saveASAFSettings();
        mainView.close();
        if (!Boolean.getBoolean("asaf.standalone")) {
            for (ServiceTracker<?, ?> serviceTracker : serviceTrackers) {
                serviceTracker.close();
            }
            serviceTrackers.clear();
            starting = true;
        }
        System.out.println("ASAF stopped!");
    }

    public static void exit() {
        try {
            if (Boolean.getBoolean("asaf.standalone")) {
                System.setProperty(SHUTDOWN_MODE, Integer.toString(0));
                bundleContext.getBundle(0L).stop();
            } else {
                bundleContext.getBundle().stop();
            }
        }
        catch (BundleException bundleException) {
            bundleException.printStackTrace();
        }
    }

    private static void saveASAFSettings() {
        Utils.saveASAFProperties(SETTINGS, ASAF_CONF_FILE);
    }

    public static ComponentManager getComponentManager() {
        return mainView.getComponentManager();
    }

    public static WebServiceManager getWebserviceManager() {
        return WEBSERVICE_MANAGER;
    }

    public static CControl getDockController() {
        return mainView.getDockController();
    }

    public static CWorkingArea getWorkingArea() {
        return mainView.getWorkingArea();
    }

    public static String getCurrentPerspective() {
        return mainView.getCurrentPerspective();
    }

    public static void addBuiltinPerspective(String string, CPerspective cPerspective) {
        mainView.addBuiltinPerspective(string, cPerspective);
    }

    public static void removeBuiltinPerspective(String string) {
        mainView.removeBuiltinPerspective(string);
    }

    public static CPerspective getBuiltinPerspective(String string) {
        return mainView.getBuiltinPerspective(string);
    }

    public static void loadPerspective(String string) {
        mainView.loadPerspective(string);
    }

    public static void loadPerspective() {
        mainView.loadPerspective();
    }

    public static void addView(AppView appView) {
        mainView.addView(appView);
    }

    public static void removeView(AppView appView) {
        mainView.removeView(appView);
    }

    public static DockStation getMainDockStation() {
        return mainView.getMainDockStation();
    }

    public static FileTab getFileTab(File file) {
        return mainView.getFileTab(file);
    }

    public static Set<FileTab> getModifiedTabs() {
        return mainView.getModifiedTabs();
    }

    public static boolean hasModifiedTabs() {
        return mainView.hasModifiedTabs();
    }

    public static void closeAllFileTabs() {
        mainView.closeAllFileTabs();
    }

    public static boolean canExit() {
        return mainView.canExit();
    }

    public static void showFileTab(FileTab fileTab) {
        mainView.showFileTab(fileTab);
    }

    public static FileTab getSelectedFileTab() {
        return mainView.getSelectedFileTab();
    }

    public static void setSelectedFileTab(FileTab fileTab) {
        mainView.setSelectedFileTab(fileTab);
    }

    public static void clearSelectedFileTab() {
        ASAF.setSelectedFileTab(null);
        ASAF.setFrameTitle(null, null);
        ASAF.refreshState("file");
        ASAF.refreshState("edit");
    }

    public static void addtoRecentFileList(String string) {
        ((RecentFileMenu)ASAF.getMenu("recentFiles")).addFiletoRecentOpenList(string);
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static TaskMonitor getTaskMonitor() {
        return taskMonitor;
    }

    public static TaskService getTaskService() {
        return taskService;
    }

    public static PropertyChangeSupport getChangeSupport() {
        return changeSupport;
    }

    public static void refreshState(String string) {
        changeSupport.firePropertyChange("enabled", null, string);
    }

    public static void fireEvent(String string, Object object) {
        changeSupport.firePropertyChange(string, null, object);
    }

    public static void fireViewEvent(String string, Object object) {
        changeSupport.firePropertyChange("view", string, object);
    }
}

