/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.tracker;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.AbstractTracked;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTracker<S, T>
implements ServiceTrackerCustomizer<S, T> {
    static final boolean DEBUG = false;
    protected final BundleContext context;
    protected final Filter filter;
    final ServiceTrackerCustomizer<S, T> customizer;
    final String listenerFilter;
    private final String trackClass;
    private final ServiceReference<S> trackReference;
    private volatile Tracked tracked;
    private volatile ServiceReference<S> cachedReference;
    private volatile T cachedService;

    private Tracked tracked() {
        return this.tracked;
    }

    public ServiceTracker(BundleContext bundleContext, ServiceReference<S> serviceReference, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
        this.context = bundleContext;
        this.trackReference = serviceReference;
        this.trackClass = null;
        this.customizer = serviceTrackerCustomizer == null ? this : serviceTrackerCustomizer;
        this.listenerFilter = "(service.id=" + serviceReference.getProperty("service.id").toString() + ")";
        try {
            this.filter = bundleContext.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("unexpected InvalidSyntaxException: " + invalidSyntaxException.getMessage());
            illegalArgumentException.initCause(invalidSyntaxException);
            throw illegalArgumentException;
        }
    }

    public ServiceTracker(BundleContext bundleContext, String string, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
        this.context = bundleContext;
        this.trackReference = null;
        this.trackClass = string;
        this.customizer = serviceTrackerCustomizer == null ? this : serviceTrackerCustomizer;
        this.listenerFilter = "(objectClass=" + string.toString() + ")";
        try {
            this.filter = bundleContext.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("unexpected InvalidSyntaxException: " + invalidSyntaxException.getMessage());
            illegalArgumentException.initCause(invalidSyntaxException);
            throw illegalArgumentException;
        }
    }

    public ServiceTracker(BundleContext bundleContext, Filter filter, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
        this.context = bundleContext;
        this.trackReference = null;
        this.trackClass = null;
        this.listenerFilter = filter.toString();
        this.filter = filter;
        ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer2 = this.customizer = serviceTrackerCustomizer == null ? this : serviceTrackerCustomizer;
        if (bundleContext == null || filter == null) {
            throw new NullPointerException();
        }
    }

    public ServiceTracker(BundleContext bundleContext, Class<S> clazz, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer) {
        this(bundleContext, clazz.getName(), serviceTrackerCustomizer);
    }

    public void open() {
        this.open(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(boolean bl) {
        Tracked tracked;
        ServiceTracker serviceTracker = this;
        synchronized (serviceTracker) {
            if (this.tracked != null) {
                return;
            }
            Tracked tracked2 = tracked = bl ? new AllTracked() : new Tracked();
            synchronized (tracked2) {
                try {
                    this.context.addServiceListener(tracked, this.listenerFilter);
                    ServiceReference<S>[] serviceReferenceArray = null;
                    if (this.trackClass != null) {
                        serviceReferenceArray = this.getInitialReferences(bl, this.trackClass, null);
                    } else if (this.trackReference != null) {
                        if (this.trackReference.getBundle() != null) {
                            ServiceReference[] serviceReferenceArray2 = new ServiceReference[]{this.trackReference};
                            serviceReferenceArray = serviceReferenceArray2;
                        }
                    } else {
                        serviceReferenceArray = this.getInitialReferences(bl, null, this.listenerFilter);
                    }
                    tracked.setInitial(serviceReferenceArray);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    throw new RuntimeException("unexpected InvalidSyntaxException: " + invalidSyntaxException.getMessage(), invalidSyntaxException);
                }
            }
            this.tracked = tracked;
        }
        tracked.trackInitial();
    }

    private ServiceReference<S>[] getInitialReferences(boolean bl, String string, String string2) throws InvalidSyntaxException {
        ServiceReference<?>[] serviceReferenceArray = bl ? this.context.getAllServiceReferences(string, string2) : this.context.getServiceReferences(string, string2);
        return serviceReferenceArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServiceReference<S>[] serviceReferenceArray;
        Tracked tracked;
        Object object = this;
        synchronized (object) {
            tracked = this.tracked;
            if (tracked == null) {
                return;
            }
            tracked.close();
            serviceReferenceArray = this.getServiceReferences();
            this.tracked = null;
            try {
                this.context.removeServiceListener(tracked);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.modified();
        object = tracked;
        synchronized (object) {
            tracked.notifyAll();
        }
        if (serviceReferenceArray != null) {
            int n = 0;
            while (n < serviceReferenceArray.length) {
                tracked.untrack(serviceReferenceArray[n], null);
                ++n;
            }
        }
    }

    @Override
    public T addingService(ServiceReference<S> serviceReference) {
        S s = this.context.getService(serviceReference);
        return (T)s;
    }

    @Override
    public void modifiedService(ServiceReference<S> serviceReference, T t) {
    }

    @Override
    public void removedService(ServiceReference<S> serviceReference, T t) {
        this.context.ungetService(serviceReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T waitForService(long l) throws InterruptedException {
        long l2;
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        T t = this.getService();
        if (t != null) {
            return t;
        }
        long l3 = l2 = l == 0L ? 0L : System.currentTimeMillis() + l;
        do {
            Tracked tracked;
            if ((tracked = this.tracked()) == null) {
                return null;
            }
            Tracked tracked2 = tracked;
            synchronized (tracked2) {
                if (tracked.size() == 0) {
                    tracked.wait(l);
                }
            }
            t = this.getService();
        } while ((l2 <= 0L || (l = l2 - System.currentTimeMillis()) > 0L) && t == null);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference<S>[] getServiceReferences() {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int n;
            block5: {
                n = tracked.size();
                if (n != 0) break block5;
                return null;
            }
            ServiceReference[] serviceReferenceArray = new ServiceReference[n];
            return tracked.copyKeys(serviceReferenceArray);
        }
    }

    public ServiceReference<S> getServiceReference() {
        int n;
        ServiceReference<S> serviceReference = this.cachedReference;
        if (serviceReference != null) {
            return serviceReference;
        }
        ServiceReference<S>[] serviceReferenceArray = this.getServiceReferences();
        int n2 = n = serviceReferenceArray == null ? 0 : serviceReferenceArray.length;
        if (n == 0) {
            return null;
        }
        int n3 = 0;
        if (n > 1) {
            int n4;
            int[] nArray = new int[n];
            int n5 = 0;
            int n6 = Integer.MIN_VALUE;
            int n7 = 0;
            while (n7 < n) {
                Object object = serviceReferenceArray[n7].getProperty("service.ranking");
                nArray[n7] = n4 = object instanceof Integer ? (Integer)object : 0;
                if (n4 > n6) {
                    n3 = n7;
                    n6 = n4;
                    n5 = 1;
                } else if (n4 == n6) {
                    ++n5;
                }
                ++n7;
            }
            if (n5 > 1) {
                long l = Long.MAX_VALUE;
                n4 = 0;
                while (n4 < n) {
                    long l2;
                    if (nArray[n4] == n6 && (l2 = ((Long)serviceReferenceArray[n4].getProperty("service.id")).longValue()) < l) {
                        n3 = n4;
                        l = l2;
                    }
                    ++n4;
                }
            }
        }
        this.cachedReference = serviceReferenceArray[n3];
        return this.cachedReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getService(ServiceReference<S> serviceReference) {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.getCustomizedObject(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getServices() {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int n;
            ServiceReference<S>[] serviceReferenceArray;
            block6: {
                serviceReferenceArray = this.getServiceReferences();
                int n2 = n = serviceReferenceArray == null ? 0 : serviceReferenceArray.length;
                if (n != 0) break block6;
                return null;
            }
            Object[] objectArray = new Object[n];
            int n3 = 0;
            while (n3 < n) {
                objectArray[n3] = this.getService(serviceReferenceArray[n3]);
                ++n3;
            }
            return objectArray;
        }
    }

    public T getService() {
        T t = this.cachedService;
        if (t != null) {
            return t;
        }
        ServiceReference<S> serviceReference = this.getServiceReference();
        if (serviceReference == null) {
            return null;
        }
        this.cachedService = this.getService(serviceReference);
        return this.cachedService;
    }

    public void remove(ServiceReference<S> serviceReference) {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return;
        }
        tracked.untrack(serviceReference, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return 0;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackingCount() {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return -1;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.getTrackingCount();
        }
    }

    void modified() {
        this.cachedReference = null;
        this.cachedService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<ServiceReference<S>, T> getTracked() {
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return treeMap;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.copyEntries(treeMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return true;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] getServices(T[] objectArray) {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            if (objectArray.length > 0) {
                objectArray[0] = null;
            }
            return objectArray;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int n;
            ServiceReference<S>[] serviceReferenceArray = this.getServiceReferences();
            int n2 = n = serviceReferenceArray == null ? 0 : serviceReferenceArray.length;
            if (n == 0) {
                if (objectArray.length > 0) {
                    objectArray[0] = null;
                }
                return objectArray;
            }
            if (n > objectArray.length) {
                Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
                objectArray = objectArray2;
            }
            int n3 = 0;
            while (n3 < n) {
                objectArray[n3] = this.getService(serviceReferenceArray[n3]);
                ++n3;
            }
            if (objectArray.length > n) {
                objectArray[n] = null;
            }
            return objectArray;
        }
    }

    private class AllTracked
    extends Tracked
    implements AllServiceListener {
        AllTracked() {
        }
    }

    private class Tracked
    extends AbstractTracked<ServiceReference<S>, T, ServiceEvent>
    implements ServiceListener {
        Tracked() {
        }

        @Override
        public final void serviceChanged(ServiceEvent serviceEvent) {
            if (this.closed) {
                return;
            }
            ServiceReference<?> serviceReference = serviceEvent.getServiceReference();
            switch (serviceEvent.getType()) {
                case 1: 
                case 2: {
                    this.track(serviceReference, serviceEvent);
                    break;
                }
                case 4: 
                case 8: {
                    this.untrack(serviceReference, serviceEvent);
                }
            }
        }

        @Override
        final void modified() {
            super.modified();
            ServiceTracker.this.modified();
        }

        @Override
        final T customizerAdding(ServiceReference<S> serviceReference, ServiceEvent serviceEvent) {
            return ServiceTracker.this.customizer.addingService(serviceReference);
        }

        @Override
        final void customizerModified(ServiceReference<S> serviceReference, ServiceEvent serviceEvent, T t) {
            ServiceTracker.this.customizer.modifiedService(serviceReference, t);
        }

        @Override
        final void customizerRemoved(ServiceReference<S> serviceReference, ServiceEvent serviceEvent, T t) {
            ServiceTracker.this.customizer.removedService(serviceReference, t);
        }
    }
}

