/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;
    private static final String SEPARATOR = ".";
    private transient String versionString;
    private transient int hash;
    public static final Version emptyVersion = new Version(0, 0, 0);

    public Version(int n, int n2, int n3) {
        this(n, n2, n3, null);
    }

    public Version(int n, int n2, int n3, String string) {
        if (string == null) {
            string = "";
        }
        this.major = n;
        this.minor = n2;
        this.micro = n3;
        this.qualifier = string;
        this.validate();
    }

    public Version(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR, true);
            n = Version.parseInt(stringTokenizer.nextToken(), string);
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                n2 = Version.parseInt(stringTokenizer.nextToken(), string);
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    n3 = Version.parseInt(stringTokenizer.nextToken(), string);
                    if (stringTokenizer.hasMoreTokens()) {
                        stringTokenizer.nextToken();
                        string2 = stringTokenizer.nextToken("");
                        if (stringTokenizer.hasMoreTokens()) {
                            throw new IllegalArgumentException("invalid version \"" + string + "\": invalid format");
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid version \"" + string + "\": invalid format");
            illegalArgumentException.initCause(noSuchElementException);
            throw illegalArgumentException;
        }
        this.major = n;
        this.minor = n2;
        this.micro = n3;
        this.qualifier = string2;
        this.validate();
    }

    private static int parseInt(String string, String string2) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid version \"" + string2 + "\": non-numeric \"" + string + "\"");
            illegalArgumentException.initCause(numberFormatException);
            throw illegalArgumentException;
        }
    }

    private void validate() {
        if (this.major < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString0() + "\": negative number \"" + this.major + "\"");
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString0() + "\": negative number \"" + this.minor + "\"");
        }
        if (this.micro < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString0() + "\": negative number \"" + this.micro + "\"");
        }
        char[] cArray = this.qualifier.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '_' || c == '-')) {
                throw new IllegalArgumentException("invalid version \"" + this.toString0() + "\": invalid qualifier \"" + this.qualifier + "\"");
            }
            ++n2;
        }
    }

    public static Version parseVersion(String string) {
        if (string == null) {
            return emptyVersion;
        }
        return Version.valueOf(string);
    }

    public static Version valueOf(String string) {
        if ((string = string.trim()).length() == 0) {
            return emptyVersion;
        }
        return new Version(string);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        return this.toString0();
    }

    String toString0() {
        String string = this.versionString;
        if (string != null) {
            return string;
        }
        int n = this.qualifier.length();
        StringBuffer stringBuffer = new StringBuffer(20 + n);
        stringBuffer.append(this.major);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.minor);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.micro);
        if (n > 0) {
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(this.qualifier);
        }
        this.versionString = stringBuffer.toString();
        return this.versionString;
    }

    public int hashCode() {
        int n = this.hash;
        if (n != 0) {
            return n;
        }
        n = 527;
        n = 31 * n + this.major;
        n = 31 * n + this.minor;
        n = 31 * n + this.micro;
        this.hash = n = 31 * n + this.qualifier.hashCode();
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        return this.major == version.major && this.minor == version.minor && this.micro == version.micro && this.qualifier.equals(version.qualifier);
    }

    @Override
    public int compareTo(Version version) {
        if (version == this) {
            return 0;
        }
        int n = this.major - version.major;
        if (n != 0) {
            return n;
        }
        n = this.minor - version.minor;
        if (n != 0) {
            return n;
        }
        n = this.micro - version.micro;
        if (n != 0) {
            return n;
        }
        return this.qualifier.compareTo(version.qualifier);
    }
}

