/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.Filter;
import org.osgi.framework.PackagePermission;

final class PackagePermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = -3350758995234427603L;
    private transient Map<String, PackagePermission> permissions = new HashMap<String, PackagePermission>();
    private boolean all_allowed = false;
    private Map<String, PackagePermission> filterPermissions;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Hashtable.class), new ObjectStreamField("all_allowed", Boolean.TYPE), new ObjectStreamField("filterPermissions", HashMap.class)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof PackagePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        PackagePermission packagePermission = (PackagePermission)permission;
        if (packagePermission.bundle != null) {
            throw new IllegalArgumentException("cannot add to collection: " + packagePermission);
        }
        String string = packagePermission.getName();
        Filter filter = packagePermission.filter;
        PackagePermissionCollection packagePermissionCollection = this;
        synchronized (packagePermissionCollection) {
            PackagePermission packagePermission2;
            Map<String, PackagePermission> map;
            if (filter != null) {
                map = this.filterPermissions;
                if (map == null) {
                    this.filterPermissions = map = new HashMap<String, PackagePermission>();
                }
            } else {
                map = this.permissions;
            }
            if ((packagePermission2 = map.get(string)) != null) {
                int n = packagePermission2.action_mask;
                int n2 = packagePermission.action_mask;
                if (n != n2) {
                    map.put(string, new PackagePermission(string, n | n2));
                }
            } else {
                map.put(string, packagePermission);
            }
            if (!this.all_allowed && string.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean implies(Permission permission) {
        Collection<PackagePermission> collection;
        if (!(permission instanceof PackagePermission)) {
            return false;
        }
        PackagePermission packagePermission = (PackagePermission)permission;
        if (packagePermission.filter != null) {
            return false;
        }
        String string = packagePermission.getName();
        int n = packagePermission.action_mask;
        int n2 = 0;
        PackagePermissionCollection packagePermissionCollection = this;
        synchronized (packagePermissionCollection) {
            PackagePermission packagePermission2;
            Map<String, PackagePermission> map = this.permissions;
            if (this.all_allowed && (packagePermission2 = map.get("*")) != null && ((n2 |= packagePermission2.action_mask) & n) == n) {
                return true;
            }
            packagePermission2 = map.get(string);
            if (packagePermission2 != null && ((n2 |= packagePermission2.action_mask) & n) == n) {
                return true;
            }
            int n3 = string.length() - 1;
            while (true) {
                int n4;
                if ((n4 = string.lastIndexOf(".", n3)) == -1) {
                    map = this.filterPermissions;
                    if (map != null) break;
                    return false;
                }
                packagePermission2 = (PackagePermission)map.get(string = String.valueOf(string.substring(0, n4 + 1)) + "*");
                if (packagePermission2 != null && ((n2 |= packagePermission2.action_mask) & n) == n) {
                    return true;
                }
                n3 = n4 - 1;
            }
            collection = map.values();
        }
        for (PackagePermission packagePermission3 : collection) {
            if (!packagePermission3.implies0(packagePermission, n2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        ArrayList<PackagePermission> arrayList = new ArrayList<PackagePermission>(this.permissions.values());
        Map<String, PackagePermission> map = this.filterPermissions;
        if (map != null) {
            arrayList.addAll(map.values());
        }
        return Collections.enumeration(arrayList);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable<String, PackagePermission> hashtable = new Hashtable<String, PackagePermission>(this.permissions);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("permissions", hashtable);
        putField.put("all_allowed", this.all_allowed);
        putField.put("filterPermissions", this.filterPermissions);
        objectOutputStream.writeFields();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        HashMap hashMap;
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Hashtable hashtable = (Hashtable)getField.get("permissions", null);
        this.permissions = new HashMap<String, PackagePermission>(hashtable);
        this.all_allowed = getField.get("all_allowed", false);
        this.filterPermissions = hashMap = (HashMap)getField.get("filterPermissions", null);
    }
}

