/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class FrameworkUtil {
    private FrameworkUtil() {
    }

    public static Filter createFilter(String string) throws InvalidSyntaxException {
        return FilterImpl.newInstance(string);
    }

    public static boolean matchDistinguishedNameChain(String string, List<String> list) {
        return DNChainMatching.match(string, list);
    }

    public static Bundle getBundle(final Class<?> clazz) {
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return clazz.getClassLoader();
            }
        });
        if (object instanceof BundleReference) {
            return ((BundleReference)object).getBundle();
        }
        return null;
    }

    private static final class CaseInsensitiveMap
    extends AbstractMap<String, Object>
    implements Map<String, Object> {
        private final Dictionary<String, ?> dictionary;
        private final String[] keys;

        CaseInsensitiveMap(Dictionary<String, ?> dictionary) {
            if (dictionary == null) {
                this.dictionary = null;
                this.keys = new String[0];
                return;
            }
            this.dictionary = dictionary;
            ArrayList<String> arrayList = new ArrayList<String>(dictionary.size());
            Enumeration<String> enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!(string instanceof String)) continue;
                String string2 = string;
                for (String string3 : arrayList) {
                    if (!string2.equalsIgnoreCase(string3)) continue;
                    throw new IllegalArgumentException();
                }
                arrayList.add(string2);
            }
            this.keys = arrayList.toArray(new String[arrayList.size()]);
        }

        @Override
        public Object get(Object object) {
            String string = (String)object;
            String[] stringArray = this.keys;
            int n = this.keys.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                if (string2.equalsIgnoreCase(string)) {
                    return this.dictionary.get(string2);
                }
                ++n2;
            }
            return null;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class DNChainMatching {
        private static final String MINUS_WILDCARD = "-";
        private static final String STAR_WILDCARD = "*";

        private DNChainMatching() {
        }

        private static boolean rdnmatch(List<?> list, List<?> list2) {
            if (list.size() != list2.size()) {
                return false;
            }
            int n = 0;
            while (n < list.size()) {
                int n2;
                String string = (String)list.get(n);
                String string2 = (String)list2.get(n);
                int n3 = string.indexOf(61);
                if (n3 != (n2 = string2.indexOf(61)) || !string.regionMatches(0, string2, 0, n3)) {
                    return false;
                }
                String string3 = string2.substring(n2);
                String string4 = string.substring(n3);
                if (!(string4.equals(string3) || string3.equals("=*") || string3.equals("=#16012a"))) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private static boolean dnmatch(List<?> list, List<?> list2) {
            int n = 0;
            int n2 = 0;
            int n3 = list2.size();
            if (n3 == 0) {
                return false;
            }
            if (list2.get(0).equals(STAR_WILDCARD)) {
                n2 = 1;
                --n3;
            }
            if (list.size() < n3) {
                return false;
            }
            if (list.size() > n3) {
                if (!list2.get(0).equals(STAR_WILDCARD)) {
                    return false;
                }
                n = list.size() - n3;
            }
            int n4 = 0;
            while (n4 < n3) {
                if (!DNChainMatching.rdnmatch((List)list.get(n4 + n), (List)list2.get(n4 + n2))) {
                    return false;
                }
                ++n4;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        private static List<Object> parseDNchainPattern(String string) {
            int n;
            if (string == null) {
                throw new IllegalArgumentException("The pattern must not be null.");
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n2 = string.length();
            int n3 = 59;
            int n4 = DNChainMatching.skipSpaces(string, 0);
            while (n4 < n2) {
                int n5 = n4;
                int n6 = n4;
                n = 0;
                block6: while (n5 < n2) {
                    n3 = string.charAt(n5);
                    switch (n3) {
                        case 34: {
                            n = n != 0 ? 0 : 1;
                            break;
                        }
                        case 92: {
                            if (++n5 != n2) break;
                            throw new IllegalArgumentException("unterminated escape");
                        }
                        case 59: {
                            if (n == 0) break block6;
                        }
                    }
                    if (n3 != 32) {
                        n6 = n5 + 1;
                    }
                    ++n5;
                }
                arrayList.add(string.substring(n4, n6));
                n4 = DNChainMatching.skipSpaces(string, n5 + 1);
            }
            if (n3 == 59) {
                throw new IllegalArgumentException("empty pattern");
            }
            n4 = 0;
            while (n4 < arrayList.size()) {
                String string2 = (String)arrayList.get(n4);
                if (!string2.equals(STAR_WILDCARD) && !string2.equals(MINUS_WILDCARD)) {
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    if (string2.charAt(0) == '*') {
                        n = DNChainMatching.skipSpaces(string2, 1);
                        if (string2.charAt(n) != ',') {
                            throw new IllegalArgumentException("invalid wildcard prefix");
                        }
                        arrayList2.add(STAR_WILDCARD);
                        string2 = new X500Principal(string2.substring(n + 1)).getName("CANONICAL");
                    } else {
                        string2 = new X500Principal(string2).getName("CANONICAL");
                    }
                    DNChainMatching.parseDN(string2, arrayList2);
                    arrayList.set(n4, arrayList2);
                }
                ++n4;
            }
            return arrayList;
        }

        private static List<Object> parseDNchain(List<String> list) {
            if (list == null) {
                throw new IllegalArgumentException("DN chain must not be null.");
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
            for (String string : list) {
                string = new X500Principal(string).getName("CANONICAL");
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                DNChainMatching.parseDN(string, arrayList2);
                arrayList.add(arrayList2);
            }
            if (arrayList.size() == 0) {
                throw new IllegalArgumentException("empty DN chain");
            }
            return arrayList;
        }

        private static int skipSpaces(String string, int n) {
            while (n < string.length() && string.charAt(n) == ' ') {
                ++n;
            }
            return n;
        }

        private static void parseDN(String string, List<Object> list) {
            int n = 0;
            char c = '\u0000';
            ArrayList<String> arrayList = new ArrayList<String>();
            while (n < string.length()) {
                int n2 = n;
                while (n2 < string.length()) {
                    c = string.charAt(n2);
                    if (c == ',' || c == '+') break;
                    if (c == '\\') {
                        ++n2;
                    }
                    ++n2;
                }
                if (n2 > string.length()) {
                    throw new IllegalArgumentException("unterminated escape " + string);
                }
                arrayList.add(string.substring(n, n2));
                if (c != '+') {
                    list.add(arrayList);
                    arrayList = n2 != string.length() ? new ArrayList() : null;
                }
                n = n2 + 1;
            }
            if (arrayList != null) {
                throw new IllegalArgumentException("improperly terminated DN " + string);
            }
        }

        private static int skipWildCards(List<Object> list, int n) {
            int n2 = n;
            while (n2 < list.size()) {
                Object object = list.get(n2);
                if (object instanceof String) {
                    if (!object.equals(STAR_WILDCARD) && !object.equals(MINUS_WILDCARD)) {
                        throw new IllegalArgumentException("expected wildcard in DN pattern");
                    }
                } else {
                    if (object instanceof List) break;
                    throw new IllegalArgumentException("expected String or List in DN Pattern");
                }
                ++n2;
            }
            return n2;
        }

        private static boolean dnChainMatch(List<Object> list, int n, List<Object> list2, int n2) throws IllegalArgumentException {
            if (n >= list.size()) {
                return false;
            }
            if (n2 >= list2.size()) {
                return false;
            }
            Object object = list2.get(n2);
            if (object instanceof String) {
                if (!object.equals(STAR_WILDCARD) && !object.equals(MINUS_WILDCARD)) {
                    throw new IllegalArgumentException("expected wildcard in DN pattern");
                }
                n2 = object.equals(MINUS_WILDCARD) ? DNChainMatching.skipWildCards(list2, n2) : ++n2;
                if (n2 >= list2.size()) {
                    return object.equals(MINUS_WILDCARD) ? true : list.size() - 1 == n;
                }
                if (object.equals(STAR_WILDCARD)) {
                    return DNChainMatching.dnChainMatch(list, n, list2, n2) || DNChainMatching.dnChainMatch(list, n + 1, list2, n2);
                }
                int n3 = n;
                while (n3 < list.size()) {
                    if (DNChainMatching.dnChainMatch(list, n3, list2, n2)) {
                        return true;
                    }
                    ++n3;
                }
            } else {
                if (object instanceof List) {
                    do {
                        if (!DNChainMatching.dnmatch((List)list.get(n), (List)object)) {
                            return false;
                        }
                        if (++n >= list.size() && ++n2 >= list2.size()) {
                            return true;
                        }
                        if (n >= list.size()) {
                            return (n2 = DNChainMatching.skipWildCards(list2, n2)) >= list2.size();
                        }
                        if (n2 >= list2.size()) {
                            return false;
                        }
                        object = list2.get(n2);
                        if (!(object instanceof String)) continue;
                        if (!object.equals(STAR_WILDCARD) && !object.equals(MINUS_WILDCARD)) {
                            throw new IllegalArgumentException("expected wildcard in DN pattern");
                        }
                        return DNChainMatching.dnChainMatch(list, n, list2, n2);
                    } while (object instanceof List);
                    throw new IllegalArgumentException("expected String or List in DN Pattern");
                }
                throw new IllegalArgumentException("expected String or List in DN Pattern");
            }
            return false;
        }

        static boolean match(String string, List<String> list) {
            List<Object> list2;
            List<Object> list3;
            try {
                list3 = DNChainMatching.parseDNchain(list);
            }
            catch (RuntimeException runtimeException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid DN chain: " + DNChainMatching.toString(list));
                illegalArgumentException.initCause(runtimeException);
                throw illegalArgumentException;
            }
            try {
                list2 = DNChainMatching.parseDNchainPattern(string);
            }
            catch (RuntimeException runtimeException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid match pattern: " + string);
                illegalArgumentException.initCause(runtimeException);
                throw illegalArgumentException;
            }
            return DNChainMatching.dnChainMatch(list3, 0, list2, 0);
        }

        private static String toString(List<?> list) {
            if (list == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator<?> iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append("; ");
            }
            return stringBuffer.toString();
        }
    }

    private static final class FilterImpl
    implements Filter {
        private static final int EQUAL = 1;
        private static final int APPROX = 2;
        private static final int GREATER = 3;
        private static final int LESS = 4;
        private static final int PRESENT = 5;
        private static final int SUBSTRING = 6;
        private static final int AND = 7;
        private static final int OR = 8;
        private static final int NOT = 9;
        private final int op;
        private final String attr;
        private final Object value;
        private transient String filterString;

        static FilterImpl newInstance(String string) throws InvalidSyntaxException {
            return new Parser(string).parse();
        }

        FilterImpl(int n, String string, Object object) {
            this.op = n;
            this.attr = string;
            this.value = object;
            this.filterString = null;
        }

        @Override
        public boolean match(ServiceReference<?> serviceReference) {
            return this.matches(new ServiceReferenceMap(serviceReference));
        }

        @Override
        public boolean match(Dictionary<String, ?> dictionary) {
            return this.matches(new CaseInsensitiveMap(dictionary));
        }

        @Override
        public boolean matchCase(Dictionary<String, ?> dictionary) {
            switch (this.op) {
                case 7: {
                    FilterImpl[] filterImplArray;
                    FilterImpl[] filterImplArray2 = filterImplArray = (FilterImpl[])this.value;
                    int n = filterImplArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FilterImpl filterImpl = filterImplArray2[n2];
                        if (!filterImpl.matchCase(dictionary)) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
                case 8: {
                    FilterImpl[] filterImplArray;
                    FilterImpl[] filterImplArray3 = filterImplArray = (FilterImpl[])this.value;
                    int n = filterImplArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        FilterImpl filterImpl = filterImplArray3[n3];
                        if (filterImpl.matchCase(dictionary)) {
                            return true;
                        }
                        ++n3;
                    }
                    return false;
                }
                case 9: {
                    FilterImpl filterImpl = (FilterImpl)this.value;
                    return !filterImpl.matchCase(dictionary);
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    Object var2_5 = dictionary == null ? null : dictionary.get(this.attr);
                    return this.compare(this.op, var2_5, this.value);
                }
                case 5: {
                    Object var2_6;
                    Object v0 = var2_6 = dictionary == null ? null : dictionary.get(this.attr);
                    return var2_6 != null;
                }
            }
            return false;
        }

        @Override
        public boolean matches(Map<String, ?> map) {
            switch (this.op) {
                case 7: {
                    FilterImpl[] filterImplArray;
                    FilterImpl[] filterImplArray2 = filterImplArray = (FilterImpl[])this.value;
                    int n = filterImplArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FilterImpl filterImpl = filterImplArray2[n2];
                        if (!filterImpl.matches(map)) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
                case 8: {
                    FilterImpl[] filterImplArray;
                    FilterImpl[] filterImplArray3 = filterImplArray = (FilterImpl[])this.value;
                    int n = filterImplArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        FilterImpl filterImpl = filterImplArray3[n3];
                        if (filterImpl.matches(map)) {
                            return true;
                        }
                        ++n3;
                    }
                    return false;
                }
                case 9: {
                    FilterImpl filterImpl = (FilterImpl)this.value;
                    return !filterImpl.matches(map);
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    Object var2_5 = map == null ? null : map.get(this.attr);
                    return this.compare(this.op, var2_5, this.value);
                }
                case 5: {
                    Object var2_6;
                    Object v0 = var2_6 = map == null ? null : map.get(this.attr);
                    return var2_6 != null;
                }
            }
            return false;
        }

        @Override
        public String toString() {
            String string = this.filterString;
            if (string == null) {
                this.filterString = string = this.normalize().toString();
            }
            return string;
        }

        private StringBuffer normalize() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            switch (this.op) {
                case 7: {
                    FilterImpl[] filterImplArray;
                    stringBuffer.append('&');
                    FilterImpl[] filterImplArray2 = filterImplArray = (FilterImpl[])this.value;
                    int n = filterImplArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FilterImpl filterImpl = filterImplArray2[n2];
                        stringBuffer.append(filterImpl.normalize());
                        ++n2;
                    }
                    break;
                }
                case 8: {
                    FilterImpl[] filterImplArray;
                    stringBuffer.append('|');
                    FilterImpl[] filterImplArray3 = filterImplArray = (FilterImpl[])this.value;
                    int n = filterImplArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        FilterImpl filterImpl = filterImplArray3[n3];
                        stringBuffer.append(filterImpl.normalize());
                        ++n3;
                    }
                    break;
                }
                case 9: {
                    stringBuffer.append('!');
                    FilterImpl filterImpl = (FilterImpl)this.value;
                    stringBuffer.append(filterImpl.normalize());
                    break;
                }
                case 6: {
                    String[] stringArray;
                    stringBuffer.append(this.attr);
                    stringBuffer.append('=');
                    String[] stringArray2 = stringArray = (String[])this.value;
                    int n = stringArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        String string = stringArray2[n4];
                        if (string == null) {
                            stringBuffer.append('*');
                        } else {
                            stringBuffer.append(FilterImpl.encodeValue(string));
                        }
                        ++n4;
                    }
                    break;
                }
                case 1: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append('=');
                    stringBuffer.append(FilterImpl.encodeValue((String)this.value));
                    break;
                }
                case 3: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append(">=");
                    stringBuffer.append(FilterImpl.encodeValue((String)this.value));
                    break;
                }
                case 4: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append("<=");
                    stringBuffer.append(FilterImpl.encodeValue((String)this.value));
                    break;
                }
                case 2: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append("~=");
                    stringBuffer.append(FilterImpl.encodeValue(FilterImpl.approxString((String)this.value)));
                    break;
                }
                case 5: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append("=*");
                }
            }
            stringBuffer.append(')');
            return stringBuffer;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Filter)) {
                return false;
            }
            return this.toString().equals(object.toString());
        }

        @Override
        public int hashCode() {
            return this.toString().hashCode();
        }

        private static String encodeValue(String string) {
            boolean bl = false;
            int n = string.length();
            int n2 = n << 1;
            char[] cArray = new char[n2];
            string.getChars(0, n, cArray, n);
            int n3 = 0;
            int n4 = n;
            while (n4 < n2) {
                char c = cArray[n4];
                switch (c) {
                    case '(': 
                    case ')': 
                    case '*': 
                    case '\\': {
                        cArray[n3] = 92;
                        ++n3;
                        bl = true;
                    }
                }
                cArray[n3] = c;
                ++n3;
                ++n4;
            }
            return bl ? new String(cArray, 0, n3) : string;
        }

        private boolean compare(int n, Object object, Object object2) {
            if (object == null) {
                return false;
            }
            if (object instanceof String) {
                return this.compare_String(n, (String)object, object2);
            }
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
                if (clazz2.isPrimitive()) {
                    return this.compare_PrimitiveArray(n, clazz2, object, object2);
                }
                return this.compare_ObjectArray(n, (Object[])object, object2);
            }
            if (object instanceof Collection) {
                return this.compare_Collection(n, (Collection)object, object2);
            }
            if (object instanceof Integer) {
                return this.compare_Integer(n, (Integer)object, object2);
            }
            if (object instanceof Long) {
                return this.compare_Long(n, (Long)object, object2);
            }
            if (object instanceof Byte) {
                return this.compare_Byte(n, (Byte)object, object2);
            }
            if (object instanceof Short) {
                return this.compare_Short(n, (Short)object, object2);
            }
            if (object instanceof Character) {
                return this.compare_Character(n, ((Character)object).charValue(), object2);
            }
            if (object instanceof Float) {
                return this.compare_Float(n, ((Float)object).floatValue(), object2);
            }
            if (object instanceof Double) {
                return this.compare_Double(n, (Double)object, object2);
            }
            if (object instanceof Boolean) {
                return this.compare_Boolean(n, (Boolean)object, object2);
            }
            if (object instanceof Comparable) {
                Comparable comparable = (Comparable)object;
                return this.compare_Comparable(n, comparable, object2);
            }
            return this.compare_Unknown(n, object, object2);
        }

        private boolean compare_Collection(int n, Collection<?> collection, Object object) {
            for (Object obj : collection) {
                if (!this.compare(n, obj, object)) continue;
                return true;
            }
            return false;
        }

        private boolean compare_ObjectArray(int n, Object[] objectArray, Object object) {
            Object[] objectArray2 = objectArray;
            int n2 = objectArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Object object2 = objectArray2[n3];
                if (this.compare(n, object2, object)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }

        private boolean compare_PrimitiveArray(int n, Class<?> clazz, Object object, Object object2) {
            if (Integer.TYPE.isAssignableFrom(clazz)) {
                int[] nArray;
                int[] nArray2 = nArray = (int[])object;
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = nArray2[n3];
                    if (this.compare_Integer(n, n4, object2)) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
            if (Long.TYPE.isAssignableFrom(clazz)) {
                long[] lArray;
                long[] lArray2 = lArray = (long[])object;
                int n5 = lArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    long l = lArray2[n6];
                    if (this.compare_Long(n, l, object2)) {
                        return true;
                    }
                    ++n6;
                }
                return false;
            }
            if (Byte.TYPE.isAssignableFrom(clazz)) {
                byte[] byArray;
                byte[] byArray2 = byArray = (byte[])object;
                int n7 = byArray.length;
                int n8 = 0;
                while (n8 < n7) {
                    byte by = byArray2[n8];
                    if (this.compare_Byte(n, by, object2)) {
                        return true;
                    }
                    ++n8;
                }
                return false;
            }
            if (Short.TYPE.isAssignableFrom(clazz)) {
                short[] sArray;
                short[] sArray2 = sArray = (short[])object;
                int n9 = sArray.length;
                int n10 = 0;
                while (n10 < n9) {
                    short s = sArray2[n10];
                    if (this.compare_Short(n, s, object2)) {
                        return true;
                    }
                    ++n10;
                }
                return false;
            }
            if (Character.TYPE.isAssignableFrom(clazz)) {
                char[] cArray;
                char[] cArray2 = cArray = (char[])object;
                int n11 = cArray.length;
                int n12 = 0;
                while (n12 < n11) {
                    char c = cArray2[n12];
                    if (this.compare_Character(n, c, object2)) {
                        return true;
                    }
                    ++n12;
                }
                return false;
            }
            if (Float.TYPE.isAssignableFrom(clazz)) {
                float[] fArray;
                float[] fArray2 = fArray = (float[])object;
                int n13 = fArray.length;
                int n14 = 0;
                while (n14 < n13) {
                    float f = fArray2[n14];
                    if (this.compare_Float(n, f, object2)) {
                        return true;
                    }
                    ++n14;
                }
                return false;
            }
            if (Double.TYPE.isAssignableFrom(clazz)) {
                double[] dArray;
                double[] dArray2 = dArray = (double[])object;
                int n15 = dArray.length;
                int n16 = 0;
                while (n16 < n15) {
                    double d = dArray2[n16];
                    if (this.compare_Double(n, d, object2)) {
                        return true;
                    }
                    ++n16;
                }
                return false;
            }
            if (Boolean.TYPE.isAssignableFrom(clazz)) {
                boolean[] blArray;
                boolean[] blArray2 = blArray = (boolean[])object;
                int n17 = blArray.length;
                int n18 = 0;
                while (n18 < n17) {
                    boolean bl = blArray2[n18];
                    if (this.compare_Boolean(n, bl, object2)) {
                        return true;
                    }
                    ++n18;
                }
                return false;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean compare_String(int n, String string, Object object) {
            switch (n) {
                case 6: {
                    String[] stringArray = (String[])object;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = stringArray.length;
                    while (n3 < n4) {
                        String string2 = stringArray[n3];
                        if (n3 + 1 < n4) {
                            if (string2 == null) {
                                String string3 = stringArray[n3 + 1];
                                if (string3 != null) {
                                    int n5 = string.indexOf(string3, n2);
                                    if (n5 == -1) {
                                        return false;
                                    }
                                    n2 = n5 + string3.length();
                                    if (n3 + 2 < n4) {
                                        ++n3;
                                    }
                                }
                            } else {
                                int n6 = string2.length();
                                if (!string.regionMatches(n2, string2, 0, n6)) return false;
                                n2 += n6;
                            }
                        } else {
                            if (string2 != null) return string.endsWith(string2);
                            return true;
                        }
                        ++n3;
                    }
                    return true;
                }
                case 1: {
                    return string.equals(object);
                }
                case 2: {
                    string = FilterImpl.approxString(string);
                    String string4 = FilterImpl.approxString((String)object);
                    return string.equalsIgnoreCase(string4);
                }
                case 3: {
                    return string.compareTo((String)object) >= 0;
                }
                case 4: {
                    return string.compareTo((String)object) <= 0;
                }
            }
            return false;
        }

        private boolean compare_Integer(int n, int n2, Object object) {
            int n3;
            if (n == 6) {
                return false;
            }
            try {
                n3 = Integer.parseInt(((String)object).trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            switch (n) {
                case 1: 
                case 2: {
                    return n2 == n3;
                }
                case 3: {
                    return n2 >= n3;
                }
                case 4: {
                    return n2 <= n3;
                }
            }
            return false;
        }

        private boolean compare_Long(int n, long l, Object object) {
            long l2;
            if (n == 6) {
                return false;
            }
            try {
                l2 = Long.parseLong(((String)object).trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            switch (n) {
                case 1: 
                case 2: {
                    return l == l2;
                }
                case 3: {
                    return l >= l2;
                }
                case 4: {
                    return l <= l2;
                }
            }
            return false;
        }

        private boolean compare_Byte(int n, byte by, Object object) {
            byte by2;
            if (n == 6) {
                return false;
            }
            try {
                by2 = Byte.parseByte(((String)object).trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            switch (n) {
                case 1: 
                case 2: {
                    return by == by2;
                }
                case 3: {
                    return by >= by2;
                }
                case 4: {
                    return by <= by2;
                }
            }
            return false;
        }

        private boolean compare_Short(int n, short s, Object object) {
            short s2;
            if (n == 6) {
                return false;
            }
            try {
                s2 = Short.parseShort(((String)object).trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            switch (n) {
                case 1: 
                case 2: {
                    return s == s2;
                }
                case 3: {
                    return s >= s2;
                }
                case 4: {
                    return s <= s2;
                }
            }
            return false;
        }

        private boolean compare_Character(int n, char c, Object object) {
            char c2;
            if (n == 6) {
                return false;
            }
            try {
                c2 = ((String)object).charAt(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            switch (n) {
                case 1: {
                    return c == c2;
                }
                case 2: {
                    return c == c2 || Character.toUpperCase(c) == Character.toUpperCase(c2) || Character.toLowerCase(c) == Character.toLowerCase(c2);
                }
                case 3: {
                    return c >= c2;
                }
                case 4: {
                    return c <= c2;
                }
            }
            return false;
        }

        private boolean compare_Boolean(int n, boolean bl, Object object) {
            if (n == 6) {
                return false;
            }
            boolean bl2 = Boolean.valueOf(((String)object).trim());
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return bl == bl2;
                }
            }
            return false;
        }

        private boolean compare_Float(int n, float f, Object object) {
            float f2;
            if (n == 6) {
                return false;
            }
            try {
                f2 = Float.parseFloat(((String)object).trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            switch (n) {
                case 1: 
                case 2: {
                    return Float.compare(f, f2) == 0;
                }
                case 3: {
                    return Float.compare(f, f2) >= 0;
                }
                case 4: {
                    return Float.compare(f, f2) <= 0;
                }
            }
            return false;
        }

        private boolean compare_Double(int n, double d, Object object) {
            double d2;
            if (n == 6) {
                return false;
            }
            try {
                d2 = Double.parseDouble(((String)object).trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            switch (n) {
                case 1: 
                case 2: {
                    return Double.compare(d, d2) == 0;
                }
                case 3: {
                    return Double.compare(d, d2) >= 0;
                }
                case 4: {
                    return Double.compare(d, d2) <= 0;
                }
            }
            return false;
        }

        private static Object valueOf(Class<?> clazz, String string) {
            block13: {
                Executable executable;
                block12: {
                    try {
                        executable = clazz.getMethod("valueOf", String.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        break block12;
                    }
                    if (Modifier.isStatic(((Method)executable).getModifiers()) && clazz.isAssignableFrom(((Method)executable).getReturnType())) {
                        FilterImpl.setAccessible(executable);
                        try {
                            return ((Method)executable).invoke(null, string.trim());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            return null;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            return null;
                        }
                    }
                }
                try {
                    executable = clazz.getConstructor(String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    break block13;
                }
                FilterImpl.setAccessible(executable);
                try {
                    return ((Constructor)executable).newInstance(string.trim());
                }
                catch (IllegalAccessException illegalAccessException) {
                    return null;
                }
                catch (InvocationTargetException invocationTargetException) {
                    return null;
                }
                catch (InstantiationException instantiationException) {
                    return null;
                }
            }
            return null;
        }

        private static void setAccessible(AccessibleObject accessibleObject) {
            if (!accessibleObject.isAccessible()) {
                AccessController.doPrivileged(new SetAccessibleAction(accessibleObject));
            }
        }

        private boolean compare_Comparable(int n, Comparable<Object> comparable, Object object) {
            if (n == 6) {
                return false;
            }
            object = FilterImpl.valueOf(comparable.getClass(), (String)object);
            if (object == null) {
                return false;
            }
            try {
                switch (n) {
                    case 1: 
                    case 2: {
                        return comparable.compareTo(object) == 0;
                    }
                    case 3: {
                        return comparable.compareTo(object) >= 0;
                    }
                    case 4: {
                        return comparable.compareTo(object) <= 0;
                    }
                }
            }
            catch (Exception exception) {
                return false;
            }
            return false;
        }

        private boolean compare_Unknown(int n, Object object, Object object2) {
            if (n == 6) {
                return false;
            }
            object2 = FilterImpl.valueOf(object.getClass(), (String)object2);
            if (object2 == null) {
                return false;
            }
            try {
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return object.equals(object2);
                    }
                }
            }
            catch (Exception exception) {
                return false;
            }
            return false;
        }

        private static String approxString(String string) {
            boolean bl = false;
            char[] cArray = string.toCharArray();
            int n = 0;
            char[] cArray2 = cArray;
            int n2 = cArray.length;
            int n3 = 0;
            while (n3 < n2) {
                char c = cArray2[n3];
                if (Character.isWhitespace(c)) {
                    bl = true;
                } else {
                    cArray[n] = c;
                    ++n;
                }
                ++n3;
            }
            return bl ? new String(cArray, 0, n) : string;
        }

        private static final class Parser {
            private final String filterstring;
            private final char[] filterChars;
            private int pos;

            Parser(String string) {
                this.filterstring = string;
                this.filterChars = string.toCharArray();
                this.pos = 0;
            }

            FilterImpl parse() throws InvalidSyntaxException {
                FilterImpl filterImpl;
                try {
                    filterImpl = this.parse_filter();
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new InvalidSyntaxException("Filter ended abruptly", this.filterstring, arrayIndexOutOfBoundsException);
                }
                if (this.pos != this.filterChars.length) {
                    throw new InvalidSyntaxException("Extraneous trailing characters: " + this.filterstring.substring(this.pos), this.filterstring);
                }
                return filterImpl;
            }

            private FilterImpl parse_filter() throws InvalidSyntaxException {
                this.skipWhiteSpace();
                if (this.filterChars[this.pos] != '(') {
                    throw new InvalidSyntaxException("Missing '(': " + this.filterstring.substring(this.pos), this.filterstring);
                }
                ++this.pos;
                FilterImpl filterImpl = this.parse_filtercomp();
                this.skipWhiteSpace();
                if (this.filterChars[this.pos] != ')') {
                    throw new InvalidSyntaxException("Missing ')': " + this.filterstring.substring(this.pos), this.filterstring);
                }
                ++this.pos;
                this.skipWhiteSpace();
                return filterImpl;
            }

            private FilterImpl parse_filtercomp() throws InvalidSyntaxException {
                this.skipWhiteSpace();
                char c = this.filterChars[this.pos];
                switch (c) {
                    case '&': {
                        ++this.pos;
                        return this.parse_and();
                    }
                    case '|': {
                        ++this.pos;
                        return this.parse_or();
                    }
                    case '!': {
                        ++this.pos;
                        return this.parse_not();
                    }
                }
                return this.parse_item();
            }

            private FilterImpl parse_and() throws InvalidSyntaxException {
                int n = this.pos;
                this.skipWhiteSpace();
                if (this.filterChars[this.pos] != '(') {
                    this.pos = n - 1;
                    return this.parse_item();
                }
                ArrayList<FilterImpl> arrayList = new ArrayList<FilterImpl>(10);
                while (this.filterChars[this.pos] == '(') {
                    FilterImpl filterImpl = this.parse_filter();
                    arrayList.add(filterImpl);
                }
                return new FilterImpl(7, null, arrayList.toArray(new FilterImpl[arrayList.size()]));
            }

            private FilterImpl parse_or() throws InvalidSyntaxException {
                int n = this.pos;
                this.skipWhiteSpace();
                if (this.filterChars[this.pos] != '(') {
                    this.pos = n - 1;
                    return this.parse_item();
                }
                ArrayList<FilterImpl> arrayList = new ArrayList<FilterImpl>(10);
                while (this.filterChars[this.pos] == '(') {
                    FilterImpl filterImpl = this.parse_filter();
                    arrayList.add(filterImpl);
                }
                return new FilterImpl(8, null, arrayList.toArray(new FilterImpl[arrayList.size()]));
            }

            private FilterImpl parse_not() throws InvalidSyntaxException {
                int n = this.pos;
                this.skipWhiteSpace();
                if (this.filterChars[this.pos] != '(') {
                    this.pos = n - 1;
                    return this.parse_item();
                }
                FilterImpl filterImpl = this.parse_filter();
                return new FilterImpl(9, null, filterImpl);
            }

            private FilterImpl parse_item() throws InvalidSyntaxException {
                String string = this.parse_attr();
                this.skipWhiteSpace();
                switch (this.filterChars[this.pos]) {
                    case '~': {
                        if (this.filterChars[this.pos + 1] != '=') break;
                        this.pos += 2;
                        return new FilterImpl(2, string, this.parse_value());
                    }
                    case '>': {
                        if (this.filterChars[this.pos + 1] != '=') break;
                        this.pos += 2;
                        return new FilterImpl(3, string, this.parse_value());
                    }
                    case '<': {
                        if (this.filterChars[this.pos + 1] != '=') break;
                        this.pos += 2;
                        return new FilterImpl(4, string, this.parse_value());
                    }
                    case '=': {
                        if (this.filterChars[this.pos + 1] == '*') {
                            int n = this.pos;
                            this.pos += 2;
                            this.skipWhiteSpace();
                            if (this.filterChars[this.pos] == ')') {
                                return new FilterImpl(5, string, null);
                            }
                            this.pos = n;
                        }
                        ++this.pos;
                        Object object = this.parse_substring();
                        if (object instanceof String) {
                            return new FilterImpl(1, string, object);
                        }
                        return new FilterImpl(6, string, object);
                    }
                }
                throw new InvalidSyntaxException("Invalid operator: " + this.filterstring.substring(this.pos), this.filterstring);
            }

            private String parse_attr() throws InvalidSyntaxException {
                this.skipWhiteSpace();
                int n = this.pos;
                int n2 = this.pos;
                char c = this.filterChars[this.pos];
                while (c != '~' && c != '<' && c != '>' && c != '=' && c != '(' && c != ')') {
                    ++this.pos;
                    if (!Character.isWhitespace(c)) {
                        n2 = this.pos;
                    }
                    c = this.filterChars[this.pos];
                }
                int n3 = n2 - n;
                if (n3 == 0) {
                    throw new InvalidSyntaxException("Missing attr: " + this.filterstring.substring(this.pos), this.filterstring);
                }
                return new String(this.filterChars, n, n3);
            }

            private String parse_value() throws InvalidSyntaxException {
                StringBuffer stringBuffer = new StringBuffer(this.filterChars.length - this.pos);
                block5: while (true) {
                    char c = this.filterChars[this.pos];
                    switch (c) {
                        case ')': {
                            break block5;
                        }
                        case '(': {
                            throw new InvalidSyntaxException("Invalid value: " + this.filterstring.substring(this.pos), this.filterstring);
                        }
                        case '\\': {
                            ++this.pos;
                            c = this.filterChars[this.pos];
                        }
                        default: {
                            stringBuffer.append(c);
                            ++this.pos;
                            continue block5;
                        }
                    }
                    break;
                }
                if (stringBuffer.length() == 0) {
                    throw new InvalidSyntaxException("Missing value: " + this.filterstring.substring(this.pos), this.filterstring);
                }
                return stringBuffer.toString();
            }

            private Object parse_substring() throws InvalidSyntaxException {
                Object e;
                int n;
                StringBuffer stringBuffer = new StringBuffer(this.filterChars.length - this.pos);
                ArrayList<String> arrayList = new ArrayList<String>(10);
                block6: while (true) {
                    n = this.filterChars[this.pos];
                    switch (n) {
                        case 41: {
                            if (stringBuffer.length() <= 0) break block6;
                            arrayList.add(stringBuffer.toString());
                            break block6;
                        }
                        case 40: {
                            throw new InvalidSyntaxException("Invalid value: " + this.filterstring.substring(this.pos), this.filterstring);
                        }
                        case 42: {
                            if (stringBuffer.length() > 0) {
                                arrayList.add(stringBuffer.toString());
                            }
                            stringBuffer.setLength(0);
                            arrayList.add(null);
                            ++this.pos;
                            continue block6;
                        }
                        case 92: {
                            ++this.pos;
                            n = this.filterChars[this.pos];
                        }
                        default: {
                            stringBuffer.append((char)n);
                            ++this.pos;
                            continue block6;
                        }
                    }
                    break;
                }
                if ((n = arrayList.size()) == 0) {
                    return "";
                }
                if (n == 1 && (e = arrayList.get(0)) != null) {
                    return e;
                }
                return arrayList.toArray(new String[n]);
            }

            private void skipWhiteSpace() {
                int n = this.filterChars.length;
                while (this.pos < n && Character.isWhitespace(this.filterChars[this.pos])) {
                    ++this.pos;
                }
            }
        }
    }

    private static final class ServiceReferenceMap
    extends AbstractMap<String, Object>
    implements Map<String, Object> {
        private final ServiceReference<?> reference;

        ServiceReferenceMap(ServiceReference<?> serviceReference) {
            this.reference = serviceReference;
        }

        @Override
        public Object get(Object object) {
            if (this.reference == null) {
                return null;
            }
            return this.reference.getProperty((String)object);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class SetAccessibleAction
    implements PrivilegedAction<Void> {
        private final AccessibleObject accessible;

        SetAccessibleAction(AccessibleObject accessibleObject) {
            this.accessible = accessibleObject;
        }

        @Override
        public Void run() {
            this.accessible.setAccessible(true);
            return null;
        }
    }
}

