/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.AdminPermission;

final class AdminPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 3906372644575328048L;
    private transient Map<String, AdminPermission> permissions = new HashMap<String, AdminPermission>();
    private boolean all_allowed;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Hashtable.class), new ObjectStreamField("all_allowed", Boolean.TYPE)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof AdminPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        AdminPermission adminPermission = (AdminPermission)permission;
        if (adminPermission.bundle != null) {
            throw new IllegalArgumentException("cannot add to collection: " + adminPermission);
        }
        String string = adminPermission.getName();
        AdminPermissionCollection adminPermissionCollection = this;
        synchronized (adminPermissionCollection) {
            Map<String, AdminPermission> map = this.permissions;
            AdminPermission adminPermission2 = map.get(string);
            if (adminPermission2 != null) {
                int n = adminPermission2.action_mask;
                int n2 = adminPermission.action_mask;
                if (n != n2) {
                    map.put(string, new AdminPermission(adminPermission2.filter, n | n2));
                }
            } else {
                map.put(string, adminPermission);
            }
            if (!this.all_allowed && string.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        Collection<AdminPermission> collection;
        if (!(permission instanceof AdminPermission)) {
            return false;
        }
        AdminPermission adminPermission = (AdminPermission)permission;
        if (adminPermission.filter != null) {
            return false;
        }
        int n = 0;
        AdminPermissionCollection serializable2 = this;
        synchronized (serializable2) {
            Map<String, AdminPermission> map;
            block7: {
                int n2;
                AdminPermission adminPermission2;
                map = this.permissions;
                if (!this.all_allowed || (adminPermission2 = map.get("*")) == null || ((n |= adminPermission2.action_mask) & (n2 = adminPermission.action_mask)) != n2) break block7;
                return true;
            }
            collection = map.values();
        }
        for (AdminPermission adminPermission3 : collection) {
            if (!adminPermission3.implies0(adminPermission, n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        ArrayList<AdminPermission> arrayList = new ArrayList<AdminPermission>(this.permissions.values());
        return Collections.enumeration(arrayList);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable<String, AdminPermission> hashtable = new Hashtable<String, AdminPermission>(this.permissions);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("permissions", hashtable);
        putField.put("all_allowed", this.all_allowed);
        objectOutputStream.writeFields();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Hashtable hashtable = (Hashtable)getField.get("permissions", null);
        this.permissions = new HashMap<String, AdminPermission>(hashtable);
        this.all_allowed = getField.get("all_allowed", false);
    }
}

