/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.AdaptPermission;

final class AdaptPermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = -3350758995234427603L;
    private Map<String, AdaptPermission> permissions = new HashMap<String, AdaptPermission>();
    private boolean all_allowed = false;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", HashMap.class), new ObjectStreamField("all_allowed", Boolean.TYPE)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof AdaptPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        AdaptPermission adaptPermission = (AdaptPermission)permission;
        if (adaptPermission.bundle != null) {
            throw new IllegalArgumentException("cannot add to collection: " + adaptPermission);
        }
        String string = adaptPermission.getName();
        AdaptPermissionCollection adaptPermissionCollection = this;
        synchronized (adaptPermissionCollection) {
            Map<String, AdaptPermission> map = this.permissions;
            AdaptPermission adaptPermission2 = map.get(string);
            if (adaptPermission2 != null) {
                int n = adaptPermission2.action_mask;
                int n2 = adaptPermission.action_mask;
                if (n != n2) {
                    map.put(string, new AdaptPermission(adaptPermission2.filter, n | n2));
                }
            } else {
                map.put(string, adaptPermission);
            }
            if (!this.all_allowed && string.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        Collection<AdaptPermission> collection;
        if (!(permission instanceof AdaptPermission)) {
            return false;
        }
        AdaptPermission adaptPermission = (AdaptPermission)permission;
        if (adaptPermission.filter != null) {
            return false;
        }
        int n = 0;
        AdaptPermissionCollection serializable2 = this;
        synchronized (serializable2) {
            Map<String, AdaptPermission> map;
            block7: {
                int n2;
                AdaptPermission adaptPermission2;
                map = this.permissions;
                if (!this.all_allowed || (adaptPermission2 = map.get("*")) == null || ((n |= adaptPermission2.action_mask) & (n2 = adaptPermission.action_mask)) != n2) break block7;
                return true;
            }
            collection = map.values();
        }
        for (AdaptPermission adaptPermission3 : collection) {
            if (!adaptPermission3.implies0(adaptPermission, n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        ArrayList<AdaptPermission> arrayList = new ArrayList<AdaptPermission>(this.permissions.values());
        return Collections.enumeration(arrayList);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("permissions", this.permissions);
        putField.put("all_allowed", this.all_allowed);
        objectOutputStream.writeFields();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        HashMap hashMap;
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.permissions = hashMap = (HashMap)getField.get("permissions", null);
        this.all_allowed = getField.get("all_allowed", false);
    }
}

