/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;

public class SmartHighlightPainter
extends ChangeableHighlightPainter {
    private Color borderColor;
    private boolean paintBorder;

    public SmartHighlightPainter() {
        super(Color.BLUE);
    }

    public SmartHighlightPainter(Paint paint) {
        super(paint);
    }

    public boolean getPaintBorder() {
        return this.paintBorder;
    }

    @Override
    public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
        graphics.setColor((Color)this.getPaint());
        if (n == n2) {
            try {
                Shape shape2 = view.modelToView(n, shape, Position.Bias.Forward);
                Rectangle rectangle = shape2.getBounds();
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
                return rectangle;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return null;
            }
        }
        if (n == view.getStartOffset() && n2 == view.getEndOffset()) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            return rectangle;
        }
        try {
            Shape shape3 = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
            Rectangle rectangle = shape3 instanceof Rectangle ? (Rectangle)shape3 : shape3.getBounds();
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.paintBorder) {
                graphics.setColor(this.borderColor);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            }
            return rectangle;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    @Override
    public void setPaint(Paint paint) {
        super.setPaint(paint);
        if (paint instanceof Color) {
            this.borderColor = ((Color)paint).darker();
        }
    }

    public void setPaintBorder(boolean bl) {
        this.paintBorder = bl;
    }
}

