/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rtextarea.RDocument;
import org.fife.ui.rtextarea.RDocumentCharSequence;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RegExReplaceInfo;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchResult;

public class SearchEngine {
    private SearchEngine() {
    }

    public static SearchResult find(JTextArea jTextArea, SearchContext searchContext) {
        SearchResult searchResult;
        if (jTextArea instanceof RTextArea || searchContext.getMarkAll()) {
            ((RTextArea)jTextArea).clearMarkAllHighlights();
        }
        boolean bl = jTextArea instanceof RTextArea && searchContext.getMarkAll();
        String string = searchContext.getSearchFor();
        if (string == null || string.length() == 0) {
            if (bl) {
                List<DocumentRange> list = Collections.emptyList();
                ((RTextArea)jTextArea).markAll(list);
            }
            return new SearchResult();
        }
        Caret caret = jTextArea.getCaret();
        boolean bl2 = searchContext.getSearchForward();
        int n = bl2 ? Math.max(caret.getDot(), caret.getMark()) : Math.min(caret.getDot(), caret.getMark());
        String string2 = SearchEngine.getFindInText(jTextArea, n, bl2);
        if (string2 == null || string2.length() == 0) {
            return new SearchResult();
        }
        int n2 = 0;
        if (bl) {
            n2 = SearchEngine.markAllImpl((RTextArea)jTextArea, searchContext).getMarkedCount();
        }
        if ((searchResult = SearchEngine.findImpl(string2, searchContext)).wasFound() && !searchResult.getMatchRange().isZeroLength()) {
            jTextArea.getCaret().setSelectionVisible(true);
            if (bl2 && n > -1) {
                searchResult.getMatchRange().translate(n);
            }
            RSyntaxUtilities.selectAndPossiblyCenter(jTextArea, searchResult.getMatchRange(), true);
        }
        searchResult.setMarkedCount(n2);
        return searchResult;
    }

    private static SearchResult findImpl(String string, SearchContext searchContext) {
        String string2 = searchContext.getSearchFor();
        boolean bl = searchContext.getSearchForward();
        DocumentRange documentRange = null;
        if (!searchContext.isRegularExpression()) {
            int n = SearchEngine.getNextMatchPos(string2, string, bl, searchContext.getMatchCase(), searchContext.getWholeWord());
            string = null;
            if (n != -1) {
                documentRange = new DocumentRange(n, n + string2.length());
            }
        } else {
            Point point = null;
            int n = 0;
            do {
                if ((point = SearchEngine.getNextMatchPosRegEx(string2, string.substring(n), bl, searchContext.getMatchCase(), searchContext.getWholeWord())) == null) continue;
                if (point.x != point.y) {
                    point.translate(n, n);
                    documentRange = new DocumentRange(point.x, point.y);
                    continue;
                }
                n += point.x + 1;
            } while (n < string.length() && point != null && documentRange == null);
        }
        if (documentRange != null) {
            return new SearchResult(documentRange, 1, 0);
        }
        return new SearchResult();
    }

    private static CharSequence getFindInCharSequence(RTextArea rTextArea, int n, boolean bl) {
        RDocument rDocument = (RDocument)rTextArea.getDocument();
        int n2 = 0;
        int n3 = 0;
        if (bl) {
            n2 = n;
            n3 = rDocument.getLength();
        } else {
            n2 = 0;
            n3 = n;
        }
        return new RDocumentCharSequence(rDocument, n2, n3);
    }

    private static String getFindInText(JTextArea jTextArea, int n, boolean bl) {
        String string = null;
        try {
            string = bl ? jTextArea.getText(n, jTextArea.getDocument().getLength() - n) : jTextArea.getText(0, n);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return string;
    }

    private static List getMatches(Matcher matcher, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (matcher.find()) {
            Point point = new Point(matcher.start(), matcher.end());
            if (string == null) {
                arrayList.add(point);
                continue;
            }
            arrayList.add(new RegExReplaceInfo(matcher.group(0), point.x, point.y, SearchEngine.getReplacementText(matcher, string)));
        }
        return arrayList;
    }

    public static final int getNextMatchPos(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (!bl2) {
            return SearchEngine.getNextMatchPosImpl(string.toLowerCase(), string2.toLowerCase(), bl, bl2, bl3);
        }
        return SearchEngine.getNextMatchPosImpl(string, string2, bl, bl2, bl3);
    }

    private static final int getNextMatchPosImpl(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            int n = string.length();
            int n2 = bl ? 0 : string2.length();
            int n3 = bl ? 1 : -1;
            while ((n2 = bl ? string2.indexOf(string, n2) : string2.lastIndexOf(string, n2)) != -1) {
                if (SearchEngine.isWholeWord(string2, n2, n)) {
                    return n2;
                }
                n2 += n3;
            }
            return n2;
        }
        return bl ? string2.indexOf(string) : string2.lastIndexOf(string);
    }

    private static Point getNextMatchPosRegEx(String string, CharSequence charSequence, boolean bl, boolean bl2, boolean bl3) {
        return (Point)SearchEngine.getNextMatchPosRegExImpl(string, charSequence, bl, bl2, bl3, null);
    }

    private static Object getNextMatchPosRegExImpl(String string, CharSequence charSequence, boolean bl, boolean bl2, boolean bl3, String string2) {
        if (bl3) {
            string = "\\b" + string + "\\b";
        }
        int n = 8;
        n = RSyntaxUtilities.getPatternFlags(bl2, n);
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(string, n);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
        Matcher matcher = pattern.matcher(charSequence);
        if (bl) {
            if (matcher.find()) {
                if (string2 == null) {
                    return new Point(matcher.start(), matcher.end());
                }
                return new RegExReplaceInfo(matcher.group(0), matcher.start(), matcher.end(), SearchEngine.getReplacementText(matcher, string2));
            }
        } else {
            List list = SearchEngine.getMatches(matcher, string2);
            if (!list.isEmpty()) {
                return list.get(list.size() - 1);
            }
        }
        return null;
    }

    private static RegExReplaceInfo getRegExReplaceInfo(CharSequence charSequence, SearchContext searchContext) {
        String string = searchContext.getReplaceWith();
        if (string == null) {
            string = "";
        }
        String string2 = searchContext.getSearchFor();
        boolean bl = searchContext.getSearchForward();
        boolean bl2 = searchContext.getMatchCase();
        boolean bl3 = searchContext.getWholeWord();
        return (RegExReplaceInfo)SearchEngine.getNextMatchPosRegExImpl(string2, charSequence, bl, bl2, bl3, string);
    }

    public static String getReplacementText(Matcher matcher, CharSequence charSequence) {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (n < charSequence.length()) {
            char c = charSequence.charAt(n);
            if (c == '\\') {
                c = charSequence.charAt(++n);
                switch (c) {
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 't': {
                        c = '\t';
                    }
                }
                stringBuilder.append(c);
                ++n;
                continue;
            }
            if (c == '$') {
                int n2;
                if ((n2 = charSequence.charAt(++n) - 48) < 0 || n2 > 9) {
                    throw new IndexOutOfBoundsException("No group " + charSequence.charAt(n));
                }
                ++n;
                boolean bl = false;
                while (!bl) {
                    int n3;
                    if (n >= charSequence.length() || (n3 = charSequence.charAt(n) - 48) < 0 || n3 > 9) break;
                    int n4 = n2 * 10 + n3;
                    if (matcher.groupCount() < n4) {
                        bl = true;
                        continue;
                    }
                    n2 = n4;
                    ++n;
                }
                if (matcher.group(n2) == null) continue;
                stringBuilder.append(matcher.group(n2));
                continue;
            }
            stringBuilder.append(c);
            ++n;
        }
        return stringBuilder.toString();
    }

    private static final boolean isWholeWord(CharSequence charSequence, int n, int n2) {
        boolean bl;
        boolean bl2;
        try {
            bl2 = !Character.isLetterOrDigit(charSequence.charAt(n - 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            bl2 = true;
        }
        try {
            bl = !Character.isLetterOrDigit(charSequence.charAt(n + n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            bl = true;
        }
        return bl2 && bl;
    }

    private static final int makeMarkAndDotEqual(JTextArea jTextArea, boolean bl) {
        Caret caret = jTextArea.getCaret();
        int n = bl ? Math.min(caret.getDot(), caret.getMark()) : Math.max(caret.getDot(), caret.getMark());
        caret.setDot(n);
        return n;
    }

    public static final SearchResult markAll(RTextArea rTextArea, SearchContext searchContext) {
        rTextArea.clearMarkAllHighlights();
        return SearchEngine.markAllImpl(rTextArea, searchContext);
    }

    private static final SearchResult markAllImpl(RTextArea rTextArea, SearchContext searchContext) {
        String string = searchContext.getSearchFor();
        int n = 0;
        if (searchContext.getMarkAll() && string != null && string.length() > 0) {
            ArrayList<DocumentRange> arrayList = new ArrayList<DocumentRange>();
            searchContext = searchContext.clone();
            searchContext.setSearchForward(true);
            searchContext.setMarkAll(false);
            String string2 = rTextArea.getText();
            int n2 = 0;
            if (!searchContext.getMatchCase()) {
                searchContext.setMatchCase(true);
                searchContext.setSearchFor(string.toLowerCase());
                string2 = string2.toLowerCase();
            }
            SearchResult searchResult = SearchEngine.findImpl(string2, searchContext);
            while (searchResult.wasFound()) {
                DocumentRange documentRange = searchResult.getMatchRange().translate(n2);
                if (documentRange.isZeroLength()) {
                    n2 = documentRange.getEndOffset() + 1;
                    if (n2 > string2.length()) {
                        break;
                    }
                } else {
                    arrayList.add(documentRange);
                    n2 = documentRange.getEndOffset();
                }
                searchResult = SearchEngine.findImpl(string2.substring(n2), searchContext);
            }
            rTextArea.markAll(arrayList);
            n = arrayList.size();
        } else {
            List<DocumentRange> list = Collections.emptyList();
            rTextArea.markAll(list);
        }
        return new SearchResult(null, 0, n);
    }

    private static SearchResult regexReplace(RTextArea rTextArea, SearchContext searchContext) throws PatternSyntaxException {
        int n;
        Caret caret = rTextArea.getCaret();
        boolean bl = searchContext.getSearchForward();
        int n2 = SearchEngine.makeMarkAndDotEqual(rTextArea, bl);
        CharSequence charSequence = SearchEngine.getFindInCharSequence(rTextArea, n2, bl);
        if (charSequence == null) {
            return new SearchResult();
        }
        int n3 = 0;
        if (searchContext.getMarkAll()) {
            n3 = SearchEngine.markAllImpl(rTextArea, searchContext).getMarkedCount();
        }
        RegExReplaceInfo regExReplaceInfo = SearchEngine.getRegExReplaceInfo(charSequence, searchContext);
        DocumentRange documentRange = null;
        if (regExReplaceInfo != null) {
            caret.setSelectionVisible(true);
            n = regExReplaceInfo.getStartIndex();
            int n4 = regExReplaceInfo.getEndIndex();
            if (bl) {
                n += n2;
                n4 += n2;
            }
            rTextArea.setSelectionStart(n);
            rTextArea.setSelectionEnd(n4);
            String string = regExReplaceInfo.getReplacement();
            rTextArea.replaceSelection(string);
            int n5 = n + string.length();
            charSequence = SearchEngine.getFindInCharSequence(rTextArea, n5, bl);
            regExReplaceInfo = SearchEngine.getRegExReplaceInfo(charSequence, searchContext);
            if (regExReplaceInfo != null) {
                n = regExReplaceInfo.getStartIndex();
                n4 = regExReplaceInfo.getEndIndex();
                if (bl) {
                    n += n5;
                    n4 += n5;
                }
                documentRange = new DocumentRange(n, n4);
            } else {
                documentRange = new DocumentRange(n5, n5);
            }
            RSyntaxUtilities.selectAndPossiblyCenter(rTextArea, documentRange, true);
        }
        n = documentRange != null ? 1 : 0;
        return new SearchResult(documentRange, n, n3);
    }

    public static SearchResult replace(RTextArea rTextArea, SearchContext searchContext) throws PatternSyntaxException {
        String string;
        if (searchContext.getMarkAll()) {
            rTextArea.clearMarkAllHighlights();
        }
        if ((string = searchContext.getSearchFor()) == null || string.length() == 0) {
            return new SearchResult();
        }
        rTextArea.beginAtomicEdit();
        try {
            if (searchContext.isRegularExpression()) {
                SearchResult searchResult = SearchEngine.regexReplace(rTextArea, searchContext);
                return searchResult;
            }
            SearchEngine.makeMarkAndDotEqual(rTextArea, searchContext.getSearchForward());
            SearchResult searchResult = SearchEngine.find(rTextArea, searchContext);
            if (searchResult.wasFound() && !searchResult.getMatchRange().isZeroLength()) {
                String string2 = searchContext.getReplaceWith();
                rTextArea.replaceSelection(string2);
                int n = searchResult.getMatchRange().getStartOffset();
                if (searchContext.getSearchForward()) {
                    int n2 = string2 == null ? 0 : string2.length();
                    n += n2;
                }
                rTextArea.setCaretPosition(n);
                SearchResult searchResult2 = SearchEngine.find(rTextArea, searchContext);
                DocumentRange documentRange = searchResult2.wasFound() ? searchResult2.getMatchRange() : new DocumentRange(n, n);
                searchResult.setMatchRange(documentRange);
                RSyntaxUtilities.selectAndPossiblyCenter(rTextArea, documentRange, true);
            }
            SearchResult searchResult3 = searchResult;
            return searchResult3;
        }
        finally {
            rTextArea.endAtomicEdit();
        }
    }

    public static SearchResult replaceAll(RTextArea rTextArea, SearchContext searchContext) throws PatternSyntaxException {
        if (searchContext.getMarkAll()) {
            rTextArea.clearMarkAllHighlights();
        }
        searchContext.setSearchForward(true);
        String string = searchContext.getSearchFor();
        if (string == null || string.length() == 0) {
            return new SearchResult();
        }
        if (searchContext.getMarkAll()) {
            searchContext = searchContext.clone();
            searchContext.setMarkAll(false);
        }
        SearchResult searchResult = null;
        int n = 0;
        rTextArea.beginAtomicEdit();
        try {
            int n2 = rTextArea.getCaretPosition();
            rTextArea.setCaretPosition(0);
            SearchResult searchResult2 = SearchEngine.replace(rTextArea, searchContext);
            while (searchResult2.wasFound()) {
                searchResult = searchResult2;
                ++n;
                searchResult2 = SearchEngine.replace(rTextArea, searchContext);
            }
            if (searchResult == null) {
                rTextArea.setCaretPosition(n2);
                searchResult = new SearchResult();
            }
        }
        finally {
            rTextArea.endAtomicEdit();
        }
        searchResult.setCount(n);
        return searchResult;
    }
}

