/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.fife.print.RPrintUtilities;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rtextarea.CaretStyle;
import org.fife.ui.rtextarea.ConfigurableCaret;
import org.fife.ui.rtextarea.IconGroup;
import org.fife.ui.rtextarea.LineHighlightManager;
import org.fife.ui.rtextarea.Macro;
import org.fife.ui.rtextarea.RDocument;
import org.fife.ui.rtextarea.RTextAreaBase;
import org.fife.ui.rtextarea.RTextAreaEditorKit;
import org.fife.ui.rtextarea.RTextAreaHighlighter;
import org.fife.ui.rtextarea.RTextAreaUI;
import org.fife.ui.rtextarea.RUndoManager;
import org.fife.ui.rtextarea.RecordableTextAction;
import org.fife.ui.rtextarea.SmartHighlightPainter;
import org.fife.ui.rtextarea.ToolTipSupplier;

public class RTextArea
extends RTextAreaBase
implements Printable {
    public static final int INSERT_MODE = 0;
    public static final int OVERWRITE_MODE = 1;
    public static final String MARK_ALL_COLOR_PROPERTY = "RTA.markAllColor";
    public static final String MARK_ALL_OCCURRENCES_CHANGED_PROPERTY = "RTA.markAllOccurrencesChanged";
    private static final int MIN_ACTION_CONSTANT = 0;
    public static final int COPY_ACTION = 0;
    public static final int CUT_ACTION = 1;
    public static final int DELETE_ACTION = 2;
    public static final int PASTE_ACTION = 3;
    public static final int REDO_ACTION = 4;
    public static final int SELECT_ALL_ACTION = 5;
    public static final int UNDO_ACTION = 6;
    private static final int MAX_ACTION_CONSTANT = 6;
    private static final Color DEFAULT_MARK_ALL_COLOR = new Color(16762880);
    private int textMode;
    private static boolean recordingMacro;
    private static Macro currentMacro;
    private JPopupMenu popupMenu;
    private JMenuItem undoMenuItem;
    private JMenuItem redoMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem deleteMenuItem;
    private static boolean popupMenuCreated;
    private static String selectedOccurrenceText;
    private ToolTipSupplier toolTipSupplier;
    private static RecordableTextAction cutAction;
    private static RecordableTextAction copyAction;
    private static RecordableTextAction pasteAction;
    private static RecordableTextAction deleteAction;
    private static RecordableTextAction undoAction;
    private static RecordableTextAction redoAction;
    private static RecordableTextAction selectAllAction;
    private static IconGroup iconGroup;
    private transient RUndoManager undoManager;
    private transient LineHighlightManager lineHighlightManager;
    private SmartHighlightPainter markAllHighlightPainter;
    private CaretStyle[] carets;
    private static final String MSG = "org.fife.ui.rtextarea.RTextArea";
    private static Locale locale;
    private static StringBuilder repTabsSB;
    private static Segment repTabsSeg;

    static {
        locale = Locale.getDefault();
        repTabsSeg = new Segment();
    }

    public RTextArea() {
    }

    public RTextArea(AbstractDocument abstractDocument) {
        super(abstractDocument);
    }

    public RTextArea(String string) {
        super(string);
    }

    public RTextArea(int n, int n2) {
        super(n, n2);
    }

    public RTextArea(String string, int n, int n2) {
        super(string, n, n2);
    }

    public RTextArea(AbstractDocument abstractDocument, String string, int n, int n2) {
        super(abstractDocument, string, n, n2);
    }

    public RTextArea(int n) {
        this.setTextMode(n);
    }

    public static void setRTALocale(Locale locale) {
        RTextArea.locale = locale;
    }

    static synchronized void addToCurrentMacro(String string, String string2) {
        currentMacro.addMacroRecord(new Macro.MacroRecord(string, string2));
    }

    public Object addLineHighlight(int n, Color color) throws BadLocationException {
        if (this.lineHighlightManager == null) {
            this.lineHighlightManager = new LineHighlightManager(this);
        }
        return this.lineHighlightManager.addLineHighlight(n, color);
    }

    public void beginAtomicEdit() {
        this.undoManager.beginInternalAtomicEdit();
    }

    public static synchronized void beginRecordingMacro() {
        if (RTextArea.isRecordingMacro()) {
            return;
        }
        if (currentMacro != null) {
            currentMacro = null;
        }
        currentMacro = new Macro();
        recordingMacro = true;
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    void clearMarkAllHighlights() {
        ((RTextAreaHighlighter)this.getHighlighter()).clearMarkAllHighlights();
        this.repaint();
    }

    protected void configurePopupMenu(JPopupMenu jPopupMenu) {
        boolean bl;
        boolean bl2 = bl = this.isEditable() && this.isEnabled();
        if (this.undoMenuItem != null) {
            this.undoMenuItem.setEnabled(undoAction.isEnabled() && bl);
            this.redoMenuItem.setEnabled(redoAction.isEnabled() && bl);
            this.cutMenuItem.setEnabled(cutAction.isEnabled() && bl);
            this.pasteMenuItem.setEnabled(pasteAction.isEnabled() && bl);
            this.deleteMenuItem.setEnabled(deleteAction.isEnabled() && bl);
        }
    }

    @Override
    protected Document createDefaultModel() {
        return new RDocument();
    }

    @Override
    protected RTextAreaBase.RTAMouseListener createMouseListener() {
        return new RTextAreaMutableCaretEvent(this);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.undoMenuItem = this.createPopupMenuItem(undoAction);
        jPopupMenu.add(this.undoMenuItem);
        this.redoMenuItem = this.createPopupMenuItem(redoAction);
        jPopupMenu.add(this.redoMenuItem);
        jPopupMenu.addSeparator();
        this.cutMenuItem = this.createPopupMenuItem(cutAction);
        jPopupMenu.add(this.cutMenuItem);
        jPopupMenu.add(this.createPopupMenuItem(copyAction));
        this.pasteMenuItem = this.createPopupMenuItem(pasteAction);
        jPopupMenu.add(this.pasteMenuItem);
        this.deleteMenuItem = this.createPopupMenuItem(deleteAction);
        jPopupMenu.add(this.deleteMenuItem);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.createPopupMenuItem(selectAllAction));
        return jPopupMenu;
    }

    public static void createPopupMenuActions() {
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(MSG, locale);
        cutAction = new RTextAreaEditorKit.CutAction();
        cutAction.setProperties(resourceBundle, "Action.Cut");
        cutAction.setAccelerator(KeyStroke.getKeyStroke(88, n));
        copyAction = new RTextAreaEditorKit.CopyAction();
        copyAction.setProperties(resourceBundle, "Action.Copy");
        copyAction.setAccelerator(KeyStroke.getKeyStroke(67, n));
        pasteAction = new RTextAreaEditorKit.PasteAction();
        pasteAction.setProperties(resourceBundle, "Action.Paste");
        pasteAction.setAccelerator(KeyStroke.getKeyStroke(86, n));
        deleteAction = new RTextAreaEditorKit.DeleteNextCharAction();
        deleteAction.setProperties(resourceBundle, "Action.Delete");
        deleteAction.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        undoAction = new RTextAreaEditorKit.UndoAction();
        undoAction.setProperties(resourceBundle, "Action.Undo");
        undoAction.setAccelerator(KeyStroke.getKeyStroke(90, n));
        redoAction = new RTextAreaEditorKit.RedoAction();
        redoAction.setProperties(resourceBundle, "Action.Redo");
        redoAction.setAccelerator(KeyStroke.getKeyStroke(89, n));
        selectAllAction = new RTextAreaEditorKit.SelectAllAction();
        selectAllAction.setProperties(resourceBundle, "Action.SelectAll");
        selectAllAction.setAccelerator(KeyStroke.getKeyStroke(65, n));
    }

    protected JMenuItem createPopupMenuItem(Action action) {
        JMenuItem jMenuItem = new JMenuItem(action){

            @Override
            public void setToolTipText(String string) {
            }
        };
        jMenuItem.setAccelerator(null);
        return jMenuItem;
    }

    @Override
    protected RTextAreaUI createRTextAreaUI() {
        return new RTextAreaUI(this);
    }

    private final String createSpacer(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append(' ');
            ++n2;
        }
        return stringBuilder.toString();
    }

    protected RUndoManager createUndoManager() {
        return new RUndoManager(this);
    }

    public void discardAllEdits() {
        this.undoManager.discardAllEdits();
        this.getDocument().removeUndoableEditListener(this.undoManager);
        this.undoManager = this.createUndoManager();
        this.getDocument().addUndoableEditListener(this.undoManager);
        this.undoManager.updateActions();
    }

    public void endAtomicEdit() {
        this.undoManager.endInternalAtomicEdit();
    }

    public static synchronized void endRecordingMacro() {
        if (!RTextArea.isRecordingMacro()) {
            return;
        }
        recordingMacro = false;
    }

    @Override
    protected void fireCaretUpdate(CaretEvent caretEvent) {
        this.possiblyUpdateCurrentLineHighlightLocation();
        if (caretEvent != null && caretEvent.getDot() != caretEvent.getMark()) {
            cutAction.setEnabled(true);
            copyAction.setEnabled(true);
        } else if (cutAction.isEnabled()) {
            cutAction.setEnabled(false);
            copyAction.setEnabled(false);
        }
        super.fireCaretUpdate(caretEvent);
    }

    private void fixCtrlH() {
        InputMap inputMap = this.getInputMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke("typed \b");
        InputMap inputMap2 = inputMap;
        while (inputMap2 != null) {
            inputMap2.remove(keyStroke);
            inputMap2 = inputMap2.getParent();
        }
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke("BACK_SPACE");
        inputMap.put(keyStroke2, "delete-previous");
    }

    public static RecordableTextAction getAction(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        switch (n) {
            case 0: {
                return copyAction;
            }
            case 1: {
                return cutAction;
            }
            case 2: {
                return deleteAction;
            }
            case 3: {
                return pasteAction;
            }
            case 4: {
                return redoAction;
            }
            case 5: {
                return selectAllAction;
            }
            case 6: {
                return undoAction;
            }
        }
        return null;
    }

    public static synchronized Macro getCurrentMacro() {
        return currentMacro;
    }

    public static final Color getDefaultMarkAllHighlightColor() {
        return DEFAULT_MARK_ALL_COLOR;
    }

    public static IconGroup getIconGroup() {
        return iconGroup;
    }

    LineHighlightManager getLineHighlightManager() {
        return this.lineHighlightManager;
    }

    public Color getMarkAllHighlightColor() {
        return (Color)this.markAllHighlightPainter.getPaint();
    }

    public int getMaxAscent() {
        return this.getFontMetrics(this.getFont()).getAscent();
    }

    public JPopupMenu getPopupMenu() {
        if (!popupMenuCreated) {
            this.popupMenu = this.createPopupMenu();
            if (this.popupMenu != null) {
                ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                this.popupMenu.applyComponentOrientation(componentOrientation);
            }
            popupMenuCreated = true;
        }
        return this.popupMenu;
    }

    public static String getSelectedOccurrenceText() {
        return selectedOccurrenceText;
    }

    public final int getTextMode() {
        return this.textMode;
    }

    public ToolTipSupplier getToolTipSupplier() {
        return this.toolTipSupplier;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        if (this.getToolTipSupplier() != null) {
            string = this.getToolTipSupplier().getToolTipText(this, mouseEvent);
        }
        return string != null ? string : super.getToolTipText();
    }

    protected void handleReplaceSelection(String string) {
        super.replaceSelection(string);
    }

    @Override
    protected void init() {
        super.init();
        if (cutAction == null) {
            RTextArea.createPopupMenuActions();
        }
        this.undoManager = this.createUndoManager();
        this.getDocument().addUndoableEditListener(this.undoManager);
        Color color = RTextArea.getDefaultMarkAllHighlightColor();
        this.markAllHighlightPainter = new SmartHighlightPainter(color);
        this.setMarkAllHighlightColor(color);
        this.carets = new CaretStyle[2];
        this.setCaretStyle(0, CaretStyle.THICK_VERTICAL_LINE_STYLE);
        this.setCaretStyle(1, CaretStyle.BLOCK_STYLE);
        this.setDragEnabled(true);
        this.setTextMode(0);
        this.fixCtrlH();
    }

    public static synchronized boolean isRecordingMacro() {
        return recordingMacro;
    }

    public static synchronized void loadMacro(Macro macro) {
        currentMacro = macro;
    }

    void markAll(List<DocumentRange> list) {
        RTextAreaHighlighter rTextAreaHighlighter = (RTextAreaHighlighter)this.getHighlighter();
        if (rTextAreaHighlighter != null) {
            if (list != null) {
                for (DocumentRange documentRange : list) {
                    try {
                        rTextAreaHighlighter.addMarkAllHighlight(documentRange.getStartOffset(), documentRange.getEndOffset(), this.markAllHighlightPainter);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            }
            this.repaint();
            this.firePropertyChange(MARK_ALL_OCCURRENCES_CHANGED_PROPERTY, null, list);
        }
    }

    @Override
    public void paste() {
        this.beginAtomicEdit();
        try {
            super.paste();
        }
        finally {
            this.endAtomicEdit();
        }
    }

    public synchronized void playbackLastMacro() {
        List<Macro.MacroRecord> list;
        if (currentMacro != null && !(list = currentMacro.getMacroRecords()).isEmpty()) {
            Action[] actionArray = this.getActions();
            this.undoManager.beginInternalAtomicEdit();
            try {
                block3: for (Macro.MacroRecord macroRecord : list) {
                    int n = 0;
                    while (n < actionArray.length) {
                        if (actionArray[n] instanceof RecordableTextAction && macroRecord.id.equals(((RecordableTextAction)actionArray[n]).getMacroID())) {
                            actionArray[n].actionPerformed(new ActionEvent(this, 1001, macroRecord.actionCommand));
                            continue block3;
                        }
                        ++n;
                    }
                }
            }
            finally {
                this.undoManager.endInternalAtomicEdit();
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        return RPrintUtilities.printDocumentWordWrap(graphics, this, this.getFont(), n, pageFormat, this.getTabSize());
    }

    @Override
    public void read(Reader reader, Object object) throws IOException {
        RTextAreaEditorKit rTextAreaEditorKit = (RTextAreaEditorKit)this.getUI().getEditorKit(this);
        this.setText(null);
        Document document = this.getDocument();
        if (object != null) {
            document.putProperty("stream", object);
        }
        try {
            rTextAreaEditorKit.read(reader, document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.undoManager = this.createUndoManager();
        this.getDocument().addUndoableEditListener(this.undoManager);
        this.lineHighlightManager = null;
    }

    public void redoLastAction() {
        try {
            if (this.undoManager.canRedo()) {
                this.undoManager.redo();
            }
        }
        catch (CannotRedoException cannotRedoException) {
            cannotRedoException.printStackTrace();
        }
    }

    public void removeAllLineHighlights() {
        if (this.lineHighlightManager != null) {
            this.lineHighlightManager.removeAllLineHighlights();
        }
    }

    public void removeLineHighlight(Object object) {
        if (this.lineHighlightManager != null) {
            this.lineHighlightManager.removeLineHighlight(object);
        }
    }

    @Override
    public void replaceRange(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("end before start");
        }
        Document document = this.getDocument();
        if (document != null) {
            try {
                try {
                    this.undoManager.beginInternalAtomicEdit();
                    ((AbstractDocument)document).replace(n, n2 - n, string, null);
                }
                catch (BadLocationException badLocationException) {
                    throw new IllegalArgumentException(badLocationException.getMessage());
                }
            }
            finally {
                this.undoManager.endInternalAtomicEdit();
            }
        }
    }

    @Override
    public void replaceSelection(String string) {
        int n;
        int n2;
        if (string == null) {
            this.handleReplaceSelection(string);
            return;
        }
        if (this.getTabsEmulated() && (n2 = string.indexOf(9)) > -1) {
            n = this.getSelectionStart();
            try {
                string = this.replaceTabsWithSpaces(string, n, n2);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        if (this.textMode == 1 && !"\n".equals(string)) {
            Caret caret = this.getCaret();
            n = caret.getDot();
            Document document = this.getDocument();
            Element element = document.getDefaultRootElement();
            int n3 = element.getElementIndex(n);
            int n4 = element.getElementCount() - 1;
            try {
                int n5 = this.getLineEndOffset(n3);
                if (n == caret.getMark() && n != n5) {
                    n = n3 == n4 ? Math.min(n + string.length(), n5) : Math.min(n + string.length(), n5 - 1);
                    caret.moveDot(n);
                }
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
                badLocationException.printStackTrace();
            }
        }
        this.handleReplaceSelection(string);
    }

    private final String replaceTabsWithSpaces(String string, int n, int n2) throws BadLocationException {
        int n3;
        int n4;
        int n5 = this.getTabSize();
        Document document = this.getDocument();
        Element element = document.getDefaultRootElement();
        Element element2 = element.getElement(n4 = element.getElementIndex(n));
        int n6 = element2.getStartOffset();
        int n7 = n - n6;
        if (n7 > 0) {
            document.getText(n6, n7, repTabsSeg);
            n7 = 0;
            int n8 = 0;
            while (n8 < RTextArea.repTabsSeg.count) {
                n3 = RTextArea.repTabsSeg.array[RTextArea.repTabsSeg.offset + n8];
                n7 = n3 == 9 ? 0 : (n7 + 1) % n5;
                ++n8;
            }
        }
        if (string.length() == 1) {
            return this.createSpacer(n5 - n7);
        }
        if (repTabsSB == null) {
            repTabsSB = new StringBuilder();
        }
        repTabsSB.setLength(0);
        char[] cArray = string.toCharArray();
        n3 = 0;
        int n9 = n7;
        int n10 = n2;
        while (n10 < cArray.length) {
            char c = cArray[n10];
            switch (c) {
                case '\t': {
                    if (n10 > n3) {
                        repTabsSB.append(cArray, n3, n10 - n3);
                    }
                    int n11 = n5 - n9 % n5;
                    repTabsSB.append(this.createSpacer(n11));
                    n3 = n10 + 1;
                    n9 = 0;
                    break;
                }
                case '\n': {
                    n9 = 0;
                    break;
                }
                default: {
                    ++n9;
                }
            }
            ++n10;
        }
        if (n3 < cArray.length) {
            repTabsSB.append(cArray, n3, cArray.length - n3);
        }
        return repTabsSB.toString();
    }

    public static void setActionProperties(int n, String string, char c, KeyStroke keyStroke) {
        RTextArea.setActionProperties(n, string, Integer.valueOf(c), keyStroke);
    }

    public static void setActionProperties(int n, String string, Integer n2, KeyStroke keyStroke) {
        RecordableTextAction recordableTextAction = null;
        switch (n) {
            case 1: {
                recordableTextAction = cutAction;
                break;
            }
            case 0: {
                recordableTextAction = copyAction;
                break;
            }
            case 3: {
                recordableTextAction = pasteAction;
                break;
            }
            case 2: {
                recordableTextAction = deleteAction;
                break;
            }
            case 5: {
                recordableTextAction = selectAllAction;
                break;
            }
            default: {
                return;
            }
        }
        recordableTextAction.putValue("Name", string);
        recordableTextAction.putValue("ShortDescription", string);
        recordableTextAction.putValue("AcceleratorKey", keyStroke);
        recordableTextAction.putValue("MnemonicKey", n2);
    }

    @Override
    public void setCaret(Caret caret) {
        super.setCaret(caret);
        if (this.carets != null && caret instanceof ConfigurableCaret) {
            ((ConfigurableCaret)caret).setStyle(this.carets[this.getTextMode()]);
        }
    }

    public void setCaretStyle(int n, CaretStyle caretStyle) {
        if (caretStyle == null) {
            caretStyle = CaretStyle.THICK_VERTICAL_LINE_STYLE;
        }
        this.carets[n] = caretStyle;
        if (n == this.getTextMode() && this.getCaret() instanceof ConfigurableCaret) {
            ((ConfigurableCaret)this.getCaret()).setStyle(caretStyle);
        }
    }

    @Override
    public void setDocument(Document document) {
        Document document2;
        if (!(document instanceof RDocument)) {
            throw new IllegalArgumentException("RTextArea requires instances of RDocument for its document");
        }
        if (this.undoManager != null && (document2 = this.getDocument()) != null) {
            document2.removeUndoableEditListener(this.undoManager);
        }
        super.setDocument(document);
        if (this.undoManager != null) {
            document.addUndoableEditListener(this.undoManager);
            this.discardAllEdits();
        }
    }

    public static synchronized void setIconGroup(IconGroup iconGroup) {
        Icon icon = iconGroup.getIcon("cut");
        cutAction.putValue("SmallIcon", icon);
        icon = iconGroup.getIcon("copy");
        copyAction.putValue("SmallIcon", icon);
        icon = iconGroup.getIcon("paste");
        pasteAction.putValue("SmallIcon", icon);
        icon = iconGroup.getIcon("delete");
        deleteAction.putValue("SmallIcon", icon);
        icon = iconGroup.getIcon("undo");
        undoAction.putValue("SmallIcon", icon);
        icon = iconGroup.getIcon("redo");
        redoAction.putValue("SmallIcon", icon);
        icon = iconGroup.getIcon("selectall");
        selectAllAction.putValue("SmallIcon", icon);
        RTextArea.iconGroup = iconGroup;
    }

    public void setMarkAllHighlightColor(Color color) {
        Color color2 = (Color)this.markAllHighlightPainter.getPaint();
        if (color2 != null && !color2.equals(color)) {
            this.markAllHighlightPainter.setPaint(color);
            RTextAreaHighlighter rTextAreaHighlighter = (RTextAreaHighlighter)this.getHighlighter();
            if (rTextAreaHighlighter.getMarkAllHighlightCount() > 0) {
                this.repaint();
            }
            this.firePropertyChange(MARK_ALL_COLOR_PROPERTY, color2, color);
        }
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popupMenu = jPopupMenu;
        popupMenuCreated = true;
    }

    public static void setPopupMenuCreated(boolean bl) {
        popupMenuCreated = bl;
    }

    @Override
    public void setRoundedSelectionEdges(boolean bl) {
        if (this.getRoundedSelectionEdges() != bl) {
            this.markAllHighlightPainter.setRoundedEdges(bl);
            super.setRoundedSelectionEdges(bl);
        }
    }

    public static void setSelectedOccurrenceText(String string) {
        selectedOccurrenceText = string;
    }

    public void setTextMode(int n) {
        if (n != 0 && n != 1) {
            n = 0;
        }
        if (this.textMode != n) {
            Caret caret = this.getCaret();
            if (caret instanceof ConfigurableCaret) {
                ((ConfigurableCaret)caret).setStyle(this.carets[n]);
            }
            this.textMode = n;
            caret.setVisible(false);
            caret.setVisible(true);
        }
    }

    public void setToolTipSupplier(ToolTipSupplier toolTipSupplier) {
        this.toolTipSupplier = toolTipSupplier;
    }

    @Override
    public final void setUI(TextUI textUI) {
        RTextAreaUI rTextAreaUI;
        if (this.popupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.popupMenu);
        }
        if ((rTextAreaUI = (RTextAreaUI)this.getUI()) != null) {
            rTextAreaUI.installDefaults();
        }
    }

    public void undoLastAction() {
        try {
            if (this.undoManager.canUndo()) {
                this.undoManager.undo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            cannotUndoException.printStackTrace();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.getDocument().removeUndoableEditListener(this.undoManager);
        objectOutputStream.defaultWriteObject();
        this.getDocument().addUndoableEditListener(this.undoManager);
    }

    protected class RTextAreaMutableCaretEvent
    extends RTextAreaBase.RTAMouseListener {
        protected RTextAreaMutableCaretEvent(RTextArea rTextArea2) {
            super(RTextArea.this, rTextArea2);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Caret caret = RTextArea.this.getCaret();
            boolean bl = caret.getDot() != caret.getMark();
            cutAction.setEnabled(bl);
            copyAction.setEnabled(bl);
            RTextArea.this.undoManager.updateActions();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0) {
                Caret caret = RTextArea.this.getCaret();
                this.dot = caret.getDot();
                this.mark = caret.getMark();
                RTextArea.this.fireCaretUpdate(this);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            } else if ((mouseEvent.getModifiers() & 0x10) != 0) {
                Caret caret = RTextArea.this.getCaret();
                this.dot = caret.getDot();
                this.mark = caret.getMark();
                RTextArea.this.fireCaretUpdate(this);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        private void showPopup(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu = RTextArea.this.getPopupMenu();
            if (jPopupMenu != null) {
                RTextArea.this.configurePopupMenu(jPopupMenu);
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                mouseEvent.consume();
            }
        }
    }
}

