/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.fife.io.UnicodeReader;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Macro {
    private String name;
    private ArrayList<MacroRecord> macroRecords;
    private static final String ROOT_ELEMENT = "macro";
    private static final String MACRO_NAME = "macroName";
    private static final String ACTION = "action";
    private static final String ID = "id";
    private static final String UNTITLED_MACRO_NAME = "<Untitled>";
    private static final String FILE_ENCODING = "UTF-8";

    public Macro() {
        this(UNTITLED_MACRO_NAME);
    }

    public Macro(File file) throws FileNotFoundException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        Document document = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(new UnicodeReader(new FileInputStream(file), FILE_ENCODING));
            inputSource.setEncoding(FILE_ENCODING);
            document = documentBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = exception.getMessage();
            if (string == null) {
                string = exception.toString();
            }
            throw new IOException("Error parsing XML: " + string);
        }
        this.macroRecords = new ArrayList();
        boolean bl = this.initializeFromXMLFile(document.getDocumentElement());
        if (!bl) {
            this.name = null;
            this.macroRecords.clear();
            this.macroRecords = null;
            throw new IOException("Error parsing XML!");
        }
    }

    public Macro(String string) {
        this(string, null);
    }

    public Macro(String string, List<MacroRecord> list) {
        this.name = string;
        if (list != null) {
            this.macroRecords = new ArrayList(list.size());
            for (MacroRecord macroRecord : list) {
                this.macroRecords.add(macroRecord);
            }
        } else {
            this.macroRecords = new ArrayList(10);
        }
    }

    public void addMacroRecord(MacroRecord macroRecord) {
        if (macroRecord != null) {
            this.macroRecords.add(macroRecord);
        }
    }

    public List<MacroRecord> getMacroRecords() {
        return this.macroRecords;
    }

    public String getName() {
        return this.name;
    }

    private boolean initializeFromXMLFile(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            short s = node.getNodeType();
            switch (s) {
                case 1: {
                    Object object;
                    String string = node.getNodeName();
                    if (string.equals(MACRO_NAME)) {
                        object = node.getChildNodes();
                        this.name = UNTITLED_MACRO_NAME;
                        if (object.getLength() <= 0) break;
                        node = object.item(0);
                        short s2 = node.getNodeType();
                        if (s2 != 4 && s2 != 3) {
                            return false;
                        }
                        this.name = node.getNodeValue().trim();
                        break;
                    }
                    if (!string.equals(ACTION)) break;
                    object = node.getAttributes();
                    if (object == null || object.getLength() != 1) {
                        return false;
                    }
                    Node node2 = object.item(0);
                    MacroRecord macroRecord = new MacroRecord();
                    if (!node2.getNodeName().equals(ID)) {
                        return false;
                    }
                    macroRecord.id = node2.getNodeValue();
                    NodeList nodeList2 = node.getChildNodes();
                    int n3 = nodeList2.getLength();
                    if (n3 == 0) {
                        macroRecord.actionCommand = "";
                        this.macroRecords.add(macroRecord);
                        break;
                    }
                    node = nodeList2.item(0);
                    short s3 = node.getNodeType();
                    if (s3 != 4 && s3 != 3) {
                        return false;
                    }
                    macroRecord.actionCommand = node.getNodeValue();
                    this.macroRecords.add(macroRecord);
                    break;
                }
            }
            ++n2;
        }
        return true;
    }

    public void saveToFile(File file) throws IOException {
        this.saveToFile(file.getAbsolutePath());
    }

    public void saveToFile(String string) throws IOException {
        try {
            Object object;
            Object object2;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            Document document = dOMImplementation.createDocument(null, ROOT_ELEMENT, null);
            Element element = document.getDocumentElement();
            Element element2 = document.createElement(MACRO_NAME);
            element.appendChild(element2);
            for (MacroRecord object32 : this.macroRecords) {
                object2 = document.createElement(ACTION);
                object2.setAttribute(ID, object32.id);
                if (object32.actionCommand != null && object32.actionCommand.length() > 0) {
                    object = object32.actionCommand;
                    int n = 0;
                    while (n < ((String)object).length()) {
                        if (((String)object).charAt(n) < ' ' && n < ((String)(object = ((String)object).substring(0, n))).length() - 1) {
                            object = String.valueOf(object) + ((String)object).substring(n + 1);
                        }
                        ++n;
                    }
                    CDATASection n2 = document.createCDATASection((String)object);
                    object2.appendChild(n2);
                }
                element.appendChild((Node)object2);
            }
            StreamResult streamResult = new StreamResult(new File(string));
            DOMSource dOMSource = new DOMSource(document);
            object2 = TransformerFactory.newInstance();
            object = ((TransformerFactory)object2).newTransformer();
            ((Transformer)object).setOutputProperty("indent", "yes");
            ((Transformer)object).setOutputProperty("encoding", FILE_ENCODING);
            ((Transformer)object).transform(dOMSource, streamResult);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IOException("Error generating XML!");
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    static class MacroRecord {
        public String id;
        public String actionCommand;

        public MacroRecord() {
            this(null, null);
        }

        public MacroRecord(String string, String string2) {
            this.id = string;
            this.actionCommand = string2;
        }
    }
}

