/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconGroup {
    private String path;
    private boolean separateLargeIcons;
    private String largeIconSubDir;
    private String extension;
    private String name;
    private String jarFile;
    private static final String DEFAULT_EXTENSION = "gif";

    public IconGroup(String string, String string2) {
        this(string, string2, null);
    }

    public IconGroup(String string, String string2, String string3) {
        this(string, string2, string3, DEFAULT_EXTENSION);
    }

    public IconGroup(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, null);
    }

    public IconGroup(String string, String string2, String string3, String string4, String string5) {
        this.name = string;
        this.path = string2;
        if (string2 != null && string2.length() > 0 && !string2.endsWith("/")) {
            this.path = String.valueOf(this.path) + "/";
        }
        this.separateLargeIcons = string3 != null;
        this.largeIconSubDir = string3;
        this.extension = string4 != null ? string4 : DEFAULT_EXTENSION;
        this.jarFile = string5;
    }

    public boolean equals(Object object) {
        IconGroup iconGroup;
        if (object != null && object instanceof IconGroup && (iconGroup = (IconGroup)object).getName().equals(this.getName()) && this.separateLargeIcons == iconGroup.hasSeparateLargeIcons()) {
            if (this.separateLargeIcons && !this.largeIconSubDir.equals(iconGroup.largeIconSubDir)) {
                return false;
            }
            return this.path.equals(iconGroup.path);
        }
        return false;
    }

    public Icon getIcon(String string) {
        Icon icon = this.getIconImpl(String.valueOf(this.path) + string + "." + this.extension);
        if (icon != null && (icon.getIconWidth() < 1 || icon.getIconHeight() < 1)) {
            icon = null;
        }
        return icon;
    }

    private Icon getIconImpl(String string) {
        try {
            if (this.jarFile == null) {
                URL uRL = this.getClass().getClassLoader().getResource(string);
                if (uRL != null) {
                    return new ImageIcon(uRL);
                }
                BufferedImage bufferedImage = ImageIO.read(new File(string));
                return bufferedImage != null ? new ImageIcon(bufferedImage) : null;
            }
            URL uRL = new URL("jar:file:///" + this.jarFile + "!/" + string);
            return new ImageIcon(uRL);
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Icon getLargeIcon(String string) {
        return this.getIconImpl(String.valueOf(this.path) + this.largeIconSubDir + "/" + string + "." + this.extension);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasSeparateLargeIcons() {
        return this.separateLargeIcons;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

