/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.CaretStyle;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;

public class ConfigurableCaret
extends DefaultCaret {
    private static transient Action selectWord = null;
    private static transient Action selectLine = null;
    private transient MouseEvent selectedWordEvent = null;
    private transient Segment seg = new Segment();
    private CaretStyle style;
    private ChangeableHighlightPainter selectionPainter;
    private boolean alwaysVisible;

    public ConfigurableCaret() {
        this(CaretStyle.THICK_VERTICAL_LINE_STYLE);
    }

    public ConfigurableCaret(CaretStyle caretStyle) {
        this.setStyle(caretStyle);
        this.selectionPainter = new ChangeableHighlightPainter();
    }

    private void adjustCaret(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 1) != 0 && this.getDot() != -1) {
            this.moveCaret(mouseEvent);
        } else {
            this.positionCaret(mouseEvent);
        }
    }

    private void adjustFocus(boolean bl) {
        RTextArea rTextArea = this.getTextArea();
        if (rTextArea != null && rTextArea.isEnabled() && rTextArea.isRequestFocusEnabled()) {
            if (bl) {
                rTextArea.requestFocusInWindow();
            } else {
                rTextArea.requestFocus();
            }
        }
    }

    @Override
    protected synchronized void damage(Rectangle rectangle) {
        if (rectangle != null) {
            this.validateWidth(rectangle);
            this.x = rectangle.x - 1;
            this.y = rectangle.y;
            this.width = rectangle.width + 4;
            this.height = rectangle.height;
            this.repaint();
        }
    }

    @Override
    public void deinstall(JTextComponent jTextComponent) {
        if (!(jTextComponent instanceof RTextArea)) {
            throw new IllegalArgumentException("c must be instance of RTextArea");
        }
        super.deinstall(jTextComponent);
        jTextComponent.setNavigationFilter(null);
    }

    protected RTextArea getTextArea() {
        return (RTextArea)this.getComponent();
    }

    public boolean getRoundedSelectionEdges() {
        return ((ChangeableHighlightPainter)this.getSelectionPainter()).getRoundedEdges();
    }

    @Override
    protected Highlighter.HighlightPainter getSelectionPainter() {
        return this.selectionPainter;
    }

    public CaretStyle getStyle() {
        return this.style;
    }

    @Override
    public void install(JTextComponent jTextComponent) {
        if (!(jTextComponent instanceof RTextArea)) {
            throw new IllegalArgumentException("c must be instance of RTextArea");
        }
        super.install(jTextComponent);
        jTextComponent.setNavigationFilter(new FoldAwareNavigationFilter());
    }

    public boolean isAlwaysVisible() {
        return this.alwaysVisible;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            JTextComponent jTextComponent;
            RTextArea rTextArea = this.getTextArea();
            int n = mouseEvent.getClickCount();
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (n > 2) {
                    switch (n %= 2) {
                        case 0: {
                            this.selectWord(mouseEvent);
                            this.selectedWordEvent = null;
                            break;
                        }
                        case 1: {
                            Action action = null;
                            ActionMap actionMap = rTextArea.getActionMap();
                            if (actionMap != null) {
                                action = actionMap.get("select-line");
                            }
                            if (action == null) {
                                if (selectLine == null) {
                                    selectLine = new RTextAreaEditorKit.SelectLineAction();
                                }
                                action = selectLine;
                            }
                            action.actionPerformed(new ActionEvent(rTextArea, 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (SwingUtilities.isMiddleMouseButton(mouseEvent) && n == 1 && rTextArea.isEditable() && rTextArea.isEnabled() && (jTextComponent = (JTextComponent)mouseEvent.getSource()) != null) {
                try {
                    Toolkit toolkit = jTextComponent.getToolkit();
                    Clipboard clipboard = toolkit.getSystemSelection();
                    if (clipboard != null) {
                        Transferable transferable;
                        this.adjustCaret(mouseEvent);
                        TransferHandler transferHandler = jTextComponent.getTransferHandler();
                        if (transferHandler != null && (transferable = clipboard.getContents(null)) != null) {
                            transferHandler.importData(jTextComponent, transferable);
                        }
                        this.adjustFocus(true);
                    } else {
                        rTextArea.paste();
                    }
                }
                catch (HeadlessException headlessException) {}
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        JTextComponent jTextComponent;
        super.mousePressed(mouseEvent);
        if (!mouseEvent.isConsumed() && SwingUtilities.isRightMouseButton(mouseEvent) && (jTextComponent = this.getComponent()) != null && jTextComponent.isEnabled() && jTextComponent.isRequestFocusEnabled()) {
            jTextComponent.requestFocusInWindow();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isVisible() || this.alwaysVisible) {
            try {
                Serializable serializable;
                RTextArea rTextArea = this.getTextArea();
                graphics.setColor(rTextArea.getCaretColor());
                TextUI textUI = rTextArea.getUI();
                Rectangle rectangle = textUI.modelToView(rTextArea, this.getDot());
                this.validateWidth(rectangle);
                if (this.width > 0 && this.height > 0 && !this.contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                    serializable = graphics.getClipBounds();
                    if (serializable != null && !((Rectangle)serializable).contains(this)) {
                        this.repaint();
                    }
                    this.damage(rectangle);
                }
                rectangle.height -= 2;
                switch (this.style) {
                    case BLOCK_STYLE: {
                        serializable = rTextArea.getBackground();
                        if (serializable == null) {
                            serializable = Color.white;
                        }
                        graphics.setXORMode((Color)serializable);
                        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        break;
                    }
                    case BLOCK_BORDER_STYLE: {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                        break;
                    }
                    case UNDERLINE_STYLE: {
                        serializable = rTextArea.getBackground();
                        if (serializable == null) {
                            serializable = Color.white;
                        }
                        graphics.setXORMode((Color)serializable);
                        int n = rectangle.y + rectangle.height;
                        graphics.drawLine(rectangle.x, n, rectangle.x + rectangle.width - 1, n);
                        break;
                    }
                    default: {
                        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
                        break;
                    }
                    case THICK_VERTICAL_LINE_STYLE: {
                        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
                        ++rectangle.x;
                        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
                        break;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    private void selectWord(MouseEvent mouseEvent) {
        if (this.selectedWordEvent != null && this.selectedWordEvent.getX() == mouseEvent.getX() && this.selectedWordEvent.getY() == mouseEvent.getY()) {
            return;
        }
        Action action = null;
        RTextArea rTextArea = this.getTextArea();
        ActionMap actionMap = rTextArea.getActionMap();
        if (actionMap != null) {
            action = actionMap.get("select-word");
        }
        if (action == null) {
            if (selectWord == null) {
                selectWord = new RTextAreaEditorKit.SelectWordAction();
            }
            action = selectWord;
        }
        action.actionPerformed(new ActionEvent(rTextArea, 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
        this.selectedWordEvent = mouseEvent;
    }

    public void setAlwaysVisible(boolean bl) {
        if (bl != this.alwaysVisible) {
            this.alwaysVisible = bl;
            if (!this.isVisible()) {
                this.repaint();
            }
        }
    }

    public void setRoundedSelectionEdges(boolean bl) {
        ((ChangeableHighlightPainter)this.getSelectionPainter()).setRoundedEdges(bl);
    }

    @Override
    public void setSelectionVisible(boolean bl) {
        super.setSelectionVisible(true);
    }

    public void setStyle(CaretStyle caretStyle) {
        if (caretStyle == null) {
            caretStyle = CaretStyle.THICK_VERTICAL_LINE_STYLE;
        }
        if (caretStyle != this.style) {
            this.style = caretStyle;
            this.repaint();
        }
    }

    private void validateWidth(Rectangle rectangle) {
        if (rectangle != null && rectangle.width <= 1) {
            try {
                RTextArea rTextArea = this.getTextArea();
                rTextArea.getDocument().getText(this.getDot(), 1, this.seg);
                Font font = rTextArea.getFont();
                FontMetrics fontMetrics = rTextArea.getFontMetrics(font);
                rectangle.width = fontMetrics.charWidth(this.seg.array[this.seg.offset]);
                if (rectangle.width == 0) {
                    rectangle.width = fontMetrics.charWidth(' ');
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                rectangle.width = 8;
            }
        }
    }

    private class FoldAwareNavigationFilter
    extends NavigationFilter {
        private FoldAwareNavigationFilter() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
            block11: {
                RSyntaxTextArea rSyntaxTextArea;
                RTextArea rTextArea = ConfigurableCaret.this.getTextArea();
                if (rTextArea instanceof RSyntaxTextArea && (rSyntaxTextArea = (RSyntaxTextArea)ConfigurableCaret.this.getTextArea()).isCodeFoldingEnabled()) {
                    int n2 = ConfigurableCaret.this.getDot();
                    FoldManager foldManager = rSyntaxTextArea.getFoldManager();
                    int n3 = 0;
                    try {
                        n3 = rTextArea.getLineOfOffset(n);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (foldManager.isLineHidden(n3)) {
                        try {
                            if (n > n2) {
                                int n4 = rTextArea.getLineCount();
                                while (++n3 < n4 && foldManager.isLineHidden(n3)) {
                                }
                                if (n3 >= n4) {
                                    UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                                    return;
                                }
                                n = rTextArea.getLineStartOffset(n3);
                                break block11;
                            }
                            if (n >= n2) break block11;
                            while (--n3 >= 0 && foldManager.isLineHidden(n3)) {
                            }
                            if (n3 >= 0) {
                                n = rTextArea.getLineEndOffset(n3) - 1;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return;
                        }
                    }
                }
            }
            super.setDot(filterBypass, n, bias);
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
            super.moveDot(filterBypass, n, bias);
        }
    }
}

