/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

public class ChangeableHighlightPainter
extends LayeredHighlighter.LayerPainter
implements Serializable {
    private Paint paint;
    private boolean roundedEdges;
    private transient AlphaComposite alphaComposite;
    private float alpha;
    private static final int ARCWIDTH = 8;
    private static final int ARCHEIGHT = 8;

    public ChangeableHighlightPainter() {
        this(null);
    }

    public ChangeableHighlightPainter(Paint paint) {
        this(paint, false);
    }

    public ChangeableHighlightPainter(Paint paint, boolean bl) {
        this(paint, bl, 1.0f);
    }

    public ChangeableHighlightPainter(Paint paint, boolean bl, float f) {
        this.setPaint(paint);
        this.setRoundedEdges(bl);
        this.setAlpha(f);
    }

    public float getAlpha() {
        return this.alpha;
    }

    private AlphaComposite getAlphaComposite() {
        if (this.alphaComposite == null) {
            this.alphaComposite = AlphaComposite.getInstance(3, this.alpha);
        }
        return this.alphaComposite;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public boolean getRoundedEdges() {
        return this.roundedEdges;
    }

    @Override
    public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
        block12: {
            Rectangle rectangle = shape.getBounds();
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = null;
            if (this.getAlpha() < 1.0f) {
                composite = graphics2D.getComposite();
                graphics2D.setComposite(this.getAlphaComposite());
            }
            try {
                try {
                    TextUI textUI = jTextComponent.getUI();
                    Rectangle rectangle2 = textUI.modelToView(jTextComponent, n);
                    Rectangle rectangle3 = textUI.modelToView(jTextComponent, n2);
                    Paint paint = this.getPaint();
                    if (paint == null) {
                        graphics2D.setColor(jTextComponent.getSelectionColor());
                    } else {
                        graphics2D.setPaint(paint);
                    }
                    if (rectangle2.y == rectangle3.y) {
                        rectangle3.width = 0;
                        Rectangle rectangle4 = rectangle2.union(rectangle3);
                        graphics2D.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                        break block12;
                    }
                    int n3 = rectangle.x + rectangle.width - rectangle2.x;
                    graphics2D.fillRect(rectangle2.x, rectangle2.y, n3, rectangle2.height);
                    if (rectangle2.y + rectangle2.height != rectangle3.y) {
                        graphics2D.fillRect(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle3.y - (rectangle2.y + rectangle2.height));
                    }
                    graphics2D.fillRect(rectangle.x, rectangle3.y, rectangle3.x - rectangle.x, rectangle3.height);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    if (this.getAlpha() < 1.0f) {
                        graphics2D.setComposite(composite);
                    }
                }
            }
            finally {
                if (this.getAlpha() < 1.0f) {
                    graphics2D.setComposite(composite);
                }
            }
        }
    }

    @Override
    public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
        Paint paint;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = null;
        if (this.getAlpha() < 1.0f) {
            composite = graphics2D.getComposite();
            graphics2D.setComposite(this.getAlphaComposite());
        }
        if ((paint = this.getPaint()) == null) {
            graphics2D.setColor(jTextComponent.getSelectionColor());
        } else {
            graphics2D.setPaint(paint);
        }
        if (n == n2) {
            try {
                Shape shape2 = view.modelToView(n, shape, Position.Bias.Forward);
                Rectangle rectangle = shape2.getBounds();
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
                return rectangle;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return null;
            }
        }
        if (n == view.getStartOffset() && n2 == view.getEndOffset()) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.getAlpha() < 1.0f) {
                graphics2D.setComposite(composite);
            }
            return rectangle;
        }
        try {
            Rectangle rectangle;
            Shape shape3 = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
            Rectangle rectangle2 = rectangle = shape3 instanceof Rectangle ? (Rectangle)shape3 : shape3.getBounds();
            if (this.roundedEdges) {
                graphics2D.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 8, 8);
            } else {
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (this.getAlpha() < 1.0f) {
                graphics2D.setComposite(composite);
            }
            Rectangle rectangle3 = rectangle;
            return rectangle3;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        finally {
            if (this.getAlpha() < 1.0f) {
                graphics2D.setComposite(composite);
            }
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.paint = n == -1 ? null : new Color(n);
        this.alphaComposite = null;
    }

    public void setAlpha(float f) {
        this.alpha = f;
        this.alpha = Math.max(f, 0.0f);
        this.alpha = Math.min(1.0f, f);
        this.alphaComposite = null;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void setRoundedEdges(boolean bl) {
        this.roundedEdges = bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = -1;
        if (this.paint != null) {
            SystemColor systemColor = this.paint instanceof Color ? (Color)this.paint : SystemColor.textHighlight;
            n = systemColor.getRGB();
        }
        objectOutputStream.writeInt(n);
    }
}

