/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.templates;

import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.templates.AbstractCodeTemplate;

public class StaticCodeTemplate
extends AbstractCodeTemplate {
    private static final long serialVersionUID = 1L;
    private String beforeCaret;
    private String afterCaret;
    private transient int firstBeforeNewline;
    private transient int firstAfterNewline;
    private static final String EMPTY_STRING = "";

    public StaticCodeTemplate() {
    }

    public StaticCodeTemplate(String string, String string2, String string3) {
        super(string);
        this.setBeforeCaretText(string2);
        this.setAfterCaretText(string3);
    }

    public String getAfterCaretText() {
        return this.afterCaret;
    }

    public String getBeforeCaretText() {
        return this.beforeCaret;
    }

    private String getAfterTextIndented(String string) {
        return this.getTextIndented(this.getAfterCaretText(), this.firstAfterNewline, string);
    }

    private String getBeforeTextIndented(String string) {
        return this.getTextIndented(this.getBeforeCaretText(), this.firstBeforeNewline, string);
    }

    private String getTextIndented(String string, int n, String string2) {
        if (n == -1) {
            return string;
        }
        int n2 = 0;
        int n3 = n + 1;
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, n3));
        stringBuilder.append(string2);
        while ((n2 = string.indexOf(10, n3)) > -1) {
            stringBuilder.append(string.substring(n3, n2 + 1));
            stringBuilder.append(string2);
            n3 = n2 + 1;
        }
        if (n3 < string.length()) {
            stringBuilder.append(string.substring(n3));
        }
        return stringBuilder.toString();
    }

    @Override
    public void invoke(RSyntaxTextArea rSyntaxTextArea) throws BadLocationException {
        Caret caret = rSyntaxTextArea.getCaret();
        int n = caret.getDot();
        int n2 = caret.getMark();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n5 = element.getElementIndex(n);
        Element element2 = element.getElement(n5);
        int n6 = element2.getStartOffset();
        int n7 = element2.getEndOffset() - 1;
        String string = rSyntaxTextArea.getText(n6, n7 - n6);
        int n8 = string.length();
        int n9 = 0;
        while (n9 < n8 && RSyntaxUtilities.isWhitespace(string.charAt(n9))) {
            ++n9;
        }
        string = string.substring(0, n9);
        String string2 = this.getBeforeTextIndented(string);
        String string3 = this.getAfterTextIndented(string);
        rSyntaxDocument.replace(n3 -= this.getID().length(), n4 - n3, String.valueOf(string2) + string3, null);
        rSyntaxTextArea.setCaretPosition(n3 + string2.length());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.setBeforeCaretText(this.beforeCaret);
        this.setAfterCaretText(this.afterCaret);
    }

    public void setAfterCaretText(String string) {
        this.afterCaret = string == null ? EMPTY_STRING : string;
        this.firstAfterNewline = this.afterCaret.indexOf(10);
    }

    public void setBeforeCaretText(String string) {
        this.beforeCaret = string == null ? EMPTY_STRING : string;
        this.firstBeforeNewline = this.beforeCaret.indexOf(10);
    }

    public String toString() {
        return "[StaticCodeTemplate: id=" + this.getID() + ", text=" + this.getBeforeCaretText() + "|" + this.getAfterCaretText() + "]";
    }
}

