/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.parser;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;

public class TaskTagParser
extends AbstractParser {
    private DefaultParseResult result = new DefaultParseResult(this);
    private String DEFAULT_TASK_PATTERN = "TODO|FIXME|HACK";
    private Pattern taskPattern;
    private static final Color COLOR = new Color(48, 150, 252);

    public TaskTagParser() {
        this.setTaskPattern(this.DEFAULT_TASK_PATTERN);
    }

    public String getTaskPattern() {
        return this.taskPattern == null ? null : this.taskPattern.pattern();
    }

    @Override
    public ParseResult parse(RSyntaxDocument rSyntaxDocument, String string) {
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n = element.getElementCount();
        if (this.taskPattern == null || string == null || "text/plain".equals(string)) {
            this.result.clearNotices();
            this.result.setParsedLines(0, n - 1);
            return this.result;
        }
        this.result.clearNotices();
        this.result.setParsedLines(0, n - 1);
        int n2 = 0;
        while (n2 < n) {
            Token token = rSyntaxDocument.getTokenListForLine(n2);
            int n3 = -1;
            int n4 = -1;
            String string2 = null;
            while (token != null && token.isPaintable()) {
                if (token.isComment()) {
                    n3 = token.getOffset();
                    string2 = token.getLexeme();
                    Matcher matcher = this.taskPattern.matcher(string2);
                    if (matcher.find()) {
                        n4 = matcher.start();
                        n3 += n4;
                        break;
                    }
                }
                token = token.getNextToken();
            }
            if (n4 > -1) {
                string2 = string2.substring(n4);
                int n5 = string2.length();
                TaskNotice taskNotice = new TaskNotice(this, string2, n2, n3, n5);
                taskNotice.setLevel(ParserNotice.Level.INFO);
                taskNotice.setShowInEditor(false);
                taskNotice.setColor(COLOR);
                this.result.addNotice(taskNotice);
            }
            ++n2;
        }
        return this.result;
    }

    public void setTaskPattern(String string) throws PatternSyntaxException {
        this.taskPattern = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    public static class TaskNotice
    extends DefaultParserNotice {
        public TaskNotice(Parser parser, String string, int n, int n2, int n3) {
            super(parser, string, n, n2, n3);
        }
    }
}

