/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class XmlFoldParser
implements FoldParser {
    private static final char[] MARKUP_CLOSING_TAG_START = new char[]{'<', '/'};
    private static final char[] MARKUP_SHORT_TAG_END = new char[]{'/', '>'};
    private static final char[] MLC_END = new char[]{'-', '-', '>'};

    @Override
    public List<Fold> getFolds(RSyntaxTextArea rSyntaxTextArea) {
        ArrayList<Fold> arrayList = new ArrayList<Fold>();
        Fold fold = null;
        int n = rSyntaxTextArea.getLineCount();
        boolean bl = false;
        int n2 = 0;
        try {
            int n3 = 0;
            while (n3 < n) {
                Token token = rSyntaxTextArea.getTokenListForLine(n3);
                while (token != null && token.isPaintable()) {
                    if (token.isComment()) {
                        if (bl) {
                            if (token.endsWith(MLC_END)) {
                                int n4 = token.getEndOffset() - 1;
                                if (fold == null) {
                                    fold = new Fold(1, rSyntaxTextArea, n2);
                                    fold.setEndOffset(n4);
                                    arrayList.add(fold);
                                    fold = null;
                                } else {
                                    fold = fold.createChild(1, n2);
                                    fold.setEndOffset(n4);
                                    fold = fold.getParent();
                                }
                                bl = false;
                                n2 = 0;
                            }
                        } else if (token.getType() == 2 && !token.endsWith(MLC_END)) {
                            bl = true;
                            n2 = token.getOffset();
                        }
                    } else if (token.isSingleChar(25, '<')) {
                        if (fold == null) {
                            fold = new Fold(0, rSyntaxTextArea, token.getOffset());
                            arrayList.add(fold);
                        } else {
                            fold = fold.createChild(0, token.getOffset());
                        }
                    } else if (token.is(25, MARKUP_SHORT_TAG_END)) {
                        if (fold != null) {
                            Fold fold2 = fold.getParent();
                            XmlFoldParser.removeFold(fold, arrayList);
                            fold = fold2;
                        }
                    } else if (token.is(25, MARKUP_CLOSING_TAG_START) && fold != null) {
                        fold.setEndOffset(token.getOffset());
                        Fold fold3 = fold.getParent();
                        if (fold.isOnSingleLine()) {
                            XmlFoldParser.removeFold(fold, arrayList);
                        }
                        fold = fold3;
                    }
                    token = token.getNextToken();
                }
                ++n3;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return arrayList;
    }

    private static final void removeFold(Fold fold, List<Fold> list) {
        if (!fold.removeFromParent()) {
            list.remove(list.size() - 1);
        }
    }
}

