/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class LatexFoldParser
implements FoldParser {
    private static final char[] BEGIN = "\\begin".toCharArray();
    private static final char[] END = "\\end".toCharArray();

    @Override
    public List<Fold> getFolds(RSyntaxTextArea rSyntaxTextArea) {
        ArrayList<Fold> arrayList = new ArrayList<Fold>();
        Stack<String> stack = new Stack<String>();
        Fold fold = null;
        int n = rSyntaxTextArea.getLineCount();
        try {
            int n2 = 0;
            while (n2 < n) {
                Token token = rSyntaxTextArea.getTokenListForLine(n2);
                while (token != null && token.isPaintable()) {
                    Token token2;
                    if (token.is(6, BEGIN)) {
                        token2 = token.getNextToken();
                        if (token2 != null && token2.isLeftCurly() && (token2 = token2.getNextToken()) != null && token2.getType() == 6) {
                            if (fold == null) {
                                fold = new Fold(0, rSyntaxTextArea, token.getOffset());
                                arrayList.add(fold);
                            } else {
                                fold = fold.createChild(0, token.getOffset());
                            }
                            stack.push(token2.getLexeme());
                            token = token2;
                        }
                    } else if (token.is(6, END) && fold != null && !stack.isEmpty() && (token2 = token.getNextToken()) != null && token2.isLeftCurly() && (token2 = token2.getNextToken()) != null && token2.getType() == 6) {
                        String string = token2.getLexeme();
                        if (((String)stack.peek()).equals(string)) {
                            stack.pop();
                            fold.setEndOffset(token.getOffset());
                            Fold fold2 = fold.getParent();
                            if (fold.isOnSingleLine() && !fold.removeFromParent()) {
                                arrayList.remove(arrayList.size() - 1);
                            }
                            token = token2;
                            fold = fold2;
                        }
                    }
                    token = token.getNextToken();
                }
                ++n2;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return arrayList;
    }
}

