/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;

public class FoldCollapser {
    private List<Integer> typesToCollapse = new ArrayList<Integer>(3);

    public FoldCollapser() {
        this(1);
    }

    public FoldCollapser(int n) {
        this.addTypeToCollapse(n);
    }

    public void addTypeToCollapse(int n) {
        this.typesToCollapse.add(n);
    }

    public void collapseFolds(FoldManager foldManager) {
        int n = 0;
        while (n < foldManager.getFoldCount()) {
            Fold fold = foldManager.getFold(n);
            this.collapseImpl(fold);
            ++n;
        }
    }

    protected void collapseImpl(Fold fold) {
        if (this.getShouldCollapse(fold)) {
            fold.setCollapsed(true);
        }
        int n = 0;
        while (n < fold.getChildCount()) {
            this.collapseImpl(fold.getChild(n));
            ++n;
        }
    }

    public boolean getShouldCollapse(Fold fold) {
        int n = fold.getFoldType();
        for (Integer n2 : this.typesToCollapse) {
            if (n != n2) continue;
            return true;
        }
        return false;
    }
}

