/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.fife.ui.rsyntaxtextarea.RSTAView;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.TokenPainter;
import org.fife.ui.rsyntaxtextarea.TokenUtils;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.Gutter;

public class WrappedSyntaxView
extends BoxView
implements TabExpander,
RSTAView {
    boolean widthChanging;
    int tabBase;
    int tabSize;
    private Segment s;
    private Segment drawSeg;
    private Rectangle tempRect;
    private RSyntaxTextArea host;
    private FontMetrics metrics;
    private TokenImpl tempToken = new TokenImpl();
    private TokenImpl lineCountTempToken;
    private static final int MIN_WIDTH = 20;

    public WrappedSyntaxView(Element element) {
        super(element, 1);
        this.s = new Segment();
        this.drawSeg = new Segment();
        this.tempRect = new Rectangle();
        this.lineCountTempToken = new TokenImpl();
    }

    protected int calculateBreakPosition(int n, Token token, float f) {
        int n2 = n;
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.getContainer();
        float f2 = this.getWidth();
        if (f2 == 2.1474836E9f) {
            f2 = this.getPreferredSpan(0);
        }
        f2 = Math.max(f2, 20.0f);
        Token token2 = token;
        while (token2 != null && token2.isPaintable()) {
            float f3 = token2.getWidth(rSyntaxTextArea, this, f);
            if (f3 > f2) {
                if (n2 == n) {
                    return token2.getOffsetBeforeX(rSyntaxTextArea, this, 0.0f, f2);
                }
                return token2.isWhitespace() ? n2 + token2.length() : n2;
            }
            f2 -= f3;
            f += f3;
            n2 += token2.length();
            token2 = token2.getNextToken();
        }
        return n2 + 1;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
    }

    private void childAllocation2(int n, int n2, Rectangle rectangle) {
        rectangle.x += this.getOffset(0, n);
        rectangle.y += n2;
        rectangle.width = this.getSpan(0, n);
        rectangle.height = this.getSpan(1, n);
        Insets insets = this.host.getMargin();
        if (insets != null) {
            rectangle.y -= insets.top;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void drawView(TokenPainter var1_1, Graphics2D var2_2, Rectangle var3_3, View var4_4, int var5_5, int var6_6) {
        var7_7 = var3_3.x;
        var8_8 = (LayeredHighlighter)this.host.getHighlighter();
        var9_9 = (RSyntaxDocument)this.getDocument();
        var10_10 = this.getElement();
        var11_11 = var4_4.getStartOffset();
        var12_12 = var10_10.getElementIndex(var11_11);
        var13_13 = var4_4.getEndOffset();
        this.setSegment(var11_11, var13_13 - 1, var9_9, this.drawSeg);
        var14_14 = var11_11 - this.drawSeg.offset;
        var15_15 = var9_9.getTokenListForLine(var12_12);
        if (var15_15 == null || var15_15.getType() != 0) ** GOTO lbl32
        var8_8.paintLayeredHighlights(var2_2, var11_11, var13_13, var3_3, this.host, this);
        return;
lbl-1000:
        // 1 sources

        {
            var16_16 = this.calculateBreakPosition(var11_11, var15_15, var7_7);
            var7_7 = var3_3.x;
            var8_8.paintLayeredHighlights(var2_2, var11_11, var16_16, var3_3, this.host, this);
            while (var15_15 != null && var15_15.isPaintable() && var15_15.getEndOffset() - 1 < var16_16) {
                var7_7 = var1_1.paint(var15_15, var2_2, var7_7, var6_6, this.host, this);
                var15_15 = var15_15.getNextToken();
            }
            if (var15_15 != null && var15_15.isPaintable() && var15_15.getOffset() < var16_16) {
                var17_17 = var15_15.getOffset();
                this.tempToken.set(this.drawSeg.array, var17_17 - var14_14, var16_16 - 1 - var14_14, var17_17, var15_15.getType());
                this.tempToken.setLanguageIndex(var15_15.getLanguageIndex());
                var1_1.paint(this.tempToken, var2_2, var7_7, var6_6, this.host, this);
                this.tempToken.copyFrom(var15_15);
                this.tempToken.makeStartAt(var16_16);
                var15_15 = new TokenImpl(this.tempToken);
            }
            var11_11 = var16_16 == var11_11 ? var13_13 : var16_16;
            var6_6 += var5_5;
lbl32:
            // 2 sources

            ** while (var15_15 != null && var15_15.isPaintable())
        }
lbl33:
        // 1 sources

        if (this.host.getEOLMarkersVisible()) {
            var2_2.setColor(this.host.getForegroundForTokenType(21));
            var2_2.setFont(this.host.getFontForTokenType(21));
            var2_2.drawString("\u00b6", var7_7, (float)(var6_6 - var5_5));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void drawViewWithSelection(TokenPainter var1_1, Graphics2D var2_2, Rectangle var3_3, View var4_4, int var5_5, int var6_6, int var7_7, int var8_8) {
        var9_9 = var3_3.x;
        var10_10 = this.host.getUseSelectedTextColor();
        var11_11 = (LayeredHighlighter)this.host.getHighlighter();
        var12_12 = (RSyntaxDocument)this.getDocument();
        var13_13 = this.getElement();
        var14_14 = var4_4.getStartOffset();
        var15_15 = var13_13.getElementIndex(var14_14);
        var16_16 = var4_4.getEndOffset();
        this.setSegment(var14_14, var16_16 - 1, var12_12, this.drawSeg);
        var17_17 = var14_14 - this.drawSeg.offset;
        var18_18 = var12_12.getTokenListForLine(var15_15);
        if (var18_18 == null || var18_18.getType() != 0) ** GOTO lbl88
        var11_11.paintLayeredHighlights(var2_2, var14_14, var16_16, var3_3, this.host, this);
        return;
lbl-1000:
        // 1 sources

        {
            var19_19 = this.calculateBreakPosition(var14_14, var18_18, var9_9);
            var9_9 = var3_3.x;
            var11_11.paintLayeredHighlights(var2_2, var14_14, var19_19, var3_3, this.host, this);
            while (var18_18 != null && var18_18.isPaintable() && var18_18.getEndOffset() - 1 < var19_19) {
                if (var18_18.containsPosition(var7_7)) {
                    if (var7_7 > var18_18.getOffset()) {
                        this.tempToken.copyFrom(var18_18);
                        this.tempToken.textCount = var7_7 - this.tempToken.getOffset();
                        var9_9 = var1_1.paint(this.tempToken, var2_2, var9_9, var6_6, this.host, this);
                        this.tempToken.textCount = var18_18.length();
                        this.tempToken.makeStartAt(var7_7);
                        var18_18 = new TokenImpl(this.tempToken);
                    }
                    if ((var20_20 = Math.min(var18_18.length(), var8_8 - var18_18.getOffset())) == var18_18.length()) {
                        var9_9 = var1_1.paintSelected(var18_18, var2_2, var9_9, var6_6, this.host, this, var10_10);
                    } else {
                        this.tempToken.copyFrom(var18_18);
                        this.tempToken.textCount = var20_20;
                        var9_9 = var1_1.paintSelected(this.tempToken, var2_2, var9_9, var6_6, this.host, this, var10_10);
                        this.tempToken.textCount = var18_18.length();
                        this.tempToken.makeStartAt(var18_18.getOffset() + var20_20);
                        var18_18 = this.tempToken;
                        var9_9 = var1_1.paint(var18_18, var2_2, var9_9, var6_6, this.host, this);
                    }
                } else if (var18_18.containsPosition(var8_8)) {
                    this.tempToken.copyFrom(var18_18);
                    this.tempToken.textCount = var8_8 - this.tempToken.getOffset();
                    var9_9 = var1_1.paintSelected(this.tempToken, var2_2, var9_9, var6_6, this.host, this, var10_10);
                    this.tempToken.textCount = var18_18.length();
                    this.tempToken.makeStartAt(var8_8);
                    var18_18 = this.tempToken;
                    var9_9 = var1_1.paint(var18_18, var2_2, var9_9, var6_6, this.host, this);
                } else {
                    var9_9 = var18_18.getOffset() >= var7_7 && var18_18.getEndOffset() <= var8_8 ? var1_1.paintSelected(var18_18, var2_2, var9_9, var6_6, this.host, this, var10_10) : var1_1.paint(var18_18, var2_2, var9_9, var6_6, this.host, this);
                }
                var18_18 = var18_18.getNextToken();
            }
            if (var18_18 != null && var18_18.isPaintable() && var18_18.getOffset() < var19_19) {
                var20_20 = var18_18.getOffset();
                var21_21 = var18_18;
                var18_18 = new TokenImpl(this.drawSeg, var20_20 - var17_17, var19_19 - 1 - var17_17, var20_20, var18_18.getType(), var18_18.getLanguageIndex());
                var18_18.setLanguageIndex(var18_18.getLanguageIndex());
                if (var18_18.containsPosition(var7_7)) {
                    if (var7_7 > var18_18.getOffset()) {
                        this.tempToken.copyFrom(var18_18);
                        this.tempToken.textCount = var7_7 - this.tempToken.getOffset();
                        var9_9 = var1_1.paint(this.tempToken, var2_2, var9_9, var6_6, this.host, this);
                        this.tempToken.textCount = var18_18.length();
                        this.tempToken.makeStartAt(var7_7);
                        var18_18 = new TokenImpl(this.tempToken);
                    }
                    if ((var22_22 = Math.min(var18_18.length(), var8_8 - var18_18.getOffset())) == var18_18.length()) {
                        var9_9 = var1_1.paintSelected(var18_18, var2_2, var9_9, var6_6, this.host, this, var10_10);
                    } else {
                        this.tempToken.copyFrom(var18_18);
                        this.tempToken.textCount = var22_22;
                        var9_9 = var1_1.paintSelected(this.tempToken, var2_2, var9_9, var6_6, this.host, this, var10_10);
                        this.tempToken.textCount = var18_18.length();
                        this.tempToken.makeStartAt(var18_18.getOffset() + var22_22);
                        var18_18 = this.tempToken;
                        var9_9 = var1_1.paint(var18_18, var2_2, var9_9, var6_6, this.host, this);
                    }
                } else if (var18_18.containsPosition(var8_8)) {
                    this.tempToken.copyFrom(var18_18);
                    this.tempToken.textCount = var8_8 - this.tempToken.getOffset();
                    var9_9 = var1_1.paintSelected(this.tempToken, var2_2, var9_9, var6_6, this.host, this, var10_10);
                    this.tempToken.textCount = var18_18.length();
                    this.tempToken.makeStartAt(var8_8);
                    var18_18 = this.tempToken;
                    var9_9 = var1_1.paint(var18_18, var2_2, var9_9, var6_6, this.host, this);
                } else {
                    var9_9 = var18_18.getOffset() >= var7_7 && var18_18.getEndOffset() <= var8_8 ? var1_1.paintSelected(var18_18, var2_2, var9_9, var6_6, this.host, this, var10_10) : var1_1.paint(var18_18, var2_2, var9_9, var6_6, this.host, this);
                }
                var18_18 = new TokenImpl(var21_21);
                ((TokenImpl)var18_18).makeStartAt(var19_19);
            }
            var14_14 = var19_19 == var14_14 ? var16_16 : var19_19;
            var6_6 += var5_5;
lbl88:
            // 2 sources

            ** while (var18_18 != null && var18_18.isPaintable())
        }
lbl89:
        // 1 sources

        if (this.host.getEOLMarkersVisible()) {
            var2_2.setColor(this.host.getForegroundForTokenType(21));
            var2_2.setFont(this.host.getFontForTokenType(21));
            var2_2.drawString("\u00b6", var9_9, (float)(var6_6 - var5_5));
        }
    }

    @Override
    public Shape getChildAllocation(int n, Shape shape) {
        if (shape != null) {
            Shape shape2 = this.getChildAllocationImpl(n, shape);
            if (shape2 != null && !this.isAllocationValid()) {
                Rectangle rectangle;
                Rectangle rectangle2 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
                if (rectangle.width == 0 && rectangle.height == 0) {
                    return null;
                }
            }
            return shape2;
        }
        return null;
    }

    public Shape getChildAllocationImpl(int n, Shape shape) {
        Rectangle rectangle = this.getInsideAllocation(shape);
        this.host = (RSyntaxTextArea)this.getContainer();
        FoldManager foldManager = this.host.getFoldManager();
        int n2 = rectangle.y;
        int n3 = 0;
        while (n3 < n) {
            n2 += this.getSpan(1, n3);
            Fold fold = foldManager.getFoldForLine(n3);
            if (fold != null && fold.isCollapsed()) {
                n3 += fold.getCollapsedLineCount();
            }
            ++n3;
        }
        this.childAllocation2(n, n2, rectangle);
        return rectangle;
    }

    @Override
    public float getMaximumSpan(int n) {
        this.updateMetrics();
        float f = super.getPreferredSpan(n);
        if (n == 0) {
            f += (float)this.metrics.charWidth('\u00b6');
        }
        return f;
    }

    @Override
    public float getMinimumSpan(int n) {
        this.updateMetrics();
        float f = super.getPreferredSpan(n);
        if (n == 0) {
            f += (float)this.metrics.charWidth('\u00b6');
        }
        return f;
    }

    @Override
    public float getPreferredSpan(int n) {
        this.updateMetrics();
        float f = 0.0f;
        if (n == 0) {
            f = super.getPreferredSpan(n);
            f += (float)this.metrics.charWidth('\u00b6');
        } else {
            f = super.getPreferredSpan(n);
            this.host = (RSyntaxTextArea)this.getContainer();
            if (this.host.isCodeFoldingEnabled()) {
                int n2 = this.host.getLineCount();
                FoldManager foldManager = this.host.getFoldManager();
                int n3 = 0;
                while (n3 < n2) {
                    if (foldManager.isLineHidden(n3)) {
                        f -= (float)this.getSpan(1, n3);
                    }
                    ++n3;
                }
            }
        }
        return f;
    }

    protected int getTabSize() {
        Integer n = (Integer)this.getDocument().getProperty("tabSize");
        int n2 = n != null ? n : 5;
        return n2;
    }

    @Override
    protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
        int n3 = this.getViewCount();
        int n4 = rectangle.y + this.getOffset(1, 0);
        this.host = (RSyntaxTextArea)this.getContainer();
        FoldManager foldManager = this.host.getFoldManager();
        int n5 = 1;
        while (n5 < n3) {
            int n6 = this.getSpan(1, n5 - 1);
            if (n2 < n4 + n6) {
                this.childAllocation2(n5 - 1, n4, rectangle);
                return this.getView(n5 - 1);
            }
            n4 += n6;
            Fold fold = foldManager.getFoldForLine(n5 - 1);
            if (fold != null && fold.isCollapsed()) {
                n5 += fold.getCollapsedLineCount();
            }
            ++n5;
        }
        this.childAllocation2(n3 - 1, n4, rectangle);
        return this.getView(n3 - 1);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n = documentEvent.getOffset();
        View view = this.getViewAtPosition(n, rectangle);
        if (view != null) {
            view.insertUpdate(documentEvent, rectangle, viewFactory);
        }
    }

    @Override
    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        if (n > 0) {
            View[] viewArray = new View[n];
            int n2 = 0;
            while (n2 < n) {
                viewArray[n2] = new WrappedLine(element.getElement(n2));
                ++n2;
            }
            this.replace(0, 0, viewArray);
        }
    }

    @Override
    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        View view;
        int n2;
        if (!this.isAllocationValid()) {
            Rectangle rectangle = shape.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
        boolean bl = bias == Position.Bias.Backward;
        int n3 = n2 = bl ? Math.max(0, n - 1) : n;
        if (bl && n2 < this.getStartOffset()) {
            return null;
        }
        int n4 = this.getViewIndexAtPosition(n2);
        if (n4 != -1 && n4 < this.getViewCount() && (view = this.getView(n4)) != null && n2 >= view.getStartOffset() && n2 < view.getEndOffset()) {
            Shape shape2 = this.getChildAllocation(n4, shape);
            if (shape2 == null) {
                return null;
            }
            Shape shape3 = view.modelToView(n, shape2, bias);
            if (shape3 == null && view.getEndOffset() == n && ++n4 < this.getViewCount()) {
                view = this.getView(n4);
                shape3 = view.modelToView(n, this.getChildAllocation(n4, shape), bias);
            }
            return shape3;
        }
        throw new BadLocationException("Position not represented by view", n);
    }

    @Override
    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        Rectangle rectangle;
        Rectangle rectangle2;
        Shape shape2;
        Shape shape3 = this.modelToView(n, shape, bias);
        if (n2 == this.getEndOffset()) {
            try {
                shape2 = this.modelToView(n2, shape, bias2);
            }
            catch (BadLocationException badLocationException) {
                shape2 = null;
            }
            if (shape2 == null) {
                rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                shape2 = new Rectangle(rectangle2.x + rectangle2.width - 1, rectangle2.y, 1, rectangle2.height);
            }
        } else {
            shape2 = this.modelToView(n2, shape, bias2);
        }
        rectangle2 = shape3.getBounds();
        Rectangle rectangle3 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
        if (rectangle2.y != rectangle.y) {
            Rectangle rectangle4 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            rectangle2.x = rectangle4.x;
            rectangle2.width = rectangle4.width;
        }
        rectangle2.add(rectangle);
        if (n2 > n) {
            rectangle2.width -= rectangle.width;
        }
        return rectangle2;
    }

    @Override
    public float nextTabStop(float f, int n) {
        if (this.tabSize == 0) {
            return f;
        }
        int n2 = ((int)f - this.tabBase) / this.tabSize;
        return this.tabBase + (n2 + 1) * this.tabSize;
    }

    @Override
    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        this.tabBase = rectangle.x;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.host = (RSyntaxTextArea)this.getContainer();
        int n = this.host.getMaxAscent();
        int n2 = this.host.getLineHeight();
        FoldManager foldManager = this.host.getFoldManager();
        TokenPainter tokenPainter = this.host.getTokenPainter();
        Element element = this.getElement();
        int n3 = this.host.getSelectionStart();
        int n4 = this.host.getSelectionEnd();
        int n5 = this.getViewCount();
        int n6 = rectangle.x + this.getLeftInset();
        this.tempRect.y = rectangle.y + this.getTopInset();
        Rectangle rectangle2 = graphics.getClipBounds();
        int n7 = 0;
        while (n7 < n5) {
            Object object;
            this.tempRect.x = n6 + this.getOffset(0, n7);
            this.tempRect.width = this.getSpan(0, n7);
            this.tempRect.height = this.getSpan(1, n7);
            if (this.tempRect.intersects(rectangle2)) {
                object = element.getElement(n7);
                int n8 = object.getStartOffset();
                int n9 = object.getEndOffset() - 1;
                View view = this.getView(n7);
                if (n3 == n4 || n8 >= n4 || n9 < n3) {
                    this.drawView(tokenPainter, graphics2D, rectangle, view, n2, this.tempRect.y + n);
                } else {
                    this.drawViewWithSelection(tokenPainter, graphics2D, rectangle, view, n2, this.tempRect.y + n, n3, n4);
                }
            }
            this.tempRect.y += this.tempRect.height;
            object = foldManager.getFoldForLine(n7);
            if (object != null && ((Fold)object).isCollapsed()) {
                n7 += ((Fold)object).getCollapsedLineCount();
                Color color = RSyntaxUtilities.getFoldedLineBottomColor(this.host);
                if (color != null) {
                    graphics.setColor(color);
                    graphics.drawLine(n6, this.tempRect.y - 1, this.host.getWidth(), this.tempRect.y - 1);
                }
            }
            ++n7;
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n = documentEvent.getOffset();
        View view = this.getViewAtPosition(n, rectangle);
        if (view != null) {
            view.removeUpdate(documentEvent, rectangle, viewFactory);
        }
    }

    private void setSegment(int n, int n2, Document document, Segment segment) {
        try {
            document.getText(n, n2 - n, segment);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    @Override
    public void setSize(float f, float f2) {
        this.updateMetrics();
        if ((int)f != this.getWidth()) {
            this.preferenceChanged(null, true, true);
            this.widthChanging = true;
        }
        super.setSize(f, f2);
        this.widthChanging = false;
    }

    void updateChildren(DocumentEvent documentEvent, Shape shape) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (documentEvent.getType() == DocumentEvent.EventType.CHANGE) {
            this.getContainer().repaint();
        } else if (elementChange != null) {
            Element[] elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            View[] viewArray = new View[elementArray2.length];
            int n = 0;
            while (n < elementArray2.length) {
                viewArray[n] = new WrappedLine(elementArray2[n]);
                ++n;
            }
            this.replace(elementChange.getIndex(), elementArray.length, viewArray);
            if (shape != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        this.updateMetrics();
    }

    final void updateMetrics() {
        Container container = this.getContainer();
        Font font = container.getFont();
        this.metrics = container.getFontMetrics(font);
        this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
    }

    @Override
    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        View view;
        Rectangle rectangle;
        int n = -1;
        if (!this.isAllocationValid()) {
            rectangle = shape.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
        if ((view = this.getViewAtPoint((int)f, (int)f2, rectangle = this.getInsideAllocation(shape))) != null) {
            n = view.viewToModel(f, f2, rectangle, biasArray);
        }
        if (this.host.isCodeFoldingEnabled() && view == this.getView(this.getViewCount() - 1) && n == view.getEndOffset() - 1) {
            n = this.host.getLastVisibleOffset();
        }
        return n;
    }

    @Override
    public int yForLine(Rectangle rectangle, int n) throws BadLocationException {
        return this.yForLineContaining(rectangle, this.getElement().getElement(n).getStartOffset());
    }

    @Override
    public int yForLineContaining(Rectangle rectangle, int n) throws BadLocationException {
        Rectangle rectangle2;
        if (this.isAllocationValid() && (rectangle2 = (Rectangle)this.modelToView(n, rectangle, Position.Bias.Forward)) != null) {
            if (this.host.isCodeFoldingEnabled()) {
                int n2 = this.host.getLineOfOffset(n);
                FoldManager foldManager = this.host.getFoldManager();
                if (foldManager.isLineHidden(n2)) {
                    return -1;
                }
            }
            return rectangle2.y;
        }
        return -1;
    }

    class WrappedLine
    extends View {
        int nlines;

        WrappedLine(Element element) {
            super(element);
        }

        final int calculateLineCount() {
            int n = 0;
            int n2 = this.getStartOffset();
            int n3 = this.getEndOffset();
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.getContainer();
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
            Element element = rSyntaxDocument.getDefaultRootElement();
            int n4 = element.getElementIndex(n2);
            Token token = rSyntaxDocument.getTokenListForLine(n4);
            float f = 0.0f;
            int n5 = n2;
            while (n5 < n3) {
                ++n;
                TokenUtils.TokenSubList tokenSubList = TokenUtils.getSubTokenList(token, n5, WrappedSyntaxView.this, rSyntaxTextArea, f, WrappedSyntaxView.this.lineCountTempToken);
                f = tokenSubList != null ? tokenSubList.x : f;
                token = tokenSubList != null ? tokenSubList.tokenList : null;
                int n6 = WrappedSyntaxView.this.calculateBreakPosition(n5, token, f);
                int n7 = n5 = n6 == n5 ? ++n6 : n6;
            }
            return n;
        }

        @Override
        public float getPreferredSpan(int n) {
            switch (n) {
                case 0: {
                    float f = WrappedSyntaxView.this.getWidth();
                    if (f == 2.1474836E9f) {
                        return 100.0f;
                    }
                    return f;
                }
                case 1: {
                    if (this.nlines == 0 || WrappedSyntaxView.this.widthChanging) {
                        this.nlines = this.calculateLineCount();
                    }
                    int n2 = this.nlines * ((RSyntaxTextArea)this.getContainer()).getLineHeight();
                    return n2;
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + n);
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
        }

        @Override
        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            Rectangle rectangle = shape.getBounds();
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.getContainer();
            rectangle.height = rSyntaxTextArea.getLineHeight();
            rectangle.width = 1;
            int n2 = this.getStartOffset();
            int n3 = this.getEndOffset();
            int n4 = bias == Position.Bias.Forward ? n : Math.max(n2, n - 1);
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
            Element element = rSyntaxDocument.getDefaultRootElement();
            int n5 = element.getElementIndex(n2);
            Token token = rSyntaxDocument.getTokenListForLine(n5);
            float f = rectangle.x;
            while (n2 < n3) {
                TokenUtils.TokenSubList tokenSubList = TokenUtils.getSubTokenList(token, n2, WrappedSyntaxView.this, rSyntaxTextArea, f, WrappedSyntaxView.this.lineCountTempToken);
                f = tokenSubList != null ? tokenSubList.x : f;
                token = tokenSubList != null ? tokenSubList.tokenList : null;
                int n6 = WrappedSyntaxView.this.calculateBreakPosition(n2, token, f);
                if (n >= n2 && n4 < n6) {
                    rectangle = RSyntaxUtilities.getLineWidthUpTo(rSyntaxTextArea, WrappedSyntaxView.this.s, n2, n, WrappedSyntaxView.this, rectangle, rectangle.x);
                    return rectangle;
                }
                if (n6 == n3 - 1 && n == n3 - 1) {
                    if (n > n2) {
                        rectangle = RSyntaxUtilities.getLineWidthUpTo(rSyntaxTextArea, WrappedSyntaxView.this.s, n2, n, WrappedSyntaxView.this, rectangle, rectangle.x);
                    }
                    return rectangle;
                }
                n2 = n6 == n2 ? n3 : n6;
                rectangle.y += rectangle.height;
            }
            throw new BadLocationException(null, n);
        }

        @Override
        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            biasArray[0] = Position.Bias.Forward;
            Rectangle rectangle = (Rectangle)shape;
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
            int n = (int)f;
            int n2 = (int)f2;
            if (n2 < rectangle.y) {
                return this.getStartOffset();
            }
            if (n2 > rectangle.y + rectangle.height) {
                return this.getEndOffset() - 1;
            }
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.getContainer();
            rectangle.height = rSyntaxTextArea.getLineHeight();
            int n3 = this.getEndOffset();
            Element element = rSyntaxDocument.getDefaultRootElement();
            int n4 = this.getStartOffset();
            int n5 = element.getElementIndex(n4);
            Token token = rSyntaxDocument.getTokenListForLine(n5);
            while (n4 < n3) {
                TokenUtils.TokenSubList tokenSubList = TokenUtils.getSubTokenList(token, n4, WrappedSyntaxView.this, rSyntaxTextArea, rectangle.x, WrappedSyntaxView.this.lineCountTempToken);
                token = tokenSubList != null ? tokenSubList.tokenList : null;
                int n6 = WrappedSyntaxView.this.calculateBreakPosition(n4, token, rectangle.x);
                if (n2 >= rectangle.y && n2 < rectangle.y + rectangle.height) {
                    if (n < rectangle.x) {
                        return n4;
                    }
                    if (n > rectangle.x + rectangle.width) {
                        return n6 - 1;
                    }
                    int n7 = token.getListOffset(rSyntaxTextArea, WrappedSyntaxView.this, rectangle.x, n);
                    return Math.max(Math.min(n7, n3 - 1), n4);
                }
                n4 = n6 == n4 ? n3 : n6;
                rectangle.y += rectangle.height;
            }
            return this.getEndOffset() - 1;
        }

        private void handleDocumentEvent(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            int n = this.calculateLineCount();
            if (this.nlines != n) {
                this.nlines = n;
                WrappedSyntaxView.this.preferenceChanged(this, false, true);
                RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.getContainer();
                rSyntaxTextArea.repaint();
                Gutter gutter = RSyntaxUtilities.getGutter(rSyntaxTextArea);
                if (gutter != null) {
                    gutter.revalidate();
                    gutter.repaint();
                }
            } else if (shape != null) {
                Container container = this.getContainer();
                Rectangle rectangle = (Rectangle)shape;
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.handleDocumentEvent(documentEvent, shape, viewFactory);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.handleDocumentEvent(documentEvent, shape, viewFactory);
        }
    }
}

