/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Token;

public class TokenImpl
implements Token {
    public char[] text = null;
    public int textOffset = -1;
    public int textCount = -1;
    private int offset;
    private int type;
    private boolean hyperlink;
    private Token nextToken;
    private int languageIndex;

    public TokenImpl() {
        this.setType(0);
        this.setOffset(-1);
        this.hyperlink = false;
        this.nextToken = null;
    }

    public TokenImpl(Segment segment, int n, int n2, int n3, int n4, int n5) {
        this(segment.array, n, n2, n3, n4, n5);
    }

    public TokenImpl(char[] cArray, int n, int n2, int n3, int n4, int n5) {
        this();
        this.set(cArray, n, n2, n3, n4);
        this.setLanguageIndex(n5);
    }

    public TokenImpl(Token token) {
        this();
        this.copyFrom(token);
    }

    @Override
    public StringBuilder appendHTMLRepresentation(StringBuilder stringBuilder, RSyntaxTextArea rSyntaxTextArea, boolean bl) {
        return this.appendHTMLRepresentation(stringBuilder, rSyntaxTextArea, bl, false);
    }

    @Override
    public StringBuilder appendHTMLRepresentation(StringBuilder stringBuilder, RSyntaxTextArea rSyntaxTextArea, boolean bl, boolean bl2) {
        SyntaxScheme syntaxScheme = rSyntaxTextArea.getSyntaxScheme();
        Style style = syntaxScheme.getStyle(this.getType());
        Font font = rSyntaxTextArea.getFontForTokenType(this.getType());
        if (font.isBold()) {
            stringBuilder.append("<b>");
        }
        if (font.isItalic()) {
            stringBuilder.append("<em>");
        }
        if (style.underline || this.isHyperlink()) {
            stringBuilder.append("<u>");
        }
        if (!this.isWhitespace()) {
            stringBuilder.append("<font");
            if (bl) {
                stringBuilder.append(" face=\"").append(font.getFamily()).append("\"");
            }
            stringBuilder.append(" color=\"").append(TokenImpl.getHTMLFormatForColor(style.foreground)).append("\">");
        }
        this.appendHtmlLexeme(rSyntaxTextArea, stringBuilder, bl2);
        if (!this.isWhitespace()) {
            stringBuilder.append("</font>");
        }
        if (style.underline || this.isHyperlink()) {
            stringBuilder.append("</u>");
        }
        if (font.isItalic()) {
            stringBuilder.append("</em>");
        }
        if (font.isBold()) {
            stringBuilder.append("</b>");
        }
        return stringBuilder;
    }

    private final StringBuilder appendHtmlLexeme(RSyntaxTextArea rSyntaxTextArea, StringBuilder stringBuilder, boolean bl) {
        int n;
        boolean bl2 = false;
        int n2 = n = this.textOffset;
        String string = null;
        while (n < this.textOffset + this.textCount) {
            char c = this.text[n];
            switch (c) {
                case ' ': {
                    stringBuilder.append(this.text, n2, n - n2);
                    n2 = n + 1;
                    stringBuilder.append(bl2 ? "&nbsp;" : " ");
                    bl2 = true;
                    break;
                }
                case '\t': {
                    stringBuilder.append(this.text, n2, n - n2);
                    n2 = n + 1;
                    if (bl && string == null) {
                        string = "";
                        int n3 = 0;
                        while (n3 < rSyntaxTextArea.getTabSize()) {
                            string = String.valueOf(string) + "&nbsp;";
                            ++n3;
                        }
                    }
                    stringBuilder.append(bl ? string : "&#09;");
                    bl2 = false;
                    break;
                }
                case '<': {
                    stringBuilder.append(this.text, n2, n - n2);
                    n2 = n + 1;
                    stringBuilder.append("&lt;");
                    bl2 = false;
                    break;
                }
                case '>': {
                    stringBuilder.append(this.text, n2, n - n2);
                    n2 = n + 1;
                    stringBuilder.append("&gt;");
                    bl2 = false;
                    break;
                }
                default: {
                    bl2 = false;
                }
            }
            ++n;
        }
        if (n2 < this.textOffset + this.textCount) {
            stringBuilder.append(this.text, n2, this.textOffset + this.textCount - n2);
        }
        return stringBuilder;
    }

    @Override
    public char charAt(int n) {
        return this.text[this.textOffset + n];
    }

    @Override
    public boolean containsPosition(int n) {
        return n >= this.getOffset() && n < this.getOffset() + this.textCount;
    }

    public void copyFrom(Token token) {
        this.text = token.getTextArray();
        this.textOffset = token.getTextOffset();
        this.textCount = token.length();
        this.setOffset(token.getOffset());
        this.setType(token.getType());
        this.hyperlink = token.isHyperlink();
        this.languageIndex = token.getLanguageIndex();
        this.nextToken = token.getNextToken();
    }

    @Override
    public int documentToToken(int n) {
        return n + (this.textOffset - this.getOffset());
    }

    @Override
    public boolean endsWith(char[] cArray) {
        if (cArray == null || cArray.length > this.textCount) {
            return false;
        }
        int n = this.textOffset + this.textCount - cArray.length;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (this.text[n + n2] != cArray[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Token)) {
            return false;
        }
        Token token = (Token)object;
        return this.offset == token.getOffset() && this.type == token.getType() && this.languageIndex == token.getLanguageIndex() && this.hyperlink == token.isHyperlink() && (this.getLexeme() == null && token.getLexeme() == null || this.getLexeme() != null && this.getLexeme().equals(token.getLexeme()));
    }

    @Override
    public int getEndOffset() {
        return this.offset + this.textCount;
    }

    private static final String getHTMLFormatForColor(Color color) {
        String string;
        String string2;
        if (color == null) {
            return "black";
        }
        String string3 = Integer.toHexString(color.getRed());
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        if ((string2 = Integer.toHexString(color.getGreen())).length() == 1) {
            string2 = "0" + string2;
        }
        if ((string = Integer.toHexString(color.getBlue())).length() == 1) {
            string = "0" + string;
        }
        return "#" + string3 + string2 + string;
    }

    @Override
    public String getHTMLRepresentation(RSyntaxTextArea rSyntaxTextArea) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendHTMLRepresentation(stringBuilder, rSyntaxTextArea, true);
        return stringBuilder.toString();
    }

    @Override
    public int getLanguageIndex() {
        return this.languageIndex;
    }

    @Override
    public Token getLastNonCommentNonWhitespaceToken() {
        TokenImpl tokenImpl = null;
        Token token = this;
        while (token != null && token.isPaintable()) {
            switch (token.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 21: {
                    break;
                }
                default: {
                    tokenImpl = token;
                }
            }
            token = token.getNextToken();
        }
        return tokenImpl;
    }

    @Override
    public Token getLastPaintableToken() {
        Token token = this;
        while (token.isPaintable()) {
            Token token2 = token.getNextToken();
            if (token2 == null || !token2.isPaintable()) {
                return token;
            }
            token = token2;
        }
        return null;
    }

    @Override
    public String getLexeme() {
        return this.text == null ? null : new String(this.text, this.textOffset, this.textCount);
    }

    @Override
    public int getListOffset(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f, float f2) {
        if (f >= f2) {
            return this.getOffset();
        }
        float f3 = f;
        float f4 = f;
        float f5 = f;
        TokenImpl tokenImpl = this;
        int n = this.getOffset();
        FontMetrics fontMetrics = null;
        while (tokenImpl != null && tokenImpl.isPaintable()) {
            fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(tokenImpl.getType());
            char[] cArray = tokenImpl.text;
            int n2 = tokenImpl.textOffset;
            int n3 = n2 + tokenImpl.textCount;
            int n4 = n2;
            while (n4 < n3) {
                f3 = f4;
                if (cArray[n4] == '\t') {
                    f5 = f4 = tabExpander.nextTabStop(f4, 0);
                    n2 = n4 + 1;
                } else {
                    f4 = f5 + (float)fontMetrics.charsWidth(cArray, n2, n4 - n2 + 1);
                }
                if (f2 >= f3 && f2 < f4) {
                    if (f2 - f3 < f4 - f2) {
                        return n + n4 - tokenImpl.textOffset;
                    }
                    return n + n4 + 1 - tokenImpl.textOffset;
                }
                ++n4;
            }
            f5 = f4;
            n += tokenImpl.textCount;
            tokenImpl = (TokenImpl)tokenImpl.getNextToken();
        }
        return n;
    }

    @Override
    public Token getNextToken() {
        return this.nextToken;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getOffsetBeforeX(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f, float f2) {
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(this.getType());
        int n = this.textOffset;
        int n2 = n + this.textCount;
        float f3 = f;
        while (n < n2) {
            f3 = this.text[n] == '\t' ? tabExpander.nextTabStop(f3, 0) : (f3 += (float)fontMetrics.charWidth(this.text[n]));
            if (f3 > f2) {
                int n3 = Math.max(n - this.textOffset, 1);
                return this.getOffset() + n3;
            }
            ++n;
        }
        return this.getOffset() + this.textCount - 1;
    }

    @Override
    public char[] getTextArray() {
        return this.text;
    }

    @Override
    public int getTextOffset() {
        return this.textOffset;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public float getWidth(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f) {
        return this.getWidthUpTo(this.textCount, rSyntaxTextArea, tabExpander, f);
    }

    @Override
    public float getWidthUpTo(int n, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f) {
        float f2 = f;
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(this.getType());
        if (fontMetrics != null) {
            int n2;
            int n3 = this.textOffset;
            int n4 = this.textOffset + n;
            int n5 = n3;
            while (n5 < n4) {
                if (this.text[n5] == '\t') {
                    n2 = n5 - n3;
                    if (n2 > 0) {
                        f2 += (float)fontMetrics.charsWidth(this.text, n3, n2);
                    }
                    n3 = n5 + 1;
                    f2 = tabExpander.nextTabStop(f2, 0);
                }
                ++n5;
            }
            n2 = n4 - n3;
            f2 += (float)fontMetrics.charsWidth(this.text, n3, n2);
        }
        return f2 - f;
    }

    public int hashCode() {
        return this.offset + (this.getLexeme() == null ? 0 : this.getLexeme().hashCode());
    }

    @Override
    public boolean is(char[] cArray) {
        if (this.textCount == cArray.length) {
            int n = 0;
            while (n < this.textCount) {
                if (this.text[this.textOffset + n] != cArray[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean is(int n, char[] cArray) {
        if (this.getType() == n && this.textCount == cArray.length) {
            int n2 = 0;
            while (n2 < this.textCount) {
                if (this.text[this.textOffset + n2] != cArray[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean is(int n, String string) {
        return this.getType() == n && this.textCount == string.length() && string.equals(this.getLexeme());
    }

    @Override
    public boolean isComment() {
        return this.getType() >= 1 && this.getType() <= 5;
    }

    @Override
    public boolean isCommentOrWhitespace() {
        return this.isComment() || this.isWhitespace();
    }

    @Override
    public boolean isHyperlink() {
        return this.hyperlink;
    }

    @Override
    public boolean isIdentifier() {
        return this.getType() == 20;
    }

    @Override
    public boolean isLeftCurly() {
        return this.getType() == 22 && this.isSingleChar('{');
    }

    @Override
    public boolean isRightCurly() {
        return this.getType() == 22 && this.isSingleChar('}');
    }

    @Override
    public boolean isPaintable() {
        return this.getType() > 0;
    }

    @Override
    public boolean isSingleChar(char c) {
        return this.textCount == 1 && this.text[this.textOffset] == c;
    }

    @Override
    public boolean isSingleChar(int n, char c) {
        return this.getType() == n && this.isSingleChar(c);
    }

    @Override
    public boolean isWhitespace() {
        return this.getType() == 21;
    }

    @Override
    public int length() {
        return this.textCount;
    }

    @Override
    public Rectangle listOffsetToView(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, int n, int n2, Rectangle rectangle) {
        int n3 = n2;
        TokenImpl tokenImpl = this;
        FontMetrics fontMetrics = null;
        Segment segment = new Segment();
        while (tokenImpl != null && tokenImpl.isPaintable()) {
            fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(tokenImpl.getType());
            if (fontMetrics == null) {
                return rectangle;
            }
            char[] cArray = tokenImpl.text;
            int n4 = tokenImpl.textOffset;
            int n5 = n4 + tokenImpl.textCount;
            if (tokenImpl.containsPosition(n)) {
                segment.array = tokenImpl.text;
                segment.offset = tokenImpl.textOffset;
                segment.count = n - tokenImpl.getOffset();
                int n6 = Utilities.getTabbedTextWidth(segment, fontMetrics, n3, tabExpander, tokenImpl.getOffset());
                rectangle.x = n3 + n6;
                n5 = tokenImpl.documentToToken(n);
                rectangle.width = cArray[n5] == '\t' ? fontMetrics.charWidth(' ') : fontMetrics.charWidth(cArray[n5]);
                return rectangle;
            }
            segment.array = tokenImpl.text;
            segment.offset = tokenImpl.textOffset;
            segment.count = tokenImpl.textCount;
            n3 += Utilities.getTabbedTextWidth(segment, fontMetrics, n3, tabExpander, tokenImpl.getOffset());
            tokenImpl = (TokenImpl)tokenImpl.getNextToken();
        }
        rectangle.x = n3;
        rectangle.width = 1;
        return rectangle;
    }

    public void makeStartAt(int n) {
        if (n < this.getOffset() || n >= this.getOffset() + this.textCount) {
            throw new IllegalArgumentException("pos " + n + " is not in range " + this.getOffset() + "-" + (this.getOffset() + this.textCount - 1));
        }
        int n2 = n - this.getOffset();
        this.setOffset(n);
        this.textOffset += n2;
        this.textCount -= n2;
    }

    public void moveOffset(int n) {
        if (n < 0 || n > this.textCount) {
            throw new IllegalArgumentException("amt " + n + " is not in range 0-" + this.textCount);
        }
        this.setOffset(this.getOffset() + n);
        this.textOffset += n;
        this.textCount -= n;
    }

    public void set(char[] cArray, int n, int n2, int n3, int n4) {
        this.text = cArray;
        this.textOffset = n;
        this.textCount = n2 - n + 1;
        this.setType(n4);
        this.setOffset(n3);
        this.nextToken = null;
    }

    @Override
    public void setHyperlink(boolean bl) {
        this.hyperlink = bl;
    }

    @Override
    public void setLanguageIndex(int n) {
        this.languageIndex = n;
    }

    public void setNextToken(Token token) {
        this.nextToken = token;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    @Override
    public void setType(int n) {
        this.type = n;
    }

    @Override
    public boolean startsWith(char[] cArray) {
        if (cArray.length <= this.textCount) {
            int n = 0;
            while (n < cArray.length) {
                if (this.text[this.textOffset + n] != cArray[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    @Override
    public int tokenToDocument(int n) {
        return n + (this.getOffset() - this.textOffset);
    }

    public String toString() {
        return "[Token: " + (this.getType() == 0 ? "<null token>" : "text: '" + (this.text == null ? "<null>" : String.valueOf(this.getLexeme()) + "'; " + "offset: " + this.getOffset() + "; type: " + this.getType() + "; " + "isPaintable: " + this.isPaintable() + "; nextToken==null: " + (this.nextToken == null))) + "]";
    }
}

