/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import javax.swing.text.StyleContext;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenTypes;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SyntaxScheme
implements Cloneable,
TokenTypes {
    private Style[] styles = new Style[39];
    private static final String VERSION = "*ver1";

    public SyntaxScheme(boolean bl) {
        if (bl) {
            this.restoreDefaults(null);
        }
    }

    public SyntaxScheme(Font font) {
        this(font, true);
    }

    public SyntaxScheme(Font font, boolean bl) {
        this.restoreDefaults(font, bl);
    }

    void changeBaseFont(Font font, Font font2) {
        int n = 0;
        while (n < this.styles.length) {
            Style style = this.styles[n];
            if (style != null && style.font != null && style.font.getFamily().equals(font.getFamily()) && style.font.getSize() == font.getSize()) {
                int n2 = style.font.getStyle();
                StyleContext styleContext = StyleContext.getDefaultStyleContext();
                style.font = styleContext.getFont(font2.getFamily(), n2, font2.getSize());
            }
            ++n;
        }
    }

    public Object clone() {
        SyntaxScheme syntaxScheme = null;
        try {
            syntaxScheme = (SyntaxScheme)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
        syntaxScheme.styles = new Style[this.styles.length];
        int n = 0;
        while (n < this.styles.length) {
            Style style = this.styles[n];
            if (style != null) {
                syntaxScheme.styles[n] = (Style)style.clone();
            }
            ++n;
        }
        return syntaxScheme;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SyntaxScheme)) {
            return false;
        }
        Style[] styleArray = ((SyntaxScheme)object).styles;
        int n = this.styles.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.styles[n2] == null ? styleArray[n2] != null : !this.styles[n2].equals(styleArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static final String getHexString(Color color) {
        return "$" + Integer.toHexString((color.getRGB() & 0xFFFFFF) + 0x1000000).substring(1);
    }

    public Style getStyle(int n) {
        return this.styles[n];
    }

    public int getStyleCount() {
        return this.styles.length;
    }

    public Style[] getStyles() {
        return this.styles;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.styles.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.styles[n3] != null) {
                n ^= this.styles[n3].hashCode();
                break;
            }
            ++n3;
        }
        return n;
    }

    public static SyntaxScheme load(Font font, InputStream inputStream) throws IOException {
        if (font == null) {
            font = RSyntaxTextArea.getDefaultFont();
        }
        return SyntaxSchemeLoader.load(font, inputStream);
    }

    public static SyntaxScheme loadFromString(String string) {
        return SyntaxScheme.loadFromString(string, 39);
    }

    public static SyntaxScheme loadFromString(String string, int n) {
        SyntaxScheme syntaxScheme = new SyntaxScheme(true);
        try {
            if (string != null) {
                String[] stringArray = string.split(",", -1);
                if (stringArray.length == 0 || !VERSION.equals(stringArray[0])) {
                    return syntaxScheme;
                }
                int n2 = n * 7 + 1;
                if (stringArray.length != n2) {
                    throw new Exception("Not enough tokens in packed color scheme: expected " + n2 + ", found " + stringArray.length);
                }
                StyleContext styleContext = StyleContext.getDefaultStyleContext();
                int n3 = 0;
                while (n3 < n) {
                    int n4 = n3 * 7 + 1;
                    int n5 = Integer.parseInt(stringArray[n4]);
                    if (n5 != n3) {
                        throw new Exception("Expected " + n3 + ", found " + n5);
                    }
                    Color color = null;
                    String string2 = stringArray[n4 + 1];
                    if (!"-".equals(string2)) {
                        color = SyntaxScheme.stringToColor(string2);
                    }
                    Color color2 = null;
                    string2 = stringArray[n4 + 2];
                    if (!"-".equals(string2)) {
                        color2 = SyntaxScheme.stringToColor(string2);
                    }
                    if (!"t".equals(string2 = stringArray[n4 + 3]) && !"f".equals(string2)) {
                        throw new Exception("Expected 't' or 'f', found " + string2);
                    }
                    boolean bl = "t".equals(string2);
                    Font font = null;
                    String string3 = stringArray[n4 + 4];
                    if (!"-".equals(string3)) {
                        font = styleContext.getFont(string3, Integer.parseInt(stringArray[n4 + 5]), Integer.parseInt(stringArray[n4 + 6]));
                    }
                    syntaxScheme.styles[n3] = new Style(color, color2, font, bl);
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return syntaxScheme;
    }

    void refreshFontMetrics(Graphics2D graphics2D) {
        int n = 0;
        while (n < this.styles.length) {
            Style style = this.styles[n];
            if (style != null) {
                style.fontMetrics = style.font == null ? null : graphics2D.getFontMetrics(style.font);
            }
            ++n;
        }
    }

    public void restoreDefaults(Font font) {
        this.restoreDefaults(font, true);
    }

    public void restoreDefaults(Font font, boolean bl) {
        Color color = new Color(0, 128, 0);
        Color color2 = new Color(164, 0, 0);
        Color color3 = new Color(0, 96, 0);
        Color color4 = Color.BLUE;
        Color color5 = new Color(0, 128, 128);
        Color color6 = new Color(173, 128, 0);
        Color color7 = new Color(128, 128, 128);
        Color color8 = new Color(128, 64, 64);
        Color color9 = new Color(0, 128, 164);
        Color color10 = new Color(255, 153, 0);
        Color color11 = new Color(100, 0, 200);
        Color color12 = new Color(220, 0, 156);
        Color color13 = new Color(148, 148, 0);
        if (font == null) {
            font = RSyntaxTextArea.getDefaultFont();
        }
        Font font2 = font;
        Font font3 = font;
        if (bl) {
            Font font4;
            StyleContext styleContext = StyleContext.getDefaultStyleContext();
            Font font5 = styleContext.getFont(font.getFamily(), 1, font.getSize());
            font2 = font4 = styleContext.getFont(font.getFamily(), 2, font.getSize());
            font3 = font5;
        }
        this.styles[1] = new Style(color, null, font2);
        this.styles[2] = new Style(color, null, font2);
        this.styles[3] = new Style(color2, null, font2);
        this.styles[4] = new Style(new Color(255, 152, 0), null, font2);
        this.styles[5] = new Style(Color.gray, null, font2);
        this.styles[6] = new Style(color4, null, font3);
        this.styles[7] = new Style(color4, null, font3);
        this.styles[8] = new Style(color6);
        this.styles[9] = new Style(color11);
        this.styles[10] = new Style(color11);
        this.styles[11] = new Style(color11);
        this.styles[12] = new Style(color11);
        this.styles[13] = new Style(color12);
        this.styles[14] = new Style(color12);
        this.styles[15] = new Style(color12);
        this.styles[16] = new Style(color5, null, font3);
        this.styles[17] = new Style(color10);
        this.styles[18] = new Style(color9);
        this.styles[19] = new Style(Color.gray);
        this.styles[20] = new Style(null);
        this.styles[21] = new Style(Color.gray);
        this.styles[22] = new Style(Color.RED);
        this.styles[23] = new Style(color8);
        this.styles[24] = new Style(color7);
        this.styles[25] = new Style(Color.RED);
        this.styles[26] = new Style(Color.BLUE);
        this.styles[27] = new Style(new Color(63, 127, 127));
        this.styles[28] = new Style(color12);
        this.styles[29] = new Style(color3, null, font2);
        this.styles[30] = new Style(color6);
        this.styles[31] = new Style(color7);
        this.styles[33] = new Style(new Color(0xCC6600));
        this.styles[32] = new Style(new Color(32896));
        this.styles[34] = new Style(color5);
        this.styles[35] = new Style(color13);
        this.styles[36] = new Style(color13);
        this.styles[37] = new Style(color13);
        this.styles[38] = new Style(color13);
        int n = 0;
        while (n < this.styles.length) {
            if (this.styles[n] == null) {
                this.styles[n] = new Style();
            }
            ++n;
        }
    }

    public void setStyle(int n, Style style) {
        this.styles[n] = style;
    }

    public void setStyles(Style[] styleArray) {
        this.styles = styleArray;
    }

    private static final Color stringToColor(String string) {
        char c = string.charAt(0);
        return new Color(c == '$' || c == '#' ? Integer.parseInt(string.substring(1), 16) : Integer.parseInt(string));
    }

    public String toCommaSeparatedString() {
        StringBuilder stringBuilder = new StringBuilder(VERSION);
        stringBuilder.append(',');
        int n = 0;
        while (n < this.styles.length) {
            stringBuilder.append(n).append(',');
            Style style = this.styles[n];
            if (style == null) {
                stringBuilder.append("-,-,f,-,,,");
            } else {
                Color color = style.foreground;
                stringBuilder.append(color != null ? String.valueOf(SyntaxScheme.getHexString(color)) + "," : "-,");
                color = style.background;
                stringBuilder.append(color != null ? String.valueOf(SyntaxScheme.getHexString(color)) + "," : "-,");
                stringBuilder.append(style.underline ? "t," : "f,");
                Font font = style.font;
                if (font != null) {
                    stringBuilder.append(font.getFamily()).append(',').append(font.getStyle()).append(',').append(font.getSize()).append(',');
                } else {
                    stringBuilder.append("-,,,");
                }
            }
            ++n;
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private static class SyntaxSchemeLoader
    extends DefaultHandler {
        private Font baseFont;
        private SyntaxScheme scheme;

        public SyntaxSchemeLoader(Font font) {
            this.scheme = new SyntaxScheme(font);
        }

        public static SyntaxScheme load(Font font, InputStream inputStream) throws IOException {
            SyntaxSchemeLoader syntaxSchemeLoader = null;
            try {
                XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                syntaxSchemeLoader = new SyntaxSchemeLoader(font);
                syntaxSchemeLoader.baseFont = font;
                xMLReader.setContentHandler(syntaxSchemeLoader);
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setEncoding("UTF-8");
                xMLReader.parse(inputSource);
            }
            catch (SAXException sAXException) {
                throw new IOException(sAXException.toString());
            }
            return syntaxSchemeLoader.scheme;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ("style".equals(string3)) {
                String string4 = attributes.getValue("token");
                Field field = null;
                try {
                    field = Token.class.getField(string4);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    System.err.println("Invalid token type: " + string4);
                    return;
                }
                if (field.getType() == Integer.TYPE) {
                    String string5;
                    String string6;
                    Object object;
                    int n = 0;
                    try {
                        n = field.getInt(this.scheme);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                        return;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                        return;
                    }
                    String string7 = attributes.getValue("fg");
                    if (string7 != null) {
                        ((SyntaxScheme)this.scheme).styles[n].foreground = object = SyntaxScheme.stringToColor(string7);
                    }
                    if ((object = attributes.getValue("bg")) != null) {
                        Color color;
                        ((SyntaxScheme)this.scheme).styles[n].background = color = SyntaxScheme.stringToColor((String)object);
                    }
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String string8 = attributes.getValue("bold");
                    if (string8 != null) {
                        bl2 = Boolean.valueOf(string8);
                        bl = true;
                    }
                    if ((string6 = attributes.getValue("italic")) != null) {
                        bl3 = Boolean.valueOf(string6);
                        bl = true;
                    }
                    if (bl) {
                        int n2 = 0;
                        if (bl2) {
                            n2 |= 1;
                        }
                        if (bl3) {
                            n2 |= 2;
                        }
                        ((SyntaxScheme)this.scheme).styles[n].font = this.baseFont.deriveFont(n2);
                    }
                    if ((string5 = attributes.getValue("underline")) != null) {
                        boolean bl4;
                        ((SyntaxScheme)this.scheme).styles[n].underline = bl4 = Boolean.valueOf(string5).booleanValue();
                    }
                }
            }
        }
    }
}

