/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import org.fife.ui.rsyntaxtextarea.RtfToText;

class RtfTransferable
implements Transferable {
    private byte[] data;
    private final DataFlavor[] FLAVORS = new DataFlavor[]{new DataFlavor("text/rtf", "RTF"), DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};

    public RtfTransferable(byte[] byArray) {
        this.data = byArray;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(this.FLAVORS[0])) {
            return new ByteArrayInputStream(this.data == null ? new byte[]{} : this.data);
        }
        if (dataFlavor.equals(this.FLAVORS[1])) {
            return this.data == null ? "" : RtfToText.getPlainText(this.data);
        }
        if (dataFlavor.equals(this.FLAVORS[2])) {
            String string = "";
            if (this.data != null) {
                string = RtfToText.getPlainText(this.data);
            }
            return new StringReader(string);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])this.FLAVORS.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        int n = 0;
        while (n < this.FLAVORS.length) {
            if (dataFlavor.equals(this.FLAVORS[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

