/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

class RtfToText {
    private Reader r;
    private StringBuilder sb;
    private StringBuilder controlWord;
    private int blockCount;
    private boolean inControlWord;

    private RtfToText(Reader reader) {
        this.r = reader;
        this.sb = new StringBuilder();
        this.controlWord = new StringBuilder();
        this.blockCount = 0;
        this.inControlWord = false;
    }

    /*
     * Unable to fully structure code
     */
    private String convert() throws IOException {
        var1_1 = this.r.read();
        if (var1_1 == 123) ** GOTO lbl58
        throw new IOException("Invalid RTF file");
lbl-1000:
        // 1 sources

        {
            var2_2 = (char)var1_1;
            switch (var2_2) {
                case '{': {
                    if (this.inControlWord && this.controlWord.length() == 0) {
                        this.sb.append('{');
                        this.controlWord.setLength(0);
                        this.inControlWord = false;
                        break;
                    }
                    ++this.blockCount;
                    break;
                }
                case '}': {
                    if (this.inControlWord && this.controlWord.length() == 0) {
                        this.sb.append('}');
                        this.controlWord.setLength(0);
                        this.inControlWord = false;
                        break;
                    }
                    --this.blockCount;
                    break;
                }
                case '\\': {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        if (this.controlWord.length() == 0) {
                            this.sb.append('\\');
                            this.controlWord.setLength(0);
                            this.inControlWord = false;
                            break;
                        }
                        this.endControlWord();
                        this.inControlWord = true;
                        break;
                    }
                    this.inControlWord = true;
                    break;
                }
                case ' ': {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        this.endControlWord();
                        break;
                    }
                    this.sb.append(' ');
                    break;
                }
                case '\n': 
                case '\r': {
                    if (this.blockCount != 0 || !this.inControlWord) continue block7;
                    this.endControlWord();
                    break;
                }
                default: {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        this.controlWord.append(var2_2);
                        break;
                    }
                    this.sb.append(var2_2);
                }
            }
lbl58:
            // 17 sources

            ** while ((var1_1 = this.r.read()) != -1)
        }
lbl59:
        // 1 sources

        return this.sb.toString();
    }

    private void endControlWord() {
        String string = this.controlWord.toString();
        if ("par".equals(string)) {
            this.sb.append('\n');
        } else if ("tab".equals(string)) {
            this.sb.append('\t');
        }
        this.controlWord.setLength(0);
        this.inControlWord = false;
    }

    public static String getPlainText(byte[] byArray) throws IOException {
        return RtfToText.getPlainText(new ByteArrayInputStream(byArray));
    }

    public static String getPlainText(File file) throws IOException {
        return RtfToText.getPlainText(new BufferedReader(new FileReader(file)));
    }

    public static String getPlainText(InputStream inputStream) throws IOException {
        return RtfToText.getPlainText(new InputStreamReader(inputStream, "US-ASCII"));
    }

    private static String getPlainText(Reader reader) throws IOException {
        try {
            RtfToText rtfToText = new RtfToText(reader);
            String string = rtfToText.convert();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static String getPlainText(String string) throws IOException {
        return RtfToText.getPlainText(new StringReader(string));
    }
}

