/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rtextarea.RTextAreaHighlighter;
import org.fife.ui.rtextarea.SmartHighlightPainter;

public class RSyntaxTextAreaHighlighter
extends RTextAreaHighlighter {
    private List<SyntaxLayeredHighlightInfoImpl> markedOccurrences = new ArrayList<SyntaxLayeredHighlightInfoImpl>();
    private List<SyntaxLayeredHighlightInfoImpl> parserHighlights = new ArrayList<SyntaxLayeredHighlightInfoImpl>(0);
    private static final Color DEFAULT_PARSER_NOTICE_COLOR = Color.RED;

    Object addMarkedOccurrenceHighlight(int n, int n2, SmartHighlightPainter smartHighlightPainter) throws BadLocationException {
        Document document = this.textArea.getDocument();
        TextUI textUI = this.textArea.getUI();
        SyntaxLayeredHighlightInfoImpl syntaxLayeredHighlightInfoImpl = new SyntaxLayeredHighlightInfoImpl();
        syntaxLayeredHighlightInfoImpl.setPainter(smartHighlightPainter);
        syntaxLayeredHighlightInfoImpl.setStartOffset(document.createPosition(n));
        syntaxLayeredHighlightInfoImpl.setEndOffset(document.createPosition(n2 - 1));
        this.markedOccurrences.add(syntaxLayeredHighlightInfoImpl);
        textUI.damageRange(this.textArea, n, n2);
        return syntaxLayeredHighlightInfoImpl;
    }

    RTextAreaHighlighter.HighlightInfo addParserHighlight(ParserNotice parserNotice, Highlighter.HighlightPainter highlightPainter) throws BadLocationException {
        Document document = this.textArea.getDocument();
        TextUI textUI = this.textArea.getUI();
        int n = parserNotice.getOffset();
        int n2 = 0;
        if (n == -1) {
            int n3 = parserNotice.getLine();
            Element element = document.getDefaultRootElement();
            if (n3 >= 0 && n3 < element.getElementCount()) {
                Element element2 = element.getElement(n3);
                n = element2.getStartOffset();
                n2 = element2.getEndOffset();
            }
        } else {
            n2 = n + parserNotice.getLength();
        }
        SyntaxLayeredHighlightInfoImpl syntaxLayeredHighlightInfoImpl = new SyntaxLayeredHighlightInfoImpl();
        syntaxLayeredHighlightInfoImpl.setPainter(highlightPainter);
        syntaxLayeredHighlightInfoImpl.setStartOffset(document.createPosition(n));
        syntaxLayeredHighlightInfoImpl.setEndOffset(document.createPosition(n2 - 1));
        syntaxLayeredHighlightInfoImpl.notice = parserNotice;
        this.parserHighlights.add(syntaxLayeredHighlightInfoImpl);
        textUI.damageRange(this.textArea, n, n2);
        return syntaxLayeredHighlightInfoImpl;
    }

    void clearMarkOccurrencesHighlights() {
        for (RTextAreaHighlighter.HighlightInfo highlightInfo : this.markedOccurrences) {
            this.repaintListHighlight(highlightInfo);
        }
        this.markedOccurrences.clear();
    }

    void clearParserHighlights() {
        int n = 0;
        while (n < this.parserHighlights.size()) {
            this.repaintListHighlight(this.parserHighlights.get(n));
            ++n;
        }
        this.parserHighlights.clear();
    }

    public void clearParserHighlights(Parser parser) {
        Iterator<SyntaxLayeredHighlightInfoImpl> iterator = this.parserHighlights.iterator();
        while (iterator.hasNext()) {
            SyntaxLayeredHighlightInfoImpl syntaxLayeredHighlightInfoImpl = iterator.next();
            if (syntaxLayeredHighlightInfoImpl.notice.getParser() != parser) continue;
            if (syntaxLayeredHighlightInfoImpl.width > 0 && syntaxLayeredHighlightInfoImpl.height > 0) {
                this.textArea.repaint(syntaxLayeredHighlightInfoImpl.x, syntaxLayeredHighlightInfoImpl.y, syntaxLayeredHighlightInfoImpl.width, syntaxLayeredHighlightInfoImpl.height);
            }
            iterator.remove();
        }
    }

    @Override
    public void deinstall(JTextComponent jTextComponent) {
        super.deinstall(jTextComponent);
        this.markedOccurrences.clear();
        this.parserHighlights.clear();
    }

    public List<DocumentRange> getMarkedOccurrences() {
        ArrayList<DocumentRange> arrayList = new ArrayList<DocumentRange>(this.markedOccurrences.size());
        for (RTextAreaHighlighter.HighlightInfo highlightInfo : this.markedOccurrences) {
            int n = highlightInfo.getStartOffset();
            int n2 = highlightInfo.getEndOffset() + 1;
            DocumentRange documentRange = new DocumentRange(n, n2);
            arrayList.add(documentRange);
        }
        return arrayList;
    }

    @Override
    public void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
        this.paintListLayered(graphics, n, n2, shape, jTextComponent, view, this.markedOccurrences);
        super.paintLayeredHighlights(graphics, n, n2, shape, jTextComponent, view);
        this.paintListLayered(graphics, n, n2, shape, jTextComponent, view, this.parserHighlights);
    }

    void removeParserHighlight(RTextAreaHighlighter.HighlightInfo highlightInfo) {
        this.repaintListHighlight(highlightInfo);
        this.parserHighlights.remove(highlightInfo);
    }

    private static class SyntaxLayeredHighlightInfoImpl
    extends RTextAreaHighlighter.LayeredHighlightInfoImpl {
        ParserNotice notice;

        private SyntaxLayeredHighlightInfoImpl() {
        }

        @Override
        public Color getColor() {
            Color color = null;
            if (this.notice != null && (color = this.notice.getColor()) == null) {
                color = DEFAULT_PARSER_NOTICE_COLOR;
            }
            return color;
        }
    }
}

