/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.DefaultOccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.OccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.SmartHighlightPainter;

public class HtmlOccurrenceMarker
implements OccurrenceMarker {
    private static final char[] CLOSE_TAG_START = new char[]{'<', '/'};
    private static final char[] TAG_SELF_CLOSE = new char[]{'/', '>'};
    private static final Set<String> TAGS_REQUIRING_CLOSING = HtmlOccurrenceMarker.getRequiredClosingTags();

    public static final Set<String> getRequiredClosingTags() {
        String[] stringArray = new String[]{"html", "head", "title", "style", "script", "noscript", "body", "section", "nav", "article", "aside", "h1", "h2", "h3", "h4", "h5", "h6", "header", "footer", "address", "pre", "dialog", "blockquote", "ol", "ul", "dl", "a", "q", "cite", "em", "strong", "small", "mark", "dfn", "abbr", "time", "progress", "meter", "code", "var", "samp", "kbd", "sub", "sup", "span", "i", "b", "bdo", "ruby", "rt", "rp", "ins", "del", "figure", "iframe", "object", "video", "audio", "canvas", "map", "table", "caption", "form", "fieldset", "label", "button", "select", "datalist", "textarea", "output", "details", "bb", "menu", "legend", "div", "acronym", "applet", "big", "blink", "center", "dir", "font", "frame", "frameset", "isindex", "listing", "marquee", "nobr", "noembed", "noframes", "plaintext", "s", "spacer", "strike", "tt", "u", "xmp"};
        return new HashSet<String>(Arrays.asList(stringArray));
    }

    public static final Token getTagNameTokenForCaretOffset(RSyntaxTextArea rSyntaxTextArea, OccurrenceMarker occurrenceMarker) {
        int n = rSyntaxTextArea.getCaretPosition();
        Token token = rSyntaxTextArea.getTokenListForLine(rSyntaxTextArea.getCaretLineNumber());
        Token token2 = null;
        while (token != null && token.isPaintable()) {
            if (token.getType() == 26) {
                token2 = token;
            }
            if (token.getEndOffset() == n || token.containsPosition(n)) {
                if (occurrenceMarker.isValidType(rSyntaxTextArea, token) && token.getType() != 26) {
                    return token;
                }
                if (token.containsPosition(n)) break;
            }
            if (token.getType() == 25 && (token.isSingleChar('>') || token.is(TAG_SELF_CLOSE))) {
                token2 = null;
            }
            token = token.getNextToken();
        }
        return token2;
    }

    @Override
    public Token getTokenToMark(RSyntaxTextArea rSyntaxTextArea) {
        return HtmlOccurrenceMarker.getTagNameTokenForCaretOffset(rSyntaxTextArea, this);
    }

    @Override
    public boolean isValidType(RSyntaxTextArea rSyntaxTextArea, Token token) {
        return rSyntaxTextArea.getMarkOccurrencesOfTokenType(token.getType());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void markOccurrences(RSyntaxDocument var1_1, Token var2_2, RSyntaxTextAreaHighlighter var3_3, SmartHighlightPainter var4_4) {
        block36: {
            if (var2_2.getType() != 26) {
                DefaultOccurrenceMarker.markOccurrencesOfToken(var1_1, var2_2, var3_3, var4_4);
                return;
            }
            var5_5 = var2_2.getLexeme();
            var6_6 = var5_5.toCharArray();
            var5_5 = var5_5.toLowerCase();
            var7_7 = var2_2.getOffset();
            var8_8 = var1_1.getDefaultRootElement();
            var9_9 = var8_8.getElementCount();
            var10_10 = var8_8.getElementIndex(var2_2.getOffset());
            var11_11 = 0;
            var12_12 = false;
            var13_13 = true;
            var2_2 = var1_1.getTokenListForLine(var10_10);
            while (var2_2 != null && var2_2.isPaintable()) {
                if (var2_2.getType() == 25) {
                    if (var2_2.isSingleChar('<') && var2_2.getOffset() + 1 == var7_7) {
                        if (!HtmlOccurrenceMarker.TAGS_REQUIRING_CLOSING.contains(var5_5)) break;
                        var12_12 = true;
                        break;
                    }
                    if (var2_2.is(HtmlOccurrenceMarker.CLOSE_TAG_START) && var2_2.getOffset() + 2 == var7_7) {
                        var12_12 = true;
                        var13_13 = false;
                        break;
                    }
                }
                var2_2 = var2_2.getNextToken();
            }
            if (!var12_12) {
                return;
            }
            if (!var13_13) break block36;
            var2_2 = var2_2.getNextToken().getNextToken();
            if (true) ** GOTO lbl62
        }
        var14_15 = new ArrayList<Entry>();
        var15_18 = false;
        var2_2 = var1_1.getTokenListForLine(var10_10);
        var16_19 = var7_7 - 2;
        if (true) ** GOTO lbl95
        block5: while (true) {
            if (var2_2.getType() == 25) {
                if (var2_2.is(HtmlOccurrenceMarker.CLOSE_TAG_START)) {
                    var14_14 = var2_2.getNextToken();
                    if (var14_14 != null && var14_14.is(var6_6)) {
                        if (var11_11 > 0) {
                            --var11_11;
                        } else {
                            try {
                                var15_16 = var14_14.getOffset() + var14_14.length();
                                var3_3.addMarkedOccurrenceHighlight(var14_14.getOffset(), var15_16, var4_4);
                                var15_16 = var7_7 + var14_14.length();
                                var3_3.addMarkedOccurrenceHighlight(var7_7, var15_16, var4_4);
                                return;
                            }
                            catch (BadLocationException var15_17) {
                                var15_17.printStackTrace();
                            }
                            return;
                        }
                    }
                } else if (var2_2.isSingleChar('<') && (var2_2 = var2_2.getNextToken()) != null && var2_2.is(var6_6)) {
                    ++var11_11;
                }
            }
            v0 = var2_2 = var2_2 == null ? null : var2_2.getNextToken();
lbl62:
            // 2 sources

            do {
                if (var2_2 != null && var2_2.isPaintable()) continue block5;
                if (++var10_10 >= var9_9) continue;
                var2_2 = var1_1.getTokenListForLine(var10_10);
            } while (var10_10 < var9_9);
            break;
        }
        return;
        block7: while (true) {
            if (var2_2.getType() == 25) {
                if (var2_2.isSingleChar('<')) {
                    var17_20 = var2_2.getNextToken();
                    if (var17_20 != null) {
                        if (var17_20.is(var6_6)) {
                            var14_15.add(new Entry(true, var17_20));
                            var15_18 = true;
                        } else {
                            var15_18 = false;
                        }
                        var2_2 = var17_20;
                    }
                } else if (var2_2.isSingleChar('>')) {
                    var15_18 = false;
                } else if (var15_18 && var2_2.is(HtmlOccurrenceMarker.TAG_SELF_CLOSE)) {
                    var14_15.remove(var14_15.size() - 1);
                    var15_18 = false;
                } else if (var2_2.is(HtmlOccurrenceMarker.CLOSE_TAG_START) && (var17_20 = var2_2.getNextToken()) != null) {
                    if (var17_20.is(var6_6)) {
                        var14_15.add(new Entry(false, var17_20));
                    }
                    var2_2 = var17_20;
                }
            }
            var2_2 = var2_2.getNextToken();
lbl95:
            // 2 sources

            do {
                if (var2_2 != null && var2_2.getOffset() < var16_19 && var2_2.isPaintable()) continue block7;
                var17_21 = var14_15.size() - 1;
                while (var17_21 >= 0) {
                    var18_22 = (Entry)var14_15.get(var17_21);
                    if ((var11_11 += var18_22.open != false ? -1 : 1) == -1) {
                        try {
                            var19_23 = var18_22.t;
                            var20_25 = var19_23.getOffset() + var19_23.length();
                            var3_3.addMarkedOccurrenceHighlight(var19_23.getOffset(), var20_25, var4_4);
                            var20_25 = var7_7 + var19_23.length();
                            var3_3.addMarkedOccurrenceHighlight(var7_7, var20_25, var4_4);
                        }
                        catch (BadLocationException var19_24) {
                            var19_24.printStackTrace();
                        }
                        var14_15.clear();
                        return;
                    }
                    --var17_21;
                }
                var14_15.clear();
                if (--var10_10 < 0) continue;
                var2_2 = var1_1.getTokenListForLine(var10_10);
            } while (var10_10 >= 0);
            break;
        }
    }

    private static class Entry {
        public boolean open;
        public Token t;

        public Entry(boolean bl, Token token) {
            this.open = bl;
            this.t = token;
        }
    }
}

