/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

public class DocumentRange
implements Comparable<DocumentRange> {
    private int startOffs;
    private int endOffs;

    public DocumentRange(int n, int n2) {
        this.set(n, n2);
    }

    @Override
    public int compareTo(DocumentRange documentRange) {
        if (documentRange == null) {
            return 1;
        }
        int n = this.startOffs - documentRange.startOffs;
        if (n != 0) {
            return n;
        }
        return this.endOffs - documentRange.endOffs;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DocumentRange) {
            return this.compareTo((DocumentRange)object) == 0;
        }
        return false;
    }

    public int getEndOffset() {
        return this.endOffs;
    }

    public int getStartOffset() {
        return this.startOffs;
    }

    public int hashCode() {
        return this.startOffs + this.endOffs;
    }

    public boolean isZeroLength() {
        return this.startOffs == this.endOffs;
    }

    public void set(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("start and end must be >= 0");
        }
        if (n2 < n) {
            throw new IllegalArgumentException("'end' cannot be less than 'start'");
        }
        this.startOffs = n;
        this.endOffs = n2;
    }

    public String toString() {
        return "[DocumentRange: " + this.startOffs + "-" + this.endOffs + "]";
    }

    public DocumentRange translate(int n) {
        this.startOffs += n;
        this.endOffs += n;
        return this;
    }
}

