/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.TokenFactory;
import org.fife.ui.rsyntaxtextarea.TokenImpl;

class DefaultTokenFactory
implements TokenFactory {
    private int size;
    private int increment;
    private TokenImpl[] tokenList;
    private int currentFreeToken;
    protected static final int DEFAULT_START_SIZE = 30;
    protected static final int DEFAULT_INCREMENT = 10;

    public DefaultTokenFactory() {
        this(30, 10);
    }

    public DefaultTokenFactory(int n, int n2) {
        this.size = n;
        this.increment = n2;
        this.currentFreeToken = 0;
        this.tokenList = new TokenImpl[n];
        int n3 = 0;
        while (n3 < n) {
            this.tokenList[n3] = new TokenImpl();
            ++n3;
        }
    }

    private final void augmentTokenList() {
        TokenImpl[] tokenImplArray = new TokenImpl[this.size + this.increment];
        System.arraycopy(this.tokenList, 0, tokenImplArray, 0, this.size);
        this.size += this.increment;
        this.tokenList = tokenImplArray;
        int n = 0;
        while (n < this.increment) {
            this.tokenList[this.size - n - 1] = new TokenImpl();
            ++n;
        }
    }

    @Override
    public TokenImpl createToken() {
        TokenImpl tokenImpl = this.tokenList[this.currentFreeToken];
        tokenImpl.text = null;
        tokenImpl.setType(0);
        tokenImpl.setOffset(-1);
        tokenImpl.setNextToken(null);
        ++this.currentFreeToken;
        if (this.currentFreeToken == this.size) {
            this.augmentTokenList();
        }
        return tokenImpl;
    }

    @Override
    public TokenImpl createToken(Segment segment, int n, int n2, int n3, int n4) {
        return this.createToken(segment.array, n, n2, n3, n4);
    }

    @Override
    public TokenImpl createToken(char[] cArray, int n, int n2, int n3, int n4) {
        TokenImpl tokenImpl = this.tokenList[this.currentFreeToken];
        tokenImpl.set(cArray, n, n2, n3, n4);
        ++this.currentFreeToken;
        if (this.currentFreeToken == this.size) {
            this.augmentTokenList();
        }
        return tokenImpl;
    }

    @Override
    public void resetAllTokens() {
        this.currentFreeToken = 0;
    }
}

