/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.templates.CodeTemplate;

public class CodeTemplateManager {
    private int maxTemplateIDLength;
    private List<CodeTemplate> templates;
    private Segment s = new Segment();
    private TemplateComparator comparator = new TemplateComparator();
    private File directory;

    public CodeTemplateManager() {
        this.templates = new ArrayList<CodeTemplate>();
    }

    public synchronized void addTemplate(CodeTemplate codeTemplate) {
        if (codeTemplate == null) {
            throw new IllegalArgumentException("template cannot be null");
        }
        this.templates.add(codeTemplate);
        this.sortTemplates();
    }

    public synchronized CodeTemplate getTemplate(RSyntaxTextArea rSyntaxTextArea) {
        int n = rSyntaxTextArea.getCaretPosition();
        int n2 = Math.min(n, this.maxTemplateIDLength);
        try {
            Document document = rSyntaxTextArea.getDocument();
            document.getText(n - n2, n2, this.s);
            int n3 = Collections.binarySearch(this.templates, this.s, this.comparator);
            return n3 >= 0 ? this.templates.get(n3) : null;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            throw new InternalError("Error in CodeTemplateManager");
        }
    }

    public synchronized int getTemplateCount() {
        return this.templates.size();
    }

    public synchronized CodeTemplate[] getTemplates() {
        CodeTemplate[] codeTemplateArray = new CodeTemplate[this.templates.size()];
        return this.templates.toArray(codeTemplateArray);
    }

    public static final boolean isValidChar(char c) {
        return RSyntaxUtilities.isLetterOrDigit(c) || c == '_';
    }

    public synchronized boolean removeTemplate(CodeTemplate codeTemplate) {
        if (codeTemplate == null) {
            throw new IllegalArgumentException("template cannot be null");
        }
        return this.templates.remove(codeTemplate);
    }

    public synchronized CodeTemplate removeTemplate(String string) {
        if (string == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        Iterator<CodeTemplate> iterator = this.templates.iterator();
        while (iterator.hasNext()) {
            CodeTemplate codeTemplate = iterator.next();
            if (!string.equals(codeTemplate.getID())) continue;
            iterator.remove();
            return codeTemplate;
        }
        return null;
    }

    public synchronized void replaceTemplates(CodeTemplate[] codeTemplateArray) {
        this.templates.clear();
        if (codeTemplateArray != null) {
            int n = 0;
            while (n < codeTemplateArray.length) {
                this.templates.add(codeTemplateArray[n]);
                ++n;
            }
        }
        this.sortTemplates();
    }

    public synchronized boolean saveTemplates() {
        if (this.templates == null) {
            return true;
        }
        if (this.directory == null || !this.directory.isDirectory()) {
            return false;
        }
        File[] fileArray = this.directory.listFiles(new XMLFileFilter());
        if (fileArray == null) {
            return false;
        }
        boolean bl = fileArray.length;
        boolean bl2 = false;
        while (bl2 < bl) {
            fileArray[bl2].delete();
            bl2 += 1;
        }
        bl2 = true;
        for (CodeTemplate codeTemplate : this.templates) {
            File file = new File(this.directory, String.valueOf(codeTemplate.getID()) + ".xml");
            try {
                XMLEncoder xMLEncoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(file)));
                xMLEncoder.writeObject(codeTemplate);
                xMLEncoder.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                bl2 = false;
            }
        }
        return bl2;
    }

    public synchronized int setTemplateDirectory(File file) {
        if (file != null && file.isDirectory()) {
            this.directory = file;
            File[] fileArray = file.listFiles(new XMLFileFilter());
            int n = fileArray == null ? 0 : fileArray.length;
            int n2 = this.templates.size();
            ArrayList<CodeTemplate> arrayList = new ArrayList<CodeTemplate>(n2 + n);
            arrayList.addAll(this.templates);
            int n3 = 0;
            while (n3 < n) {
                try {
                    XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(fileArray[n3])));
                    Object object = xMLDecoder.readObject();
                    if (!(object instanceof CodeTemplate)) {
                        throw new IOException("Not a CodeTemplate: " + fileArray[n3].getAbsolutePath());
                    }
                    arrayList.add((CodeTemplate)object);
                    xMLDecoder.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n3;
            }
            this.templates = arrayList;
            this.sortTemplates();
            return this.getTemplateCount();
        }
        return -1;
    }

    private synchronized void sortTemplates() {
        this.maxTemplateIDLength = 0;
        Iterator<CodeTemplate> iterator = this.templates.iterator();
        while (iterator.hasNext()) {
            CodeTemplate codeTemplate = iterator.next();
            if (codeTemplate == null || codeTemplate.getID() == null) {
                iterator.remove();
                continue;
            }
            this.maxTemplateIDLength = Math.max(this.maxTemplateIDLength, codeTemplate.getID().length());
        }
        Collections.sort(this.templates);
    }

    private static class TemplateComparator
    implements Comparator,
    Serializable {
        private TemplateComparator() {
        }

        public int compare(Object object, Object object2) {
            CodeTemplate codeTemplate = (CodeTemplate)object;
            char[] cArray = codeTemplate.getID().toCharArray();
            int n = 0;
            int n2 = cArray.length;
            Segment segment = (Segment)object2;
            char[] cArray2 = segment.array;
            int n3 = segment.count;
            int n4 = segment.offset + n3 - 1;
            while (n4 >= segment.offset && CodeTemplateManager.isValidChar(cArray2[n4])) {
                --n4;
            }
            int n5 = ++n4 - segment.offset;
            int n6 = Math.min(n2, n3 -= n5);
            while (n6-- != 0) {
                char c;
                char c2;
                if ((c2 = cArray[n++]) == (c = cArray2[n4++])) continue;
                return c2 - c;
            }
            return n2 - n3;
        }
    }

    private static class XMLFileFilter
    implements FileFilter {
        private XMLFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".xml");
        }
    }
}

