/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.AbstractJFlexTokenMaker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;

public abstract class AbstractJFlexCTokenMaker
extends AbstractJFlexTokenMaker {
    private final Action INSERT_BREAK_ACTION = this.createInsertBreakAction();
    private static final Pattern MLC_PATTERN = Pattern.compile("([ \\t]*)(/?[\\*]+)([ \\t]*)");

    protected AbstractJFlexCTokenMaker() {
    }

    protected Action createInsertBreakAction() {
        return new CStyleInsertBreakAction();
    }

    @Override
    public boolean getCurlyBracesDenoteCodeBlocks(int n) {
        return true;
    }

    @Override
    public Action getInsertBreakAction() {
        return this.INSERT_BREAK_ACTION;
    }

    @Override
    public boolean getMarkOccurrencesOfTokenType(int n) {
        return n == 20 || n == 8;
    }

    @Override
    public boolean getShouldIndentNextLineAfter(Token token) {
        if (token != null && token.length() == 1) {
            char c = token.charAt(0);
            return c == '{' || c == '(';
        }
        return false;
    }

    private boolean isInternalEolTokenForMLCs(Token token) {
        int n = token.getType();
        if (n < 0) {
            return (n = this.getClosestStandardTokenTypeForInternalType(n)) == 2 || n == 3;
        }
        return false;
    }

    protected class CStyleInsertBreakAction
    extends RSyntaxTextAreaEditorKit.InsertBreakAction {
        protected CStyleInsertBreakAction() {
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            int n;
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.getTextComponent(actionEvent);
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
            int n2 = rSyntaxDocument.getLastTokenTypeOnLine(n = rTextArea.getCaretLineNumber());
            if (n2 < 0) {
                n2 = rSyntaxDocument.getClosestStandardTokenTypeForInternalType(n2);
            }
            if (n2 == 3 || n2 == 2) {
                this.insertBreakInMLC(actionEvent, rSyntaxTextArea, n);
            } else {
                this.handleInsertBreak(rSyntaxTextArea, true);
            }
        }

        private boolean appearsNested(RSyntaxTextArea rSyntaxTextArea, int n, int n2) {
            int n3 = n;
            while (n < rSyntaxTextArea.getLineCount()) {
                Token token = rSyntaxTextArea.getTokenListForLine(n);
                int n4 = 0;
                if (n++ == n3) {
                    if ((token = RSyntaxUtilities.getTokenAtOffset(token, n2)) == null) continue;
                    n4 = token.documentToToken(n2);
                } else {
                    n4 = token.getTextOffset();
                }
                int n5 = token.getTextOffset();
                while (n4 < n5 + token.length() - 1) {
                    if (token.charAt(n4 - n5) == '/' && token.charAt(n4 - n5 + 1) == '*') {
                        return true;
                    }
                    ++n4;
                }
                if ((token = token.getNextToken()) == null || AbstractJFlexCTokenMaker.this.isInternalEolTokenForMLCs(token)) continue;
                return false;
            }
            return true;
        }

        private void insertBreakInMLC(ActionEvent actionEvent, RSyntaxTextArea rSyntaxTextArea, int n) {
            Matcher matcher = null;
            int n2 = -1;
            int n3 = -1;
            String string = null;
            try {
                n2 = rSyntaxTextArea.getLineStartOffset(n);
                n3 = rSyntaxTextArea.getLineEndOffset(n);
                string = rSyntaxTextArea.getText(n2, n3 - n2);
                matcher = MLC_PATTERN.matcher(string);
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(rSyntaxTextArea);
                badLocationException.printStackTrace();
                return;
            }
            if (matcher.lookingAt()) {
                boolean bl;
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                int n4 = rSyntaxTextArea.getCaretPosition();
                if (n4 >= n2 && n4 < n2 + string2.length() + string3.length()) {
                    if (string3.charAt(0) == '/') {
                        this.handleInsertBreak(rSyntaxTextArea, true);
                        return;
                    }
                    rSyntaxTextArea.setCaretPosition(n3 - 1);
                } else {
                    bl = false;
                    while (n4 < n3 - 1 && Character.isWhitespace(string.charAt(n4 - n2))) {
                        bl = true;
                        ++n4;
                    }
                    if (bl) {
                        rSyntaxTextArea.setCaretPosition(n4);
                    }
                }
                bl = string3.charAt(0) == '/';
                boolean bl2 = this.appearsNested(rSyntaxTextArea, n, n2 + string2.length() + 2);
                String string4 = String.valueOf(string2) + (bl ? " * " : "*") + matcher.group(3);
                rSyntaxTextArea.replaceSelection("\n" + string4);
                if (bl2) {
                    n4 = rSyntaxTextArea.getCaretPosition();
                    rSyntaxTextArea.insert("\n" + string2 + " */", n4);
                    rSyntaxTextArea.setCaretPosition(n4);
                }
            } else {
                this.handleInsertBreak(rSyntaxTextArea, true);
            }
        }
    }
}

