/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.CompletionProvider;

public class VariableCompletion
extends BasicCompletion {
    private String type;
    private String definedIn;

    public VariableCompletion(CompletionProvider completionProvider, String string, String string2) {
        super(completionProvider, string);
        this.type = string2;
    }

    protected void addDefinitionString(StringBuilder stringBuilder) {
        stringBuilder.append("<html><b>").append(this.getDefinitionString()).append("</b>");
    }

    public String getDefinitionString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.type != null) {
            stringBuilder.append(this.type).append(' ');
        }
        stringBuilder.append(this.getName());
        return stringBuilder.toString();
    }

    public String getDefinedIn() {
        return this.definedIn;
    }

    public String getName() {
        return this.getReplacementText();
    }

    @Override
    public String getSummary() {
        StringBuilder stringBuilder = new StringBuilder();
        this.addDefinitionString(stringBuilder);
        this.possiblyAddDescription(stringBuilder);
        this.possiblyAddDefinedIn(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public String getToolTipText() {
        return this.getDefinitionString();
    }

    public String getType() {
        return this.type;
    }

    protected void possiblyAddDefinedIn(StringBuilder stringBuilder) {
        if (this.definedIn != null) {
            stringBuilder.append("<hr>Defined in:");
            stringBuilder.append(" <em>").append(this.definedIn).append("</em>");
        }
    }

    protected boolean possiblyAddDescription(StringBuilder stringBuilder) {
        if (this.getShortDescription() != null) {
            stringBuilder.append("<hr><br>");
            stringBuilder.append(this.getShortDescription());
            stringBuilder.append("<br><br><br>");
            return true;
        }
        return false;
    }

    public void setDefinedIn(String string) {
        this.definedIn = string;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

