/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.AccessControlException;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class Util {
    public static final String PROPERTY_DONT_USE_SUBSTANCE_RENDERERS = "org.fife.ui.autocomplete.DontUseSubstanceRenderers";
    public static final String PROPERTY_ALLOW_DECORATED_AUTOCOMPLETE_WINDOWS = "org.fife.ui.autocomplete.allowDecoratedAutoCompleteWindows";
    private static final Color LIGHT_HYPERLINK_FG = new Color(0xD8FFFF);
    private static final Pattern TAG_PATTERN = Pattern.compile("<[^>]*>");
    private static final boolean useSubstanceRenderers;
    private static boolean desktopCreationAttempted;
    private static Object desktop;
    private static final Object LOCK_DESKTOP_CREATION;

    static {
        LOCK_DESKTOP_CREATION = new Object();
        boolean bl = true;
        try {
            bl = !Boolean.getBoolean(PROPERTY_DONT_USE_SUBSTANCE_RENDERERS);
        }
        catch (AccessControlException accessControlException) {
            bl = true;
        }
        useSubstanceRenderers = bl;
    }

    public static boolean browse(URI uRI) {
        Object object;
        boolean bl = false;
        if (uRI != null && (object = Util.getDesktop()) != null) {
            try {
                Method method = object.getClass().getDeclaredMethod("browse", URI.class);
                method.invoke(object, uRI);
                bl = true;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getDesktop() {
        Object object = LOCK_DESKTOP_CREATION;
        synchronized (object) {
            if (!desktopCreationAttempted) {
                desktopCreationAttempted = true;
                try {
                    Class<?> clazz = Class.forName("java.awt.Desktop");
                    Method method = clazz.getDeclaredMethod("isDesktopSupported", new Class[0]);
                    boolean bl = (Boolean)method.invoke(null, new Object[0]);
                    if (bl) {
                        method = clazz.getDeclaredMethod("getDesktop", new Class[0]);
                        desktop = method.invoke(null, new Object[0]);
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {}
            }
        }
        return desktop;
    }

    public static String getHexString(Color color) {
        if (color == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("#");
        int n = color.getRed();
        if (n < 16) {
            stringBuilder.append('0');
        }
        stringBuilder.append(Integer.toHexString(n));
        int n2 = color.getGreen();
        if (n2 < 16) {
            stringBuilder.append('0');
        }
        stringBuilder.append(Integer.toHexString(n2));
        int n3 = color.getBlue();
        if (n3 < 16) {
            stringBuilder.append('0');
        }
        stringBuilder.append(Integer.toHexString(n3));
        return stringBuilder.toString();
    }

    static final Color getHyperlinkForeground() {
        Color color = UIManager.getColor("Label.foreground");
        if (color == null) {
            color = new JLabel().getForeground();
        }
        return Util.isLightForeground(color) ? LIGHT_HYPERLINK_FG : Color.blue;
    }

    public static Rectangle getScreenBoundsForPoint(int n, int n2) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n3 = 0;
        while (n3 < graphicsDeviceArray.length) {
            GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[n3].getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            if (rectangle.contains(n, n2)) {
                return rectangle;
            }
            ++n3;
        }
        return graphicsEnvironment.getMaximumWindowBounds();
    }

    public static boolean getShouldAllowDecoratingMainAutoCompleteWindows() {
        try {
            return Boolean.getBoolean(PROPERTY_ALLOW_DECORATED_AUTOCOMPLETE_WINDOWS);
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    public static boolean getUseSubstanceRenderers() {
        return useSubstanceRenderers;
    }

    public static final boolean isLightForeground(Color color) {
        return color.getRed() > 160 && color.getGreen() > 160 && color.getBlue() > 160;
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        int n = string2.length();
        if (string.length() >= n) {
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                char c2 = string2.charAt(n2);
                if (Character.toLowerCase(c) != Character.toLowerCase(c2)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static String stripHtml(String string) {
        if (string == null || !string.startsWith("<html>")) {
            return string;
        }
        return TAG_PATTERN.matcher(string).replaceAll("");
    }
}

