/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.fife.ui.autocomplete.AbstractCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionInsertionInfo;
import org.fife.ui.autocomplete.TemplatePiece;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

public class TemplateCompletion
extends AbstractCompletion
implements ParameterizedCompletion {
    private List<TemplatePiece> pieces;
    private String inputText;
    private String definitionString;
    private String shortDescription;
    private String summary;
    private List<ParameterizedCompletion.Parameter> params;

    public TemplateCompletion(CompletionProvider completionProvider, String string, String string2, String string3) {
        this(completionProvider, string, string2, string3, null, null);
    }

    public TemplateCompletion(CompletionProvider completionProvider, String string, String string2, String string3, String string4, String string5) {
        super(completionProvider);
        this.inputText = string;
        this.definitionString = string2;
        this.shortDescription = string4;
        this.summary = string5;
        this.pieces = new ArrayList<TemplatePiece>(3);
        this.params = new ArrayList<ParameterizedCompletion.Parameter>(3);
        this.parse(string3);
    }

    private void addTemplatePiece(TemplatePiece templatePiece) {
        this.pieces.add(templatePiece);
        if (templatePiece instanceof TemplatePiece.Param && !"cursor".equals(templatePiece.getText())) {
            Object var2_2 = null;
            ParameterizedCompletion.Parameter parameter = new ParameterizedCompletion.Parameter(var2_2, templatePiece.getText());
            this.params.add(parameter);
        }
    }

    @Override
    public String getInputText() {
        return this.inputText;
    }

    private String getPieceText(int n, String string) {
        TemplatePiece templatePiece = this.pieces.get(n);
        String string2 = templatePiece.getText();
        if (string2.indexOf(10) > -1) {
            string2 = string2.replaceAll("\n", "\n" + string);
        }
        return string2;
    }

    @Override
    public String getReplacementText() {
        return null;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public String getDefinitionString() {
        return this.definitionString;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public boolean getShowParameterToolTip() {
        return false;
    }

    @Override
    public ParameterizedCompletionInsertionInfo getInsertionInfo(JTextComponent jTextComponent, boolean bl) {
        int n;
        int n2;
        ParameterizedCompletionInsertionInfo parameterizedCompletionInsertionInfo = new ParameterizedCompletionInsertionInfo();
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n2 = jTextComponent.getCaretPosition();
        Position position = null;
        int n4 = -1;
        try {
            position = jTextComponent.getDocument().createPosition(n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        parameterizedCompletionInsertionInfo.setCaretRange(n3, position);
        int n5 = n = n2;
        Document document = jTextComponent.getDocument();
        String string = null;
        try {
            string = RSyntaxUtilities.getLeadingWhitespace(document, n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            string = "";
        }
        int n6 = n2;
        int n7 = 0;
        while (n7 < this.pieces.size()) {
            TemplatePiece templatePiece = this.pieces.get(n7);
            String string2 = this.getPieceText(n7, string);
            if (templatePiece instanceof TemplatePiece.Text) {
                if (bl) {
                    n6 = this.possiblyReplaceTabsWithSpaces(stringBuilder, string2, jTextComponent, n6);
                } else {
                    stringBuilder.append(string2);
                    n6 += string2.length();
                }
            } else if (templatePiece instanceof TemplatePiece.Param && "cursor".equals(string2)) {
                n4 = n6;
            } else {
                int n8 = n6 + string2.length();
                stringBuilder.append(string2);
                if (templatePiece instanceof TemplatePiece.Param) {
                    parameterizedCompletionInsertionInfo.addReplacementLocation(n6, n8);
                    if (n == n2) {
                        n = n6;
                        n5 = n + string2.length();
                    }
                } else if (templatePiece instanceof TemplatePiece.ParamCopy) {
                    parameterizedCompletionInsertionInfo.addReplacementCopy(templatePiece.getText(), n6, n8);
                }
                n6 = n8;
            }
            ++n7;
        }
        if (n == n3 && n == n5 && this.getParamCount() == 0 && n4 > -1) {
            n = n5 = n4;
        }
        parameterizedCompletionInsertionInfo.setInitialSelection(n, n5);
        if (n4 > -1) {
            parameterizedCompletionInsertionInfo.addReplacementLocation(n4, n4);
        }
        parameterizedCompletionInsertionInfo.setDefaultEndOffs(n4);
        parameterizedCompletionInsertionInfo.setTextToInsert(stringBuilder.toString());
        return parameterizedCompletionInsertionInfo;
    }

    @Override
    public ParameterizedCompletion.Parameter getParam(int n) {
        return this.params.get(n);
    }

    @Override
    public int getParamCount() {
        return this.params == null ? 0 : this.params.size();
    }

    private boolean isParamDefined(String string) {
        int n = 0;
        while (n < this.getParamCount()) {
            ParameterizedCompletion.Parameter parameter = this.getParam(n);
            if (string.equals(parameter.getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void parse(String string) {
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf(36, n2)) > -1 && n < string.length() - 1) {
            char c = string.charAt(n + 1);
            switch (c) {
                case '$': {
                    this.addTemplatePiece(new TemplatePiece.Text(string.substring(n2, n + 1)));
                    n2 = n + 2;
                    break;
                }
                case '{': {
                    int n3 = string.indexOf(125, n + 2);
                    if (n3 <= -1) break;
                    this.addTemplatePiece(new TemplatePiece.Text(string.substring(n2, n)));
                    String string2 = string.substring(n + 2, n3);
                    if (!"cursor".equals(string2) && this.isParamDefined(string2)) {
                        this.addTemplatePiece(new TemplatePiece.ParamCopy(string2));
                    } else {
                        this.addTemplatePiece(new TemplatePiece.Param(string2));
                    }
                    n2 = n3 + 1;
                }
            }
        }
        if (n2 < string.length()) {
            String string3 = string.substring(n2);
            this.addTemplatePiece(new TemplatePiece.Text(string3));
        }
    }

    private int possiblyReplaceTabsWithSpaces(StringBuilder stringBuilder, String string, JTextComponent jTextComponent, int n) {
        int n2 = string.indexOf(9);
        if (n2 > -1) {
            Object object;
            int n3 = stringBuilder.length();
            int n4 = 4;
            Document document = jTextComponent.getDocument();
            if (document != null && (object = (Integer)document.getProperty("tabSize")) != null) {
                n4 = (Integer)object;
            }
            object = "";
            int n5 = 0;
            while (n5 < n4) {
                object = String.valueOf(object) + " ";
                ++n5;
            }
            n5 = 0;
            do {
                stringBuilder.append(string.substring(n5, n2));
                stringBuilder.append((String)object);
            } while ((n2 = string.indexOf(9, n5 = n2 + 1)) > -1);
            stringBuilder.append(string.substring(n5));
            n += stringBuilder.length() - n3;
        } else {
            stringBuilder.append(string);
            n += string.length();
        }
        return n;
    }

    public void setShortDescription(String string) {
        this.shortDescription = string;
    }

    @Override
    public String toString() {
        return this.getDefinitionString();
    }
}

