/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;

public class RoundRobinAutoCompletion
extends AutoCompletion {
    private List<CompletionProvider> cycle = new ArrayList<CompletionProvider>();

    public RoundRobinAutoCompletion(CompletionProvider completionProvider) {
        super(completionProvider);
        this.cycle.add(completionProvider);
        this.setHideOnCompletionProviderChange(false);
        this.setHideOnNoText(false);
        this.setAutoCompleteSingleChoices(false);
    }

    public void addCompletionProvider(CompletionProvider completionProvider) {
        this.cycle.add(completionProvider);
    }

    public boolean advanceProvider() {
        CompletionProvider completionProvider = this.getCompletionProvider();
        int n = (this.cycle.indexOf(completionProvider) + 1) % this.cycle.size();
        this.setCompletionProvider(this.cycle.get(n));
        return n == 0;
    }

    @Override
    protected Action createAutoCompleteAction() {
        return new CycleAutoCompleteAction();
    }

    public void resetProvider() {
        CompletionProvider completionProvider;
        CompletionProvider completionProvider2 = this.getCompletionProvider();
        if (completionProvider2 != (completionProvider = this.cycle.get(0))) {
            this.setCompletionProvider(completionProvider);
        }
    }

    private class CycleAutoCompleteAction
    extends AutoCompletion.AutoCompleteAction {
        private CycleAutoCompleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (RoundRobinAutoCompletion.this.isAutoCompleteEnabled()) {
                if (RoundRobinAutoCompletion.this.isPopupVisible()) {
                    RoundRobinAutoCompletion.this.advanceProvider();
                } else {
                    RoundRobinAutoCompletion.this.resetProvider();
                }
                int n = 1;
                while (n < RoundRobinAutoCompletion.this.cycle.size()) {
                    List<Completion> list = RoundRobinAutoCompletion.this.getCompletionProvider().getCompletions(RoundRobinAutoCompletion.this.getTextComponent());
                    if (list.size() > 0) break;
                    RoundRobinAutoCompletion.this.advanceProvider();
                    ++n;
                }
            }
            super.actionPerformed(actionEvent);
        }
    }
}

