/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Position;
import org.fife.ui.rsyntaxtextarea.DocumentRange;

class ParameterizedCompletionInsertionInfo {
    private int minOffs;
    private Position maxOffs;
    private int defaultEnd = -1;
    private int selStart;
    private int selEnd;
    private String textToInsert;
    private List<DocumentRange> replacementLocations;
    private List<ReplacementCopy> replacementCopies;

    public void addReplacementCopy(String string, int n, int n2) {
        if (this.replacementCopies == null) {
            this.replacementCopies = new ArrayList<ReplacementCopy>(1);
        }
        this.replacementCopies.add(new ReplacementCopy(string, n, n2));
    }

    public void addReplacementLocation(int n, int n2) {
        if (this.replacementLocations == null) {
            this.replacementLocations = new ArrayList<DocumentRange>(1);
        }
        this.replacementLocations.add(new DocumentRange(n, n2));
    }

    public int getDefaultEndOffs() {
        return this.defaultEnd > -1 ? this.defaultEnd : this.getMaxOffset().getOffset();
    }

    public Position getMaxOffset() {
        return this.maxOffs;
    }

    public int getMinOffset() {
        return this.minOffs;
    }

    public int getReplacementCopyCount() {
        return this.replacementCopies == null ? 0 : this.replacementCopies.size();
    }

    public int getReplacementCount() {
        return this.replacementLocations == null ? 0 : this.replacementLocations.size();
    }

    public ReplacementCopy getReplacementCopy(int n) {
        return this.replacementCopies.get(n);
    }

    public DocumentRange getReplacementLocation(int n) {
        return this.replacementLocations.get(n);
    }

    public int getSelectionEnd() {
        return this.selEnd;
    }

    public int getSelectionStart() {
        return this.selStart;
    }

    public String getTextToInsert() {
        return this.textToInsert;
    }

    public boolean hasSelection() {
        return this.selEnd != this.selStart;
    }

    public void setInitialSelection(int n, int n2) {
        this.selStart = n;
        this.selEnd = n2;
    }

    public void setCaretRange(int n, Position position) {
        this.minOffs = n;
        this.maxOffs = position;
    }

    public void setDefaultEndOffs(int n) {
        this.defaultEnd = n;
    }

    public void setTextToInsert(String string) {
        this.textToInsert = string;
    }

    public static class ReplacementCopy {
        private String id;
        private int start;
        private int end;

        public ReplacementCopy(String string, int n, int n2) {
            this.id = string;
            this.start = n;
            this.end = n2;
        }

        public int getEnd() {
            return this.end;
        }

        public String getId() {
            return this.id;
        }

        public int getStart() {
            return this.start;
        }
    }
}

