/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

class OutlineHighlightPainter
extends DefaultHighlighter.DefaultHighlightPainter {
    private Color color;

    public OutlineHighlightPainter(Color color) {
        super(color);
        this.setColor(color);
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
        graphics.setColor(this.getColor());
        if (++n == n2) {
            try {
                Shape shape2 = view.modelToView(n, shape, Position.Bias.Forward);
                Rectangle rectangle = shape2.getBounds();
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
                return rectangle;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return null;
            }
        }
        if (n == view.getStartOffset() && n2 == view.getEndOffset()) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            return rectangle;
        }
        try {
            Shape shape3 = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
            Rectangle rectangle = shape3 instanceof Rectangle ? (Rectangle)shape3 : shape3.getBounds();
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            return rectangle;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cannot be null");
        }
        this.color = color;
    }
}

