/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.CompletionProviderBase;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.ToolTipSupplier;

public class LanguageAwareCompletionProvider
extends CompletionProviderBase
implements ToolTipSupplier {
    private CompletionProvider defaultProvider;
    private CompletionProvider stringCompletionProvider;
    private CompletionProvider commentCompletionProvider;
    private CompletionProvider docCommentCompletionProvider;

    protected LanguageAwareCompletionProvider() {
    }

    public LanguageAwareCompletionProvider(CompletionProvider completionProvider) {
        this.setDefaultCompletionProvider(completionProvider);
    }

    @Override
    public void clearParameterizedCompletionParams() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAlreadyEnteredText(JTextComponent jTextComponent) {
        if (!(jTextComponent instanceof RSyntaxTextArea)) {
            return "";
        }
        CompletionProvider completionProvider = this.getProviderFor(jTextComponent);
        return completionProvider != null ? completionProvider.getAlreadyEnteredText(jTextComponent) : null;
    }

    public CompletionProvider getCommentCompletionProvider() {
        return this.commentCompletionProvider;
    }

    @Override
    public List<Completion> getCompletionsAt(JTextComponent jTextComponent, Point point) {
        return this.defaultProvider == null ? null : this.defaultProvider.getCompletionsAt(jTextComponent, point);
    }

    @Override
    protected List<Completion> getCompletionsImpl(JTextComponent jTextComponent) {
        CompletionProvider completionProvider;
        if (jTextComponent instanceof RSyntaxTextArea && (completionProvider = this.getProviderFor(jTextComponent)) != null) {
            return completionProvider.getCompletions(jTextComponent);
        }
        return Collections.emptyList();
    }

    public CompletionProvider getDefaultCompletionProvider() {
        return this.defaultProvider;
    }

    public CompletionProvider getDocCommentCompletionProvider() {
        return this.docCommentCompletionProvider;
    }

    @Override
    public List<ParameterizedCompletion> getParameterizedCompletions(JTextComponent jTextComponent) {
        CompletionProvider completionProvider = this.getProviderFor(jTextComponent);
        return completionProvider == this.defaultProvider ? completionProvider.getParameterizedCompletions(jTextComponent) : null;
    }

    @Override
    public char getParameterListEnd() {
        return this.defaultProvider.getParameterListEnd();
    }

    @Override
    public String getParameterListSeparator() {
        return this.defaultProvider.getParameterListSeparator();
    }

    @Override
    public char getParameterListStart() {
        return this.defaultProvider.getParameterListStart();
    }

    private CompletionProvider getProviderFor(JTextComponent jTextComponent) {
        int n;
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)jTextComponent;
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
        Token token = rSyntaxDocument.getTokenListForLine(n = rSyntaxTextArea.getCaretLineNumber());
        if (token == null) {
            return this.getDefaultCompletionProvider();
        }
        int n2 = rSyntaxTextArea.getCaretPosition();
        Token token2 = RSyntaxUtilities.getTokenAtOffset(token, n2);
        if (token2 == null) {
            int n3 = rSyntaxDocument.getLastTokenTypeOnLine(n);
            if (n3 == 0) {
                Token token3 = token.getLastPaintableToken();
                if (token3 == null) {
                    return this.getDefaultCompletionProvider();
                }
                n3 = token3.getType();
            } else if (n3 < 0) {
                n3 = rSyntaxDocument.getClosestStandardTokenTypeForInternalType(n3);
            }
            switch (n3) {
                case 37: {
                    return this.getStringCompletionProvider();
                }
                case 1: 
                case 2: {
                    return this.getCommentCompletionProvider();
                }
                case 3: {
                    return this.getDocCommentCompletionProvider();
                }
            }
            return this.getDefaultCompletionProvider();
        }
        if (n2 == token2.getOffset()) {
            return this.getDefaultCompletionProvider();
        }
        switch (token2.getType()) {
            case 13: 
            case 37: {
                return this.getStringCompletionProvider();
            }
            case 1: 
            case 2: {
                return this.getCommentCompletionProvider();
            }
            case 3: {
                return this.getDocCommentCompletionProvider();
            }
            case 0: 
            case 8: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                return this.getDefaultCompletionProvider();
            }
        }
        return null;
    }

    public CompletionProvider getStringCompletionProvider() {
        return this.stringCompletionProvider;
    }

    @Override
    public boolean isAutoActivateOkay(JTextComponent jTextComponent) {
        CompletionProvider completionProvider = this.getProviderFor(jTextComponent);
        return completionProvider != null ? completionProvider.isAutoActivateOkay(jTextComponent) : false;
    }

    public void setCommentCompletionProvider(CompletionProvider completionProvider) {
        this.commentCompletionProvider = completionProvider;
    }

    public void setDefaultCompletionProvider(CompletionProvider completionProvider) {
        if (completionProvider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        this.defaultProvider = completionProvider;
    }

    public void setDocCommentCompletionProvider(CompletionProvider completionProvider) {
        this.docCommentCompletionProvider = completionProvider;
    }

    @Override
    public void setParameterizedCompletionParams(char c, String string, char c2) {
        throw new UnsupportedOperationException();
    }

    public void setStringCompletionProvider(CompletionProvider completionProvider) {
        this.stringCompletionProvider = completionProvider;
    }

    @Override
    public String getToolTipText(RTextArea rTextArea, MouseEvent mouseEvent) {
        String string = null;
        List<Completion> list = this.getCompletionsAt(rTextArea, mouseEvent.getPoint());
        if (list != null && list.size() > 0) {
            Completion completion = list.get(0);
            string = completion.getToolTipText();
        }
        return string;
    }
}

