/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.fife.ui.autocomplete.AbstractCompletion;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.FunctionCompletion;
import org.fife.ui.autocomplete.MarkupTagCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.VariableCompletion;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CompletionXMLParser
extends DefaultHandler {
    private List<Completion> completions;
    private CompletionProvider provider;
    private ClassLoader completionCL;
    private String name;
    private String type;
    private String returnType;
    private StringBuilder returnValDesc;
    private StringBuilder desc;
    private String paramName;
    private String paramType;
    private StringBuilder paramDesc;
    private List<ParameterizedCompletion.Parameter> params;
    private String definedIn;
    private boolean doingKeywords;
    private boolean inKeyword;
    private boolean gettingReturnValDesc;
    private boolean gettingDesc;
    private boolean gettingParams;
    private boolean inParam;
    private boolean gettingParamDesc;
    private boolean inCompletionTypes;
    private char paramStartChar;
    private char paramEndChar;
    private String paramSeparator;
    private String funcCompletionType;
    private static ClassLoader DEFAULT_COMPLETION_CLASS_LOADER;

    public CompletionXMLParser(CompletionProvider completionProvider) {
        this(completionProvider, null);
    }

    public CompletionXMLParser(CompletionProvider completionProvider, ClassLoader classLoader) {
        this.provider = completionProvider;
        this.completionCL = classLoader;
        if (this.completionCL == null) {
            this.completionCL = DEFAULT_COMPLETION_CLASS_LOADER;
        }
        this.completions = new ArrayList<Completion>();
        this.params = new ArrayList<ParameterizedCompletion.Parameter>(1);
        this.desc = new StringBuilder();
        this.paramDesc = new StringBuilder();
        this.returnValDesc = new StringBuilder();
        this.paramEndChar = '\u0000';
        this.paramStartChar = '\u0000';
        this.paramSeparator = null;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.gettingDesc) {
            this.desc.append(cArray, n, n2);
        } else if (this.gettingParamDesc) {
            this.paramDesc.append(cArray, n, n2);
        } else if (this.gettingReturnValDesc) {
            this.returnValDesc.append(cArray, n, n2);
        }
    }

    private FunctionCompletion createFunctionCompletion() {
        FunctionCompletion functionCompletion = null;
        if (this.funcCompletionType != null) {
            try {
                Class<?> clazz = null;
                clazz = this.completionCL != null ? Class.forName(this.funcCompletionType, true, this.completionCL) : Class.forName(this.funcCompletionType);
                Constructor<?> constructor = clazz.getDeclaredConstructor(CompletionProvider.class, String.class, String.class);
                functionCompletion = (FunctionCompletion)constructor.newInstance(this.provider, this.name, this.returnType);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (functionCompletion == null) {
            functionCompletion = new FunctionCompletion(this.provider, this.name, this.returnType);
        }
        if (this.desc.length() > 0) {
            functionCompletion.setShortDescription(this.desc.toString());
            this.desc.setLength(0);
        }
        functionCompletion.setParams(this.params);
        functionCompletion.setDefinedIn(this.definedIn);
        if (this.returnValDesc.length() > 0) {
            functionCompletion.setReturnValueDescription(this.returnValDesc.toString());
            this.returnValDesc.setLength(0);
        }
        return functionCompletion;
    }

    private BasicCompletion createOtherCompletion() {
        BasicCompletion basicCompletion = new BasicCompletion(this.provider, this.name);
        if (this.desc.length() > 0) {
            basicCompletion.setSummary(this.desc.toString());
            this.desc.setLength(0);
        }
        return basicCompletion;
    }

    private MarkupTagCompletion createMarkupTagCompletion() {
        MarkupTagCompletion markupTagCompletion = new MarkupTagCompletion(this.provider, this.name);
        if (this.desc.length() > 0) {
            markupTagCompletion.setDescription(this.desc.toString());
            this.desc.setLength(0);
        }
        markupTagCompletion.setAttributes(this.params);
        markupTagCompletion.setDefinedIn(this.definedIn);
        return markupTagCompletion;
    }

    private VariableCompletion createVariableCompletion() {
        VariableCompletion variableCompletion = new VariableCompletion(this.provider, this.name, this.returnType);
        if (this.desc.length() > 0) {
            variableCompletion.setShortDescription(this.desc.toString());
            this.desc.setLength(0);
        }
        variableCompletion.setDefinedIn(this.definedIn);
        return variableCompletion;
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if ("keywords".equals(string3)) {
            this.doingKeywords = false;
        } else if (this.doingKeywords) {
            if ("keyword".equals(string3)) {
                AbstractCompletion abstractCompletion = null;
                if ("function".equals(this.type)) {
                    abstractCompletion = this.createFunctionCompletion();
                } else if ("constant".equals(this.type)) {
                    abstractCompletion = this.createVariableCompletion();
                } else if ("tag".equals(this.type)) {
                    abstractCompletion = this.createMarkupTagCompletion();
                } else if ("other".equals(this.type)) {
                    abstractCompletion = this.createOtherCompletion();
                } else {
                    throw new InternalError("Unexpected type: " + this.type);
                }
                this.completions.add(abstractCompletion);
                this.inKeyword = false;
            } else if (this.inKeyword) {
                if ("returnValDesc".equals(string3)) {
                    this.gettingReturnValDesc = false;
                } else if (this.gettingParams) {
                    if ("params".equals(string3)) {
                        this.gettingParams = false;
                    } else if ("param".equals(string3)) {
                        ParameterizedCompletion.Parameter parameter = new ParameterizedCompletion.Parameter(this.paramType, this.paramName);
                        if (this.paramDesc.length() > 0) {
                            parameter.setDescription(this.paramDesc.toString());
                            this.paramDesc.setLength(0);
                        }
                        this.params.add(parameter);
                        this.inParam = false;
                    } else if (this.inParam && "desc".equals(string3)) {
                        this.gettingParamDesc = false;
                    }
                } else if ("desc".equals(string3)) {
                    this.gettingDesc = false;
                }
            }
        } else if (this.inCompletionTypes && "completionTypes".equals(string3)) {
            this.inCompletionTypes = false;
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public List<Completion> getCompletions() {
        return this.completions;
    }

    public char getParamEndChar() {
        return this.paramEndChar;
    }

    public String getParamSeparator() {
        return this.paramSeparator;
    }

    public char getParamStartChar() {
        return this.paramStartChar;
    }

    private static final char getSingleChar(String string) {
        return string.length() == 1 ? string.charAt(0) : (char)'\u0000';
    }

    public void reset(CompletionProvider completionProvider) {
        this.provider = completionProvider;
        this.completions.clear();
        this.gettingParamDesc = false;
        this.inParam = false;
        this.gettingParams = false;
        this.gettingDesc = false;
        this.inKeyword = false;
        this.doingKeywords = false;
        this.paramEndChar = '\u0000';
        this.paramStartChar = '\u0000';
        this.paramSeparator = null;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException {
        return new InputSource(this.getClass().getResourceAsStream("CompletionXml.dtd"));
    }

    public static void setDefaultCompletionClassLoader(ClassLoader classLoader) {
        DEFAULT_COMPLETION_CLASS_LOADER = classLoader;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if ("keywords".equals(string3)) {
            this.doingKeywords = true;
        } else if (this.doingKeywords) {
            if ("keyword".equals(string3)) {
                this.name = attributes.getValue("name");
                this.type = attributes.getValue("type");
                this.returnType = attributes.getValue("returnType");
                this.params.clear();
                this.definedIn = attributes.getValue("definedIn");
                this.inKeyword = true;
            } else if (this.inKeyword) {
                if ("returnValDesc".equals(string3)) {
                    this.gettingReturnValDesc = true;
                } else if ("params".equals(string3)) {
                    this.gettingParams = true;
                } else if (this.gettingParams) {
                    if ("param".equals(string3)) {
                        this.paramName = attributes.getValue("name");
                        this.paramType = attributes.getValue("type");
                        this.inParam = true;
                    }
                    if (this.inParam && "desc".equals(string3)) {
                        this.gettingParamDesc = true;
                    }
                } else if ("desc".equals(string3)) {
                    this.gettingDesc = true;
                }
            }
        } else if ("environment".equals(string3)) {
            this.paramStartChar = CompletionXMLParser.getSingleChar(attributes.getValue("paramStartChar"));
            this.paramEndChar = CompletionXMLParser.getSingleChar(attributes.getValue("paramEndChar"));
            this.paramSeparator = attributes.getValue("paramSeparator");
        } else if ("completionTypes".equals(string3)) {
            this.inCompletionTypes = true;
        } else if (this.inCompletionTypes && "functionCompletionType".equals(string3)) {
            this.funcCompletionType = attributes.getValue("type");
        }
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }
}

