/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterChoicesProvider;
import org.fife.ui.autocomplete.SortByRelevanceComparator;

public abstract class CompletionProviderBase
implements CompletionProvider {
    private CompletionProvider parent;
    private ListCellRenderer listCellRenderer;
    private char paramListStart;
    private char paramListEnd;
    private String paramListSeparator;
    private boolean autoActivateAfterLetters;
    private String autoActivateChars;
    private ParameterChoicesProvider paramChoicesProvider;
    private Segment s = new Segment();
    protected static final String EMPTY_STRING = "";
    private static final Comparator<Completion> sortByRelevanceComparator = new SortByRelevanceComparator();

    @Override
    public void clearParameterizedCompletionParams() {
        this.paramListStart = '\u0000';
        this.paramListEnd = '\u0000';
        this.paramListSeparator = null;
    }

    @Override
    public List<Completion> getCompletions(JTextComponent jTextComponent) {
        List<Completion> list;
        List<Completion> list2 = this.getCompletionsImpl(jTextComponent);
        if (this.parent != null && (list = this.parent.getCompletions(jTextComponent)) != null) {
            list2.addAll(list);
            Collections.sort(list2);
        }
        Collections.sort(list2, sortByRelevanceComparator);
        return list2;
    }

    protected abstract List<Completion> getCompletionsImpl(JTextComponent var1);

    @Override
    public ListCellRenderer getListCellRenderer() {
        return this.listCellRenderer;
    }

    @Override
    public ParameterChoicesProvider getParameterChoicesProvider() {
        return this.paramChoicesProvider;
    }

    @Override
    public char getParameterListEnd() {
        return this.paramListEnd;
    }

    @Override
    public String getParameterListSeparator() {
        return this.paramListSeparator;
    }

    @Override
    public char getParameterListStart() {
        return this.paramListStart;
    }

    @Override
    public CompletionProvider getParent() {
        return this.parent;
    }

    @Override
    public boolean isAutoActivateOkay(JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        char c = '\u0000';
        try {
            document.getText(jTextComponent.getCaretPosition(), 1, this.s);
            c = this.s.first();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return this.autoActivateAfterLetters && Character.isLetter(c) || this.autoActivateChars != null && this.autoActivateChars.indexOf(c) > -1;
    }

    public void setAutoActivationRules(boolean bl, String string) {
        this.autoActivateAfterLetters = bl;
        this.autoActivateChars = string;
    }

    public void setParameterChoicesProvider(ParameterChoicesProvider parameterChoicesProvider) {
        this.paramChoicesProvider = parameterChoicesProvider;
    }

    @Override
    public void setListCellRenderer(ListCellRenderer listCellRenderer) {
        this.listCellRenderer = listCellRenderer;
    }

    @Override
    public void setParameterizedCompletionParams(char c, String string, char c2) {
        if (c < ' ' || c == '\u007f') {
            throw new IllegalArgumentException("Invalid listStart");
        }
        if (c2 < ' ' || c2 == '\u007f') {
            throw new IllegalArgumentException("Invalid listEnd");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid separator");
        }
        this.paramListStart = c;
        this.paramListSeparator = string;
        this.paramListEnd = c2;
    }

    @Override
    public void setParent(CompletionProvider completionProvider) {
        this.parent = completionProvider;
    }
}

