/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.AutoCompletePopupWindow;
import org.fife.ui.autocomplete.AutoCompletionEvent;
import org.fife.ui.autocomplete.AutoCompletionListener;
import org.fife.ui.autocomplete.AutoCompletionStyleContext;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ExternalURLHandler;
import org.fife.ui.autocomplete.LinkRedirector;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionContext;
import org.fife.ui.autocomplete.TemplateCompletion;

public class AutoCompletion {
    private JTextComponent textComponent;
    private Window parentWindow;
    private AutoCompletePopupWindow popupWindow;
    private Dimension preferredChoicesWindowSize;
    private Dimension preferredDescWindowSize;
    private ParameterizedCompletionContext pcc;
    private CompletionProvider provider;
    private ListCellRenderer renderer;
    private ExternalURLHandler externalURLHandler;
    private static LinkRedirector linkRedirector;
    private boolean showDescWindow;
    private boolean autoCompleteEnabled;
    private boolean autoActivationEnabled;
    private boolean autoCompleteSingleChoices;
    private boolean parameterAssistanceEnabled;
    private ListCellRenderer paramChoicesRenderer;
    private KeyStroke trigger;
    private Object oldTriggerKey;
    private Action oldTriggerAction;
    private Object oldParenKey;
    private Action oldParenAction;
    private ParentWindowListener parentWindowListener;
    private TextComponentListener textComponentListener;
    private AutoActivationListener autoActivationListener;
    private LookAndFeelChangeListener lafListener;
    private PopupWindowListener popupWindowListener;
    private EventListenerList listeners;
    private boolean hideOnNoText;
    private boolean hideOnCompletionProviderChange;
    private static final String PARAM_TRIGGER_KEY = "AutoComplete";
    private static final String PARAM_COMPLETE_KEY = "AutoCompletion.FunctionStart";
    private static final AutoCompletionStyleContext styleContext;
    private static final boolean DEBUG;

    static {
        styleContext = new AutoCompletionStyleContext();
        DEBUG = AutoCompletion.initDebug();
    }

    public AutoCompletion(CompletionProvider completionProvider) {
        this.setChoicesWindowSize(350, 200);
        this.setDescriptionWindowSize(350, 250);
        this.setCompletionProvider(completionProvider);
        this.setTriggerKey(AutoCompletion.getDefaultTriggerKey());
        this.setAutoCompleteEnabled(true);
        this.setAutoCompleteSingleChoices(true);
        this.setAutoActivationEnabled(false);
        this.setShowDescWindow(false);
        this.setHideOnCompletionProviderChange(true);
        this.setHideOnNoText(true);
        this.parentWindowListener = new ParentWindowListener();
        this.textComponentListener = new TextComponentListener();
        this.autoActivationListener = new AutoActivationListener();
        this.lafListener = new LookAndFeelChangeListener();
        this.popupWindowListener = new PopupWindowListener();
        this.listeners = new EventListenerList();
    }

    public void addAutoCompletionListener(AutoCompletionListener autoCompletionListener) {
        this.listeners.add(AutoCompletionListener.class, autoCompletionListener);
    }

    public void doCompletion() {
        this.refreshPopupWindow();
    }

    protected void fireAutoCompletionEvent(AutoCompletionEvent.Type type) {
        Object[] objectArray = this.listeners.getListenerList();
        AutoCompletionEvent autoCompletionEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == AutoCompletionListener.class) {
                if (autoCompletionEvent == null) {
                    autoCompletionEvent = new AutoCompletionEvent(this, type);
                }
                ((AutoCompletionListener)objectArray[n + 1]).autoCompleteUpdate(autoCompletionEvent);
            }
            n -= 2;
        }
    }

    public int getAutoActivationDelay() {
        return this.autoActivationListener.timer.getDelay();
    }

    public boolean getAutoCompleteSingleChoices() {
        return this.autoCompleteSingleChoices;
    }

    public CompletionProvider getCompletionProvider() {
        return this.provider;
    }

    static boolean getDebug() {
        return DEBUG;
    }

    public static KeyStroke getDefaultTriggerKey() {
        int n = 2;
        return KeyStroke.getKeyStroke(32, n);
    }

    public ExternalURLHandler getExternalURLHandler() {
        return this.externalURLHandler;
    }

    int getLineOfCaret() {
        Document document = this.textComponent.getDocument();
        Element element = document.getDefaultRootElement();
        return element.getElementIndex(this.textComponent.getCaretPosition());
    }

    public static LinkRedirector getLinkRedirector() {
        return linkRedirector;
    }

    public ListCellRenderer getListCellRenderer() {
        return this.renderer;
    }

    public ListCellRenderer getParamChoicesRenderer() {
        return this.paramChoicesRenderer;
    }

    protected String getReplacementText(Completion completion, Document document, int n, int n2) {
        return completion.getReplacementText();
    }

    public boolean getShowDescWindow() {
        return this.showDescWindow;
    }

    public static AutoCompletionStyleContext getStyleContext() {
        return styleContext;
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    ComponentOrientation getTextComponentOrientation() {
        return this.textComponent == null ? null : this.textComponent.getComponentOrientation();
    }

    public KeyStroke getTriggerKey() {
        return this.trigger;
    }

    public boolean hideChildWindows() {
        boolean bl = this.hidePopupWindow();
        return bl |= this.hideParameterCompletionPopups();
    }

    private boolean hideParameterCompletionPopups() {
        if (this.pcc != null) {
            this.pcc.deactivate();
            this.pcc = null;
            return true;
        }
        return false;
    }

    protected boolean hidePopupWindow() {
        if (this.popupWindow != null && this.popupWindow.isVisible()) {
            this.setPopupVisible(false);
            return true;
        }
        return false;
    }

    private static final boolean initDebug() {
        boolean bl = false;
        try {
            bl = Boolean.getBoolean("AutoCompletion.debug");
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        return bl;
    }

    protected final void insertCompletion(Completion completion) {
        this.insertCompletion(completion, false);
    }

    protected void insertCompletion(Completion completion, boolean bl) {
        JTextComponent jTextComponent = this.getTextComponent();
        String string = completion.getAlreadyEntered(jTextComponent);
        this.hidePopupWindow();
        Caret caret = jTextComponent.getCaret();
        int n = caret.getDot();
        int n2 = string.length();
        int n3 = n - n2;
        String string2 = this.getReplacementText(completion, jTextComponent.getDocument(), n3, n2);
        caret.setDot(n3);
        caret.moveDot(n);
        jTextComponent.replaceSelection(string2);
        if (this.isParameterAssistanceEnabled() && completion instanceof ParameterizedCompletion) {
            ParameterizedCompletion parameterizedCompletion = (ParameterizedCompletion)completion;
            this.startParameterizedCompletionAssistance(parameterizedCompletion, bl);
        }
    }

    public void install(JTextComponent jTextComponent) {
        if (this.textComponent != null) {
            this.uninstall();
        }
        this.textComponent = jTextComponent;
        this.installTriggerKey(this.getTriggerKey());
        char c = this.provider.getParameterListStart();
        if (c != '\u0000' && c != ' ') {
            InputMap inputMap = jTextComponent.getInputMap();
            ActionMap actionMap = jTextComponent.getActionMap();
            KeyStroke keyStroke = KeyStroke.getKeyStroke(c);
            this.oldParenKey = inputMap.get(keyStroke);
            inputMap.put(keyStroke, PARAM_COMPLETE_KEY);
            this.oldParenAction = actionMap.get(PARAM_COMPLETE_KEY);
            actionMap.put(PARAM_COMPLETE_KEY, new ParameterizedCompletionStartAction(c));
        }
        this.textComponentListener.addTo(this.textComponent);
        this.textComponentListener.hierarchyChanged(null);
        if (this.isAutoActivationEnabled()) {
            this.autoActivationListener.addTo(this.textComponent);
        }
        UIManager.addPropertyChangeListener(this.lafListener);
        this.updateUI();
    }

    private void installTriggerKey(KeyStroke keyStroke) {
        InputMap inputMap = this.textComponent.getInputMap();
        this.oldTriggerKey = inputMap.get(keyStroke);
        inputMap.put(keyStroke, PARAM_TRIGGER_KEY);
        ActionMap actionMap = this.textComponent.getActionMap();
        this.oldTriggerAction = actionMap.get(PARAM_TRIGGER_KEY);
        actionMap.put(PARAM_TRIGGER_KEY, this.createAutoCompleteAction());
    }

    protected Action createAutoCompleteAction() {
        return new AutoCompleteAction();
    }

    public boolean isAutoActivationEnabled() {
        return this.autoActivationEnabled;
    }

    public boolean isAutoCompleteEnabled() {
        return this.autoCompleteEnabled;
    }

    protected boolean isHideOnCompletionProviderChange() {
        return this.hideOnCompletionProviderChange;
    }

    protected boolean isHideOnNoText() {
        return this.hideOnNoText;
    }

    public boolean isParameterAssistanceEnabled() {
        return this.parameterAssistanceEnabled;
    }

    public boolean isPopupVisible() {
        return this.popupWindow != null && this.popupWindow.isVisible();
    }

    protected int refreshPopupWindow() {
        int n;
        int n2;
        String string = this.provider.getAlreadyEnteredText(this.textComponent);
        if (string == null && !this.isPopupVisible()) {
            return this.getLineOfCaret();
        }
        int n3 = n2 = string == null ? 0 : string.length();
        if (n2 == 0 && this.isHideOnNoText() && this.isPopupVisible()) {
            this.hidePopupWindow();
            return this.getLineOfCaret();
        }
        final List<Completion> list = this.provider.getCompletions(this.textComponent);
        int n4 = n = list == null ? 0 : list.size();
        if (n > 1 || n == 1 && (this.isPopupVisible() || n2 == 0) || n == 1 && !this.getAutoCompleteSingleChoices()) {
            if (this.popupWindow == null) {
                this.popupWindow = new AutoCompletePopupWindow(this.parentWindow, this);
                this.popupWindowListener.install(this.popupWindow);
                this.popupWindow.applyComponentOrientation(this.getTextComponentOrientation());
                if (this.renderer != null) {
                    this.popupWindow.setListCellRenderer(this.renderer);
                }
                if (this.preferredChoicesWindowSize != null) {
                    this.popupWindow.setSize(this.preferredChoicesWindowSize);
                }
                if (this.preferredDescWindowSize != null) {
                    this.popupWindow.setDescriptionWindowSize(this.preferredDescWindowSize);
                }
            }
            this.popupWindow.setCompletions(list);
            if (!this.popupWindow.isVisible()) {
                Rectangle rectangle = null;
                try {
                    rectangle = this.textComponent.modelToView(this.textComponent.getCaretPosition());
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    return -1;
                }
                Point point = new Point(rectangle.x, rectangle.y);
                SwingUtilities.convertPointToScreen(point, this.textComponent);
                rectangle.x = point.x;
                rectangle.y = point.y;
                this.popupWindow.setLocationRelativeTo(rectangle);
                this.setPopupVisible(true);
            }
        } else if (n == 1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AutoCompletion.this.insertCompletion((Completion)list.get(0));
                }
            });
        } else {
            this.hidePopupWindow();
        }
        return this.getLineOfCaret();
    }

    public void removeAutoCompletionListener(AutoCompletionListener autoCompletionListener) {
        this.listeners.remove(AutoCompletionListener.class, autoCompletionListener);
    }

    public void setAutoActivationDelay(int n) {
        n = Math.max(0, n);
        this.autoActivationListener.timer.stop();
        this.autoActivationListener.timer.setInitialDelay(n);
    }

    public void setAutoActivationEnabled(boolean bl) {
        if (bl != this.autoActivationEnabled) {
            this.autoActivationEnabled = bl;
            if (this.textComponent != null) {
                if (this.autoActivationEnabled) {
                    this.autoActivationListener.addTo(this.textComponent);
                } else {
                    this.autoActivationListener.removeFrom(this.textComponent);
                }
            }
        }
    }

    public void setAutoCompleteEnabled(boolean bl) {
        if (bl != this.autoCompleteEnabled) {
            this.autoCompleteEnabled = bl;
            this.hidePopupWindow();
        }
    }

    public void setAutoCompleteSingleChoices(boolean bl) {
        this.autoCompleteSingleChoices = bl;
    }

    public void setCompletionProvider(CompletionProvider completionProvider) {
        if (completionProvider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        this.provider = completionProvider;
        if (this.isHideOnCompletionProviderChange()) {
            this.hidePopupWindow();
        }
    }

    public void setChoicesWindowSize(int n, int n2) {
        this.preferredChoicesWindowSize = new Dimension(n, n2);
        if (this.popupWindow != null) {
            this.popupWindow.setSize(this.preferredChoicesWindowSize);
        }
    }

    public void setDescriptionWindowSize(int n, int n2) {
        this.preferredDescWindowSize = new Dimension(n, n2);
        if (this.popupWindow != null) {
            this.popupWindow.setDescriptionWindowSize(this.preferredDescWindowSize);
        }
    }

    public void setExternalURLHandler(ExternalURLHandler externalURLHandler) {
        this.externalURLHandler = externalURLHandler;
    }

    protected void setHideOnCompletionProviderChange(boolean bl) {
        this.hideOnCompletionProviderChange = bl;
    }

    protected void setHideOnNoText(boolean bl) {
        this.hideOnNoText = bl;
    }

    public static void setLinkRedirector(LinkRedirector linkRedirector) {
        AutoCompletion.linkRedirector = linkRedirector;
    }

    public void setListCellRenderer(ListCellRenderer listCellRenderer) {
        this.renderer = listCellRenderer;
        if (this.popupWindow != null) {
            this.popupWindow.setListCellRenderer(listCellRenderer);
            this.hidePopupWindow();
        }
    }

    public void setParamChoicesRenderer(ListCellRenderer listCellRenderer) {
        this.paramChoicesRenderer = listCellRenderer;
    }

    public void setParameterAssistanceEnabled(boolean bl) {
        this.parameterAssistanceEnabled = bl;
    }

    protected void setPopupVisible(boolean bl) {
        if (bl != this.popupWindow.isVisible()) {
            this.popupWindow.setVisible(bl);
        }
    }

    public void setShowDescWindow(boolean bl) {
        this.hidePopupWindow();
        this.showDescWindow = bl;
    }

    public void setTriggerKey(KeyStroke keyStroke) {
        if (keyStroke == null) {
            throw new IllegalArgumentException("trigger key cannot be null");
        }
        if (!keyStroke.equals(this.trigger)) {
            if (this.textComponent != null) {
                this.uninstallTriggerKey();
                this.installTriggerKey(keyStroke);
            }
            this.trigger = keyStroke;
        }
    }

    private void startParameterizedCompletionAssistance(ParameterizedCompletion parameterizedCompletion, boolean bl) {
        this.hideParameterCompletionPopups();
        if (parameterizedCompletion.getParamCount() == 0 && !(parameterizedCompletion instanceof TemplateCompletion)) {
            String string;
            CompletionProvider completionProvider = parameterizedCompletion.getProvider();
            char c = completionProvider.getParameterListEnd();
            String string2 = string = c == '\u0000' ? "" : Character.toString(c);
            if (bl) {
                String string3 = "${}" + string + "${cursor}";
                this.textComponent.replaceSelection(Character.toString(completionProvider.getParameterListStart()));
                TemplateCompletion templateCompletion = new TemplateCompletion(completionProvider, null, null, string3);
                parameterizedCompletion = templateCompletion;
            } else {
                string = String.valueOf(completionProvider.getParameterListStart()) + string;
                this.textComponent.replaceSelection(string);
                return;
            }
        }
        this.pcc = new ParameterizedCompletionContext(this.parentWindow, this, parameterizedCompletion);
        this.pcc.activate();
    }

    public void uninstall() {
        if (this.textComponent != null) {
            this.hidePopupWindow();
            this.uninstallTriggerKey();
            char c = this.provider.getParameterListStart();
            if (c != '\u0000') {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(c);
                InputMap inputMap = this.textComponent.getInputMap();
                inputMap.put(keyStroke, this.oldParenKey);
                ActionMap actionMap = this.textComponent.getActionMap();
                actionMap.put(PARAM_COMPLETE_KEY, this.oldParenAction);
            }
            this.textComponentListener.removeFrom(this.textComponent);
            if (this.parentWindow != null) {
                this.parentWindowListener.removeFrom(this.parentWindow);
            }
            if (this.isAutoActivationEnabled()) {
                this.autoActivationListener.removeFrom(this.textComponent);
            }
            UIManager.removePropertyChangeListener(this.lafListener);
            this.textComponent = null;
            this.popupWindowListener.uninstall(this.popupWindow);
            this.popupWindow = null;
        }
    }

    private void uninstallTriggerKey() {
        InputMap inputMap = this.textComponent.getInputMap();
        inputMap.put(this.trigger, this.oldTriggerKey);
        ActionMap actionMap = this.textComponent.getActionMap();
        actionMap.put(PARAM_TRIGGER_KEY, this.oldTriggerAction);
    }

    private void updateUI() {
        if (this.popupWindow != null) {
            this.popupWindow.updateUI();
        }
        if (this.pcc != null) {
            this.pcc.updateUI();
        }
        if (this.paramChoicesRenderer instanceof JComponent) {
            ((JComponent)((Object)this.paramChoicesRenderer)).updateUI();
        }
    }

    private class AutoActivationListener
    extends FocusAdapter
    implements DocumentListener,
    CaretListener,
    ActionListener {
        private Timer timer = new Timer(200, this);
        private boolean justInserted;

        public AutoActivationListener() {
            this.timer.setRepeats(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AutoCompletion.this.doCompletion();
        }

        public void addTo(JTextComponent jTextComponent) {
            jTextComponent.addFocusListener(this);
            jTextComponent.getDocument().addDocumentListener(this);
            jTextComponent.addCaretListener(this);
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            if (this.justInserted) {
                this.justInserted = false;
            } else {
                this.timer.stop();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.timer.stop();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.justInserted = false;
            if (AutoCompletion.this.isAutoCompleteEnabled() && AutoCompletion.this.isAutoActivationEnabled() && documentEvent.getLength() == 1) {
                if (AutoCompletion.this.provider.isAutoActivateOkay(AutoCompletion.this.textComponent)) {
                    this.timer.restart();
                    this.justInserted = true;
                } else {
                    this.timer.stop();
                }
            } else {
                this.timer.stop();
            }
        }

        public void removeFrom(JTextComponent jTextComponent) {
            jTextComponent.removeFocusListener(this);
            jTextComponent.getDocument().removeDocumentListener(this);
            jTextComponent.removeCaretListener(this);
            this.timer.stop();
            this.justInserted = false;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.timer.stop();
        }
    }

    protected class AutoCompleteAction
    extends AbstractAction {
        protected AutoCompleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompletion.this.isAutoCompleteEnabled()) {
                AutoCompletion.this.refreshPopupWindow();
            } else if (AutoCompletion.this.oldTriggerAction != null) {
                AutoCompletion.this.oldTriggerAction.actionPerformed(actionEvent);
            }
        }
    }

    private class LookAndFeelChangeListener
    implements PropertyChangeListener {
        private LookAndFeelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("lookAndFeel".equals(string)) {
                AutoCompletion.this.updateUI();
            }
        }
    }

    private class ParameterizedCompletionStartAction
    extends AbstractAction {
        private String start;

        public ParameterizedCompletionStartAction(char c) {
            this.start = Character.toString(c);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = AutoCompletion.this.hidePopupWindow();
            if (!bl || !AutoCompletion.this.isParameterAssistanceEnabled()) {
                AutoCompletion.this.textComponent.replaceSelection(this.start);
                return;
            }
            Completion completion = AutoCompletion.this.popupWindow.getSelection();
            if (completion instanceof ParameterizedCompletion) {
                AutoCompletion.this.insertCompletion(completion, true);
            }
        }
    }

    private class ParentWindowListener
    extends ComponentAdapter
    implements WindowFocusListener {
        private ParentWindowListener() {
        }

        public void addTo(Window window) {
            window.addComponentListener(this);
            window.addWindowFocusListener(this);
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            AutoCompletion.this.hideChildWindows();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            AutoCompletion.this.hideChildWindows();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            AutoCompletion.this.hideChildWindows();
        }

        public void removeFrom(Window window) {
            window.removeComponentListener(this);
            window.removeWindowFocusListener(this);
        }

        @Override
        public void windowGainedFocus(WindowEvent windowEvent) {
        }

        @Override
        public void windowLostFocus(WindowEvent windowEvent) {
            AutoCompletion.this.hideChildWindows();
        }
    }

    private class PopupWindowListener
    extends ComponentAdapter {
        private PopupWindowListener() {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            AutoCompletion.this.fireAutoCompletionEvent(AutoCompletionEvent.Type.POPUP_HIDDEN);
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            AutoCompletion.this.fireAutoCompletionEvent(AutoCompletionEvent.Type.POPUP_SHOWN);
        }

        public void install(AutoCompletePopupWindow autoCompletePopupWindow) {
            autoCompletePopupWindow.addComponentListener(this);
        }

        public void uninstall(AutoCompletePopupWindow autoCompletePopupWindow) {
            if (autoCompletePopupWindow != null) {
                autoCompletePopupWindow.removeComponentListener(this);
            }
        }
    }

    private class TextComponentListener
    extends FocusAdapter
    implements HierarchyListener {
        private TextComponentListener() {
        }

        void addTo(JTextComponent jTextComponent) {
            jTextComponent.addFocusListener(this);
            jTextComponent.addHierarchyListener(this);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            AutoCompletion.this.hideChildWindows();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            Window window = AutoCompletion.this.parentWindow;
            AutoCompletion.this.parentWindow = SwingUtilities.getWindowAncestor(AutoCompletion.this.textComponent);
            if (AutoCompletion.this.parentWindow != window) {
                if (window != null) {
                    AutoCompletion.this.parentWindowListener.removeFrom(window);
                }
                if (AutoCompletion.this.parentWindow != null) {
                    AutoCompletion.this.parentWindowListener.addTo(AutoCompletion.this.parentWindow);
                }
            }
        }

        public void removeFrom(JTextComponent jTextComponent) {
            jTextComponent.removeFocusListener(this);
            jTextComponent.removeHierarchyListener(this);
        }
    }
}

