/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.xml.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.net.URL;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.fife.rsta.ac.xml.tree.XmlTreeNode;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

class XmlTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Icon elemIcon;
    private String elem;
    private String attr;
    private boolean selected;
    private static final XmlTreeCellUI UI = new XmlTreeCellUI();
    private static final Color ATTR_COLOR = new Color(0x808080);

    public XmlTreeCellRenderer() {
        URL uRL = this.getClass().getResource("tag.png");
        if (uRL != null) {
            this.elemIcon = new ImageIcon(uRL);
        }
        this.setUI(UI);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        this.selected = bl;
        if (object instanceof XmlTreeNode) {
            XmlTreeNode xmlTreeNode = (XmlTreeNode)object;
            this.elem = xmlTreeNode.getElement();
            this.attr = xmlTreeNode.getMainAttr();
        } else {
            this.attr = null;
            this.elem = null;
        }
        this.setIcon(this.elemIcon);
        return this;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setUI(UI);
    }

    private static class XmlTreeCellUI
    extends BasicLabelUI {
        private XmlTreeCellUI() {
        }

        @Override
        protected void installDefaults(JLabel jLabel) {
        }

        @Override
        protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
            XmlTreeCellRenderer xmlTreeCellRenderer = (XmlTreeCellRenderer)jLabel;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Map<?, ?> map = RSyntaxUtilities.getDesktopAntiAliasHints();
            if (map != null) {
                graphics2D.addRenderingHints(map);
            }
            graphics2D.setColor(jLabel.getForeground());
            graphics2D.drawString(xmlTreeCellRenderer.elem, n, n2);
            if (xmlTreeCellRenderer.attr != null) {
                n += graphics2D.getFontMetrics().stringWidth(String.valueOf(xmlTreeCellRenderer.elem) + " ");
                if (!xmlTreeCellRenderer.selected) {
                    graphics2D.setColor(ATTR_COLOR);
                }
                graphics2D.drawString(xmlTreeCellRenderer.attr, n, n2);
            }
            graphics2D.dispose();
        }

        @Override
        protected void uninstallDefaults(JLabel jLabel) {
        }
    }
}

