/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.xml.tree;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.fife.rsta.ac.AbstractSourceTree;
import org.fife.rsta.ac.LanguageSupport;
import org.fife.rsta.ac.LanguageSupportFactory;
import org.fife.rsta.ac.xml.XmlLanguageSupport;
import org.fife.rsta.ac.xml.XmlParser;
import org.fife.rsta.ac.xml.tree.XmlTreeCellRenderer;
import org.fife.rsta.ac.xml.tree.XmlTreeNode;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

public class XmlOutlineTree
extends AbstractSourceTree {
    private XmlParser parser;
    private XmlEditorListener listener;
    private DefaultTreeModel model;
    private XmlTreeCellRenderer xmlTreeCellRenderer;

    public XmlOutlineTree() {
        this(false);
    }

    public XmlOutlineTree(boolean bl) {
        this.setSorted(bl);
        this.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.setRootVisible(false);
        this.xmlTreeCellRenderer = new XmlTreeCellRenderer();
        this.setCellRenderer(this.xmlTreeCellRenderer);
        this.model = new DefaultTreeModel(new XmlTreeNode("Nothing"));
        this.setModel(this.model);
        this.listener = new XmlEditorListener();
        this.addTreeSelectionListener(this.listener);
    }

    private void checkForXmlParsing() {
        if (this.parser != null) {
            this.parser.removePropertyChangeListener("XmlAST", this.listener);
            this.parser = null;
        }
        LanguageSupportFactory languageSupportFactory = LanguageSupportFactory.get();
        LanguageSupport languageSupport = languageSupportFactory.getSupportFor("text/xml");
        XmlLanguageSupport xmlLanguageSupport = (XmlLanguageSupport)languageSupport;
        this.parser = xmlLanguageSupport.getParser(this.textArea);
        if (this.parser != null) {
            this.parser.addPropertyChangeListener("XmlAST", this.listener);
            XmlTreeNode xmlTreeNode = this.parser.getAst();
            this.update(xmlTreeNode);
        } else {
            this.update((XmlTreeNode)null);
        }
    }

    @Override
    public void expandInitialNodes() {
        this.fastExpandAll(new TreePath(this.getModel().getRoot()), true);
    }

    private void gotoElementAtPath(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        if (object instanceof XmlTreeNode) {
            XmlTreeNode xmlTreeNode = (XmlTreeNode)object;
            DocumentRange documentRange = new DocumentRange(xmlTreeNode.getStartOffset(), xmlTreeNode.getEndOffset());
            RSyntaxUtilities.selectAndPossiblyCenter(this.textArea, documentRange, true);
        }
    }

    @Override
    public boolean gotoSelectedElement() {
        TreePath treePath = this.getLeadSelectionPath();
        if (treePath != null) {
            this.gotoElementAtPath(treePath);
            return true;
        }
        return false;
    }

    @Override
    public void listenTo(RSyntaxTextArea rSyntaxTextArea) {
        if (this.textArea != null) {
            this.uninstall();
        }
        if (rSyntaxTextArea == null) {
            return;
        }
        this.textArea = rSyntaxTextArea;
        rSyntaxTextArea.addPropertyChangeListener("RSTA.syntaxStyle", this.listener);
        this.checkForXmlParsing();
    }

    @Override
    public void uninstall() {
        if (this.parser != null) {
            this.parser.removePropertyChangeListener("XmlAST", this.listener);
            this.parser = null;
        }
        if (this.textArea != null) {
            this.textArea.removePropertyChangeListener("RSTA.syntaxStyle", this.listener);
            this.textArea = null;
        }
    }

    private void update(XmlTreeNode xmlTreeNode) {
        if (xmlTreeNode != null) {
            xmlTreeNode = (XmlTreeNode)xmlTreeNode.cloneWithChildren();
        }
        this.model.setRoot(xmlTreeNode);
        if (xmlTreeNode != null) {
            xmlTreeNode.setSorted(this.isSorted());
        }
        this.refresh();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.xmlTreeCellRenderer = new XmlTreeCellRenderer();
        this.setCellRenderer(this.xmlTreeCellRenderer);
    }

    private class XmlEditorListener
    implements PropertyChangeListener,
    TreeSelectionListener {
        private XmlEditorListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("RSTA.syntaxStyle".equals(string)) {
                XmlOutlineTree.this.checkForXmlParsing();
            } else if ("XmlAST".equals(string)) {
                XmlTreeNode xmlTreeNode = (XmlTreeNode)propertyChangeEvent.getNewValue();
                XmlOutlineTree.this.update(xmlTreeNode);
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath;
            if (XmlOutlineTree.this.getGotoSelectedElementOnClick() && (treePath = treeSelectionEvent.getNewLeadSelectionPath()) != null) {
                XmlOutlineTree.this.gotoElementAtPath(treePath);
            }
        }
    }
}

