/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.xml;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fife.io.DocumentReader;
import org.fife.rsta.ac.xml.ValidationConfig;
import org.fife.rsta.ac.xml.ValidationConfigSniffer;
import org.fife.rsta.ac.xml.XmlLanguageSupport;
import org.fife.rsta.ac.xml.tree.XmlTreeNode;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser
extends AbstractParser {
    public static final String PROPERTY_AST = "XmlAST";
    private XmlLanguageSupport xls;
    private PropertyChangeSupport support;
    private XmlTreeNode curElem;
    private XmlTreeNode root;
    private Locator locator;
    private SAXParserFactory spf;
    private SAXParser sp;
    private ValidationConfig validationConfig;

    public XmlParser(XmlLanguageSupport xmlLanguageSupport) {
        this.xls = xmlLanguageSupport;
        this.support = new PropertyChangeSupport(this);
        try {
            this.spf = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(string, propertyChangeListener);
    }

    public XmlTreeNode getAst() {
        return this.root;
    }

    private String getMainAttribute(Attributes attributes) {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < attributes.getLength()) {
            String string = attributes.getLocalName(n3);
            if ("id".equals(string)) {
                n2 = n3;
                break;
            }
            if ("name".equals(string)) {
                n = n3;
            }
            ++n3;
        }
        n3 = n2;
        if (n3 == -1 && (n3 = n) == -1) {
            n3 = 0;
        }
        return String.valueOf(attributes.getLocalName(n3)) + "=" + attributes.getValue(n3);
    }

    public SAXParserFactory getSaxParserFactory() {
        return this.spf;
    }

    @Override
    public ParseResult parse(RSyntaxDocument rSyntaxDocument, String string) {
        new ValidationConfigSniffer().sniff(rSyntaxDocument);
        DefaultParseResult defaultParseResult = new DefaultParseResult(this);
        this.curElem = this.root = new XmlTreeNode("Root");
        if (this.spf == null || rSyntaxDocument.getLength() == 0) {
            return defaultParseResult;
        }
        try {
            if (this.sp == null) {
                this.sp = this.spf.newSAXParser();
            }
            Handler handler = new Handler(rSyntaxDocument, defaultParseResult);
            if (this.validationConfig != null) {
                this.validationConfig.configureHandler(handler);
            }
            DocumentReader documentReader = new DocumentReader(rSyntaxDocument);
            InputSource inputSource = new InputSource(documentReader);
            this.sp.parse(inputSource, (DefaultHandler)handler);
            documentReader.close();
        }
        catch (Exception exception) {}
        if (this.locator != null) {
            try {
                this.root.setStartOffset(rSyntaxDocument.createPosition(0));
                this.root.setEndOffset(rSyntaxDocument.createPosition(rSyntaxDocument.getLength()));
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        this.support.firePropertyChange(PROPERTY_AST, null, this.root);
        return defaultParseResult;
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void setValidationConfig(ValidationConfig validationConfig) {
        this.validationConfig = validationConfig;
        if (this.validationConfig != null) {
            this.validationConfig.configureParser(this);
        }
        this.sp = null;
    }

    public class Handler
    extends DefaultHandler {
        private DefaultParseResult result;
        private RSyntaxDocument doc;
        private Segment s;
        private EntityResolver entityResolver;

        public Handler(RSyntaxDocument rSyntaxDocument, DefaultParseResult defaultParseResult) {
            this.doc = rSyntaxDocument;
            this.result = defaultParseResult;
            this.s = new Segment();
        }

        private void doError(SAXParseException sAXParseException, ParserNotice.Level level) {
            if (!XmlParser.this.xls.getShowSyntaxErrors()) {
                return;
            }
            int n = sAXParseException.getLineNumber() - 1;
            Element element = this.doc.getDefaultRootElement();
            Element element2 = element.getElement(n);
            int n2 = element2.getStartOffset();
            int n3 = element2.getEndOffset() - n2;
            if (n == element.getElementCount() - 1) {
                ++n3;
            }
            DefaultParserNotice defaultParserNotice = new DefaultParserNotice(XmlParser.this, sAXParseException.getMessage(), n, n2, n3);
            defaultParserNotice.setLevel(level);
            this.result.addNotice(defaultParserNotice);
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            XmlParser.this.curElem = (XmlTreeNode)XmlParser.this.curElem.getParent();
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            this.doError(sAXParseException, ParserNotice.Level.ERROR);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.doError(sAXParseException, ParserNotice.Level.ERROR);
        }

        private int getTagStart(int n) {
            Element element = this.doc.getDefaultRootElement();
            int n2 = element.getElementIndex(n);
            Element element2 = element.getElement(n2);
            int n3 = element2.getStartOffset();
            int n4 = -1;
            try {
                while (n2 >= 0) {
                    this.doc.getText(n3, n - n3, this.s);
                    int n5 = this.s.offset + this.s.count - 1;
                    while (n5 >= this.s.offset) {
                        char c = this.s.array[n5];
                        if (c == '<') {
                            return n4;
                        }
                        if (Character.isLetterOrDigit(c)) {
                            n4 = n3 + n5 - this.s.offset;
                        }
                        --n5;
                    }
                    if (--n2 < 0) continue;
                    element2 = element.getElement(n2);
                    n3 = element2.getStartOffset();
                    n = element2.getEndOffset();
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            return -1;
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
            if (this.entityResolver != null) {
                return this.entityResolver.resolveEntity(string, string2);
            }
            return new InputSource(new StringReader(" "));
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            XmlParser.this.locator = locator;
        }

        public void setEntityResolver(EntityResolver entityResolver) {
            this.entityResolver = entityResolver;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            int n;
            XmlTreeNode xmlTreeNode = new XmlTreeNode(string3);
            if (attributes.getLength() > 0) {
                xmlTreeNode.setMainAttribute(XmlParser.this.getMainAttribute(attributes));
            }
            if (XmlParser.this.locator != null && (n = XmlParser.this.locator.getLineNumber()) != -1) {
                int n2 = this.doc.getDefaultRootElement().getElement(n - 1).getStartOffset();
                int n3 = XmlParser.this.locator.getColumnNumber();
                if (n3 != -1) {
                    n2 += n3 - 1;
                }
                n2 = this.getTagStart(n2);
                try {
                    xmlTreeNode.setStartOffset(this.doc.createPosition(n2));
                    int n4 = n2 + string3.length();
                    xmlTreeNode.setEndOffset(this.doc.createPosition(n4));
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            XmlParser.this.curElem.add(xmlTreeNode);
            XmlParser.this.curElem = xmlTreeNode;
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.doError(sAXParseException, ParserNotice.Level.WARNING);
        }
    }
}

