/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.xml;

import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.fife.rsta.ac.AbstractMarkupLanguageSupport;
import org.fife.rsta.ac.GoToMemberAction;
import org.fife.rsta.ac.html.HtmlCellRenderer;
import org.fife.rsta.ac.xml.XmlCompletionProvider;
import org.fife.rsta.ac.xml.XmlParser;
import org.fife.rsta.ac.xml.tree.XmlOutlineTree;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class XmlLanguageSupport
extends AbstractMarkupLanguageSupport {
    private XmlCompletionProvider provider;
    private boolean showSyntaxErrors;

    public XmlLanguageSupport() {
        this.setAutoActivationEnabled(true);
        this.setParameterAssistanceEnabled(false);
        this.setShowDescWindow(false);
        this.setShowSyntaxErrors(true);
    }

    @Override
    protected ListCellRenderer createDefaultCompletionCellRenderer() {
        return new HtmlCellRenderer();
    }

    private XmlCompletionProvider getProvider() {
        if (this.provider == null) {
            this.provider = new XmlCompletionProvider();
        }
        return this.provider;
    }

    public XmlParser getParser(RSyntaxTextArea rSyntaxTextArea) {
        Object object = rSyntaxTextArea.getClientProperty("org.fife.rsta.ac.LanguageSupport.LanguageParser");
        if (object instanceof XmlParser) {
            return (XmlParser)object;
        }
        return null;
    }

    public boolean getShowSyntaxErrors() {
        return this.showSyntaxErrors;
    }

    @Override
    public void install(RSyntaxTextArea rSyntaxTextArea) {
        XmlCompletionProvider xmlCompletionProvider = this.getProvider();
        AutoCompletion autoCompletion = this.createAutoCompletion(xmlCompletionProvider);
        autoCompletion.install(rSyntaxTextArea);
        this.installImpl(rSyntaxTextArea, autoCompletion);
        XmlParser xmlParser = new XmlParser(this);
        rSyntaxTextArea.addParser(xmlParser);
        rSyntaxTextArea.putClientProperty("org.fife.rsta.ac.LanguageSupport.LanguageParser", xmlParser);
        this.installKeyboardShortcuts(rSyntaxTextArea);
    }

    @Override
    protected void installKeyboardShortcuts(RSyntaxTextArea rSyntaxTextArea) {
        super.installKeyboardShortcuts(rSyntaxTextArea);
        InputMap inputMap = rSyntaxTextArea.getInputMap();
        ActionMap actionMap = rSyntaxTextArea.getActionMap();
        int n = rSyntaxTextArea.getToolkit().getMenuShortcutKeyMask();
        int n2 = 1;
        inputMap.put(KeyStroke.getKeyStroke(79, n | n2), "GoToType");
        actionMap.put("GoToType", new GoToMemberAction(XmlOutlineTree.class));
    }

    public void setShowSyntaxErrors(boolean bl) {
        this.showSyntaxErrors = bl;
    }

    @Override
    protected boolean shouldAutoCloseTag(String string) {
        return true;
    }

    @Override
    public void uninstall(RSyntaxTextArea rSyntaxTextArea) {
        this.uninstallImpl(rSyntaxTextArea);
        XmlParser xmlParser = this.getParser(rSyntaxTextArea);
        if (xmlParser != null) {
            rSyntaxTextArea.removeParser(xmlParser);
        }
        this.uninstallKeyboardShortcuts(rSyntaxTextArea);
    }

    @Override
    protected void uninstallKeyboardShortcuts(RSyntaxTextArea rSyntaxTextArea) {
        super.uninstallKeyboardShortcuts(rSyntaxTextArea);
        InputMap inputMap = rSyntaxTextArea.getInputMap();
        ActionMap actionMap = rSyntaxTextArea.getActionMap();
        int n = rSyntaxTextArea.getToolkit().getMenuShortcutKeyMask();
        int n2 = 1;
        inputMap.remove(KeyStroke.getKeyStroke(79, n | n2));
        actionMap.remove("GoToType");
    }
}

