/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ac.xml;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ac.html.AttributeCompletion;
import org.fife.ui.autocomplete.AbstractCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.MarkupTagCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;

class XmlCompletionProvider
extends DefaultCompletionProvider {
    private static final char[] TAG_SELF_CLOSE = new char[]{'/', '>'};

    public XmlCompletionProvider() {
        this.setAutoActivationRules(false, "<");
    }

    private void addCompletionImpl(String string, int n) {
        AbstractCompletion abstractCompletion;
        if (n == 26) {
            abstractCompletion = new MarkupTagCompletion((CompletionProvider)this, string);
        } else {
            ParameterizedCompletion.Parameter parameter = new ParameterizedCompletion.Parameter(null, string);
            abstractCompletion = new AttributeCompletion((CompletionProvider)this, parameter);
        }
        this.completions.add(abstractCompletion);
    }

    private Set<String> collectCompletionWordsAttribute(RSyntaxDocument rSyntaxDocument, Token token, int n) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        String string = token.getLexeme();
        boolean bl = false;
        boolean bl2 = false;
        for (Token token2 : rSyntaxDocument) {
            int n2 = token2.getType();
            if (n2 == 26) {
                bl = string.equals(token2.getLexeme());
                boolean bl3 = bl2 = token2.getOffset() == token.getOffset();
                if (hashSet2.isEmpty()) continue;
                hashSet.addAll(hashSet2);
                hashSet2.clear();
                continue;
            }
            if (n2 != 27 || !bl || token2.getOffset() == n) continue;
            String string2 = token2.getLexeme();
            if (bl2) {
                if (string2.indexOf(60) > -1) {
                    bl = false;
                    hashSet2.clear();
                    continue;
                }
                hashSet3.add(string2);
                continue;
            }
            if (string2.indexOf(60) > -1) {
                bl = false;
                hashSet2.clear();
                hashSet3.clear();
                continue;
            }
            hashSet2.add(string2);
        }
        if (!hashSet2.isEmpty()) {
            hashSet.addAll(hashSet2);
        }
        hashSet.removeAll(hashSet3);
        return hashSet;
    }

    private Set<String> collectCompletionWordsTag(RSyntaxDocument rSyntaxDocument, int n) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Token token : rSyntaxDocument) {
            if (token.getType() != 26 || token.getOffset() == n) continue;
            hashSet.add(token.getLexeme());
        }
        return hashSet;
    }

    @Override
    protected List<Completion> getCompletionsImpl(JTextComponent jTextComponent) {
        this.completions.clear();
        String string = this.getAlreadyEnteredText(jTextComponent);
        if (string == null) {
            return this.completions;
        }
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)jTextComponent;
        int n = rSyntaxTextArea.getCaretPosition();
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
        Token token = RSyntaxUtilities.getPreviousImportantTokenFromOffs(rSyntaxDocument, n);
        if (token == null) {
            UIManager.getLookAndFeel().provideErrorFeedback(rSyntaxTextArea);
            return this.completions;
        }
        int n2 = XmlCompletionProvider.getDesiredTokenType(token, n);
        if (n2 == 0) {
            UIManager.getLookAndFeel().provideErrorFeedback(rSyntaxTextArea);
            return this.completions;
        }
        int n3 = n - string.length();
        Set<String> set = null;
        if (n2 == 26) {
            set = this.collectCompletionWordsTag(rSyntaxDocument, n3);
        } else {
            Token object = XmlCompletionProvider.getTagNameTokenForCaretOffset(rSyntaxTextArea);
            if (object != null) {
                TokenImpl tokenImpl = new TokenImpl(object);
                set = this.collectCompletionWordsAttribute(rSyntaxDocument, tokenImpl, n3);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rSyntaxTextArea);
                return this.completions;
            }
        }
        for (String string2 : set) {
            this.addCompletionImpl(string2, n2);
        }
        Collections.sort(this.completions);
        return super.getCompletionsImpl(jTextComponent);
    }

    private static final int getDesiredTokenType(Token token, int n) {
        switch (token.getType()) {
            case 26: {
                if (token.containsPosition(n - 1)) {
                    return token.getType();
                }
                return 27;
            }
            case 27: {
                return token.getType();
            }
            case 28: {
                if (token.containsPosition(n)) {
                    return 0;
                }
                return 27;
            }
            case 25: {
                if (token.isSingleChar('<')) {
                    return 26;
                }
                return 0;
            }
        }
        return 0;
    }

    public static final Token getTagNameTokenForCaretOffset(RSyntaxTextArea rSyntaxTextArea) {
        int n = rSyntaxTextArea.getCaretPosition();
        int n2 = rSyntaxTextArea.getCaretLineNumber();
        Token token = null;
        block0: do {
            Token token2 = rSyntaxTextArea.getTokenListForLine(n2);
            while (token2 != null && token2.isPaintable()) {
                if (token2.getType() == 26) {
                    token = token2;
                }
                if (token2.getEndOffset() == n || token2.containsPosition(n)) continue block0;
                if (token2.getType() == 25 && (token2.isSingleChar('>') || token2.is(TAG_SELF_CLOSE))) {
                    token = null;
                }
                token2 = token2.getNextToken();
            }
        } while (token == null && --n2 >= 0);
        return token;
    }
}

